/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.tydic.payment.bill.busi.BillAliPayTransCreateBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransCreateBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillAliPayTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPaymentTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillAliPayTransCombService;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="billAliPayTransCombService")
public class BillAliPayTransCombServiceImpl
implements BillAliPayTransCombService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Value(value="${project_name}")
    private String projectName;
    @Autowired
    private BillPaymentTransCreateBusiService billPaymentTransCreateBusiService;
    @Autowired
    private BillAliPayTransCreateBusiService billAliPayTransCreateBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;

    public void aliPayTrams(List<String> rows, String appid) {
        int size = rows.size();
        LocalDateTime startTime = LocalDateTime.now();
        Iterator<String> row = rows.iterator();
        while (row.hasNext()) {
            this.trans(row.next(), appid);
        }
        LocalDateTime endTime = LocalDateTime.now();
        Duration consumeTime = Duration.between(startTime, endTime);
        this.log.info("\u652f\u4ed8\u5b9d \u8d26\u5355\u5165\u5e93\u5b8c\u6210\u3002\u5171\u8ba1\u3010{}\u3011\u6761\u8bb0\u5f55\uff1b\u8017\u65f6\u3010{}\u3011\u79d2\u949f\u3002", (Object)size, (Object)consumeTime.getSeconds());
    }

    public void trans(String rows, String appid) {
        BillAliPayTransCreateReqBO aliPayTrans = this.buildAliPayTrans(rows, appid);
        if (!aliPayTrans.getOutTradeNo().contains(this.projectName)) {
            this.log.info("\u8be5\u8ba2\u5355\u3010{}\u3011\u4e0d\u662f\u652f\u4ed8\u4e2d\u5fc3\u7684\u8ba2\u5355\uff0c\u6545\u4e0d\u8bb0\u5f55", (Object)aliPayTrans.getOutTradeNo());
            return;
        }
        BillPaymentTransCreateReqBO paymentTrans = this.buildPaymentTrans(aliPayTrans);
        this.billAliPayTransCreateBusiService.create(aliPayTrans);
        this.billPaymentTransCreateBusiService.create(paymentTrans);
    }

    private BillPaymentTransCreateReqBO buildPaymentTrans(BillAliPayTransCreateReqBO aliPayTrans) {
        BillPaymentTransCreateReqBO trans = new BillPaymentTransCreateReqBO();
        trans.setBillDate(aliPayTrans.getBillDate());
        trans.setBillFlag("0");
        trans.setPaymentMchId(aliPayTrans.getAppid());
        trans.setTypeTransId(aliPayTrans.getTradeNo());
        trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)aliPayTrans.getTotalAmount().abs()).longValue()));
        trans.setPaymentInsId(BillConstant.PaymentIns.ALI_PAY.getPaymentInsId());
        if (StringUtils.isEmpty((Object)aliPayTrans.getRefundTradeNo())) {
            trans.setTypeOrderId(aliPayTrans.getOutTradeNo());
            QueryPayTransRspBO payOrder = this.queryPayTransBusiService.queryByPayOrderId(aliPayTrans.getOutTradeNo());
            if (payOrder != null) {
                aliPayTrans.setOrderId(payOrder.getOrderId());
                trans.setBusiId(payOrder.getBusiId());
                trans.setOrderId(payOrder.getOrderId());
                trans.setOrderType("01");
            }
        } else {
            trans.setTypeOrderId(aliPayTrans.getRefundTradeNo());
            QueryRefundRspBO refundOrder = this.queryRefundBusiService.queryByRefundOrderId(aliPayTrans.getRefundTradeNo());
            if (refundOrder != null) {
                aliPayTrans.setOrderId(refundOrder.getOrderId());
                trans.setBusiId(refundOrder.getBusiId());
                trans.setOrderId(refundOrder.getOrderId());
                trans.setOrderType("02");
            }
        }
        return trans;
    }

    private BillAliPayTransCreateReqBO buildAliPayTrans(String row, String appid) {
        BillAliPayTransCreateReqBO reqBO = new BillAliPayTransCreateReqBO();
        int index = 0;
        String[] columns = row.trim().replaceAll("\t", "").split(",");
        reqBO.setTradeNo(columns[index++]);
        reqBO.setOutTradeNo(columns[index++]);
        reqBO.setBusiType(columns[index++]);
        reqBO.setSubject(columns[index++]);
        reqBO.setTransTime(columns[index++]);
        reqBO.setFinishTime(columns[index++]);
        reqBO.setStoreId(columns[index++]);
        reqBO.setStoreName(columns[index++]);
        reqBO.setOperatorId(columns[index++]);
        reqBO.setTerminalId(columns[index++]);
        reqBO.setBuyerLogonId(columns[index++]);
        reqBO.setTotalAmount(new BigDecimal(columns[index++]));
        reqBO.setReceiptAmount(new BigDecimal(columns[index++]));
        reqBO.setAlipayAmount(new BigDecimal(columns[index++]));
        reqBO.setPointAmount(new BigDecimal(columns[index++]));
        reqBO.setAlipayDiscountAmount(new BigDecimal(columns[index++]));
        reqBO.setMchDiscountAmount(new BigDecimal(columns[index++]));
        reqBO.setVoucherAmount(new BigDecimal(columns[index++]));
        reqBO.setVoucherName(columns[index++]);
        reqBO.setMchRedAmount(new BigDecimal(columns[index++]));
        reqBO.setCardAmount(new BigDecimal(columns[index++]));
        reqBO.setRefundTradeNo(columns[index++]);
        reqBO.setMerFee(new BigDecimal(columns[index++]));
        reqBO.setFenAmount(new BigDecimal(columns[index++]));
        reqBO.setRemark(columns[index]);
        reqBO.setAppid(appid);
        String billDate = reqBO.getTransTime();
        billDate = billDate.replaceAll("-", "");
        billDate = billDate.substring(0, 8);
        reqBO.setBillDate(Long.valueOf(billDate));
        reqBO.setBillCheckFlag("0");
        return reqBO;
    }
}

