/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.bill.exception.BillCompareException;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.exception.BillException;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.bill.exception.BillSyncSettleTransException;
import com.tydic.payment.bill.executor.BillExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBillExecutor
implements BillExecutor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void invoke(BillExecuteRequest request) throws BillException {
        if (request.getBillExecuteStep() != null) {
            this.cleanData(request);
        }
        this.downAndTrans(request);
        this.syncPayDay(request);
        this.compare(request);
        this.balance(request);
        this.syncSettleTrans(request);
    }

    protected abstract void cleanData(BillExecuteRequest var1);

    protected abstract void downAndTrans(BillExecuteRequest var1) throws BillDownAndTransException;

    protected abstract void syncSettleTrans(BillExecuteRequest var1) throws BillSyncSettleTransException;

    protected abstract void balance(BillExecuteRequest var1) throws BillBalanceException;

    protected abstract void compare(BillExecuteRequest var1) throws BillCompareException;

    protected abstract void syncPayDay(BillExecuteRequest var1) throws BillSyncPayDayException;
}

