/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor.busi;

import com.tydic.payment.bill.able.BillBusiFileGenerateAble;
import com.tydic.payment.bill.able.BillBusiFileGenerateInfo;
import com.tydic.payment.bill.able.BillBusiTransInfo;
import com.tydic.payment.bill.constant.BillFileManager;
import com.tydic.payment.bill.util.DateUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DefaultBillBusiFileGenerate
implements BillBusiFileGenerateAble {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FILED_SEPARATOR = ",";
    private static final String FILE_LOCAL_PATH = "upload";
    private static final String FILE_CHARSET = "UTF-8";
    private static final String CHANGE_LINE = "\n";

    @Override
    public FileInputStream generateFile(BillBusiFileGenerateInfo info) throws Exception {
        File billFile;
        String busiSysSavePath = BillFileManager.getBusiSysSavePath();
        File dir = new File(busiSysSavePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((billFile = new File(dir, info.getFileName())).exists()) {
            billFile.delete();
        }
        billFile.createNewFile();
        this.logger.debug("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)billFile.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(billFile, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, FILE_CHARSET);
        BufferedWriter writer = new BufferedWriter(osw);
        writer.write(this.getFileHead(info));
        writer.write(CHANGE_LINE);
        StringBuffer row = new StringBuffer();
        String createDate = DateUtil.DateToStryyyyMMdd(new Date());
        List<BillBusiTransInfo> transList = info.getTransInfoList();
        for (BillBusiTransInfo trans : transList) {
            writer.write(this.getFileBody(trans, row, createDate));
            writer.write(CHANGE_LINE);
            row.delete(0, row.length());
        }
        writer.close();
        osw.close();
        fos.close();
        return new FileInputStream(billFile);
    }

    private String getFileBody(BillBusiTransInfo trans, StringBuffer row, String createDate) {
        row.append(createDate);
        row.append(FILED_SEPARATOR);
        row.append(trans.getOrderId());
        row.append(FILED_SEPARATOR);
        row.append(trans.getBusiId());
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getOrderType()));
        row.append(FILED_SEPARATOR);
        row.append(trans.getPayMethod());
        row.append(FILED_SEPARATOR);
        row.append(trans.getOutOrderId());
        row.append(FILED_SEPARATOR);
        row.append(trans.getTotalFee());
        row.append(FILED_SEPARATOR);
        row.append(trans.getRealFee());
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullLong(trans.getDiscountFee()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getRefundNo()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getProvinceId()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getCityId()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getDistrictId()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getChannelId()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getCreateOperId()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getTradeTime()));
        row.append(FILED_SEPARATOR);
        row.append(trans.getMerchantId());
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getUserAccount()));
        row.append(FILED_SEPARATOR);
        row.append(this.convertNullString(trans.getUserMobile()));
        return row.toString();
    }

    private String getFileHead(BillBusiFileGenerateInfo info) {
        StringBuffer fileHead = new StringBuffer();
        fileHead.append(info.getItemFileNo());
        fileHead.append(FILED_SEPARATOR);
        fileHead.append(info.getTransInfoList().size());
        fileHead.append(FILED_SEPARATOR);
        fileHead.append(info.getBillDate());
        fileHead.append("000000");
        fileHead.append(FILED_SEPARATOR);
        fileHead.append(info.getBillDate());
        fileHead.append("235959");
        fileHead.append(FILED_SEPARATOR);
        fileHead.append(info.getCountFileNo());
        return fileHead.toString();
    }

    private String convertNullString(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "";
        }
        if ("null".equals(value.trim())) {
            return "";
        }
        return value;
    }

    private String convertNullLong(Long value) {
        if (null == value) {
            return "0";
        }
        return value.toString();
    }
}

