/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.IcbcMemberQryService;
import com.tydic.payment.pay.ability.bo.IcbcMemberQryServiceReqBO;
import com.tydic.payment.pay.ability.bo.IcbcMemberQryServiceRspBO;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.DefaultIcbcClient;
import com.tydic.payment.pay.icbc.IcbcApiException;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayMemberqueryRequestV1;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayMemberqueryRequestV1Biz;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayMemberqueryResponseV1;
import com.tydic.payment.pay.icbc.intf.BizContent;
import com.tydic.payment.pay.icbc.intf.IcbcRequest;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.IcbcMemberQryService"})
public class IcbcMemberQryServiceImpl
implements IcbcMemberQryService {
    private static final Logger log = LoggerFactory.getLogger(IcbcMemberQryServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;
    private static String ICBC_APP_ID;
    private static String ICBC_AGREEMENT_CODE;
    private static String ICBC_PRIVATE_KEY;
    private static String ICBC_PUBLIC_KEY;
    public static final String STATUS = "memberStatus";
    @Value(value="${icbc.epay.member.qry.url:123}")
    private String qryUrl;

    @PostMapping(value={"qryMember"})
    public IcbcMemberQryServiceRspBO qryMember(@RequestBody IcbcMemberQryServiceReqBO reqBO) {
        IcbcMemberQryServiceRspBO rspBO = new IcbcMemberQryServiceRspBO();
        String valid = this.init();
        if (!StringUtils.isEmpty((Object)valid)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(valid);
            return rspBO;
        }
        log.info("#######################\u4f1a\u5458\u72b6\u6001\u67e5\u8be2\u5f00\u59cb###########################");
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        String merchantNoStr = reqBO.getMerchantId().toString();
        String memberNo = merchantNoStr.length() > 15 ? merchantNoStr.substring(0, 15) : merchantNoStr;
        MybankPayCpayMemberqueryRequestV1 qryReq = new MybankPayCpayMemberqueryRequestV1();
        qryReq.setServiceUrl(this.qryUrl);
        MybankPayCpayMemberqueryRequestV1Biz qryBiz = new MybankPayCpayMemberqueryRequestV1Biz();
        qryBiz.setAgreeCode(ICBC_AGREEMENT_CODE);
        qryBiz.setMemberNo(memberNo);
        qryReq.setBizContent((BizContent)qryBiz);
        MybankPayCpayMemberqueryResponseV1 qryResponse = new MybankPayCpayMemberqueryResponseV1();
        String qryMsgId = PayProSequence.nextId() + "msg";
        try {
            log.info("\u5de5\u884c\u4f1a\u5458\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qryReq));
            qryResponse = (MybankPayCpayMemberqueryResponseV1)client.execute((IcbcRequest)qryReq, qryMsgId);
            log.info("\u5de5\u884c\u4f1a\u5458\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qryResponse));
            if (!qryResponse.isSuccess()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(qryResponse.getReturnMsg());
                return rspBO;
            }
        }
        catch (IcbcApiException e) {
            e.printStackTrace();
        }
        Integer status = null;
        List memInfoList = qryResponse.getMemInfoList();
        if (!CollectionUtils.isEmpty((Collection)memInfoList) && !ObjectUtils.isEmpty(memInfoList.get(0))) {
            status = ((MybankPayCpayMemberqueryResponseV1.MemInfoListDTO)memInfoList.get(0)).getStatus();
        }
        log.info("#######################\u4f1a\u5458\u72b6\u6001\u67e5\u8be2\u7ed3\u675f###########################");
        log.info("\u4f1a\u5458\u72b6\u6001\u67e5\u8be2\u7ed3\u679c\u4e3a\u4e3a\uff1a{}--->(0-\u672a\u542f\u7528\uff0c1-\u6b63\u5e38\uff0c2-\u4f5c\u5e9f\uff0c3-\u5f85\u8ba4\u8bc1\uff0c4-\u8ba4\u8bc1\u62d2\u7edd)", status);
        if (status == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        log.info("#######################\u4f1a\u5458\u72b6\u6001\u66f4\u65b0\u5f00\u59cb###########################");
        MerchantPayMethodRelPo qryRelPo = new MerchantPayMethodRelPo();
        qryRelPo.setPayMethod(190L);
        qryRelPo.setMerchantId(reqBO.getMerchantId());
        qryRelPo.setPaymentInsId(19L);
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryRelPo);
        if (CollectionUtils.isEmpty(queryMerchantPayMethodRelByCondition)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u914d\u7f6e\u5de5\u884c\u4fe1\u606f");
            return rspBO;
        }
        MerchantPayMethodRelPo merchantPayMethodRelPo = queryMerchantPayMethodRelByCondition.get(0);
        PayParaInfoAttrPo queryPayAttrPo = new PayParaInfoAttrPo();
        queryPayAttrPo.setPayParaId(merchantPayMethodRelPo.getPayParaId());
        List<PayParaInfoAttrPo> queryPayParaInfoAttrByCondition = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(queryPayAttrPo);
        log.info("###########" + JSON.toJSONString(queryPayParaInfoAttrByCondition));
        List list = queryPayParaInfoAttrByCondition.stream().filter(bo -> bo.getAttrCode().equals(STATUS)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38");
            return rspBO;
        }
        PayParaInfoAttrPo payParaInfoAttrPo = (PayParaInfoAttrPo)list.get(0);
        payParaInfoAttrPo.setAttrValue(status.toString());
        int update = this.payParaInfoAttrMapper.updatePayParaInfoAttr(payParaInfoAttrPo);
        if (update < 0) {
            throw new BusinessException("8888", "\u66f4\u65b0\u5de5\u884c\u4f1a\u5458\u6863\u6848\u72b6\u6001\u5931\u8d25\uff01");
        }
        log.info("#######################\u4f1a\u5458\u72b6\u6001\u66f4\u65b0\u7ed3\u675f###########################");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setStatus(status);
        return rspBO;
    }

    protected String init() {
        ICBC_APP_ID = this.payPropertiesVo.getValueByKey("icbc.epay.app.id");
        if (StringUtils.isEmpty((Object)ICBC_APP_ID)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884cAPP_ID\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.app.id");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884cAPP_ID\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.app.id";
        }
        ICBC_AGREEMENT_CODE = this.payPropertiesVo.getValueByKey("icbc.epay.agreement.code");
        if (StringUtils.isEmpty((Object)ICBC_AGREEMENT_CODE)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u534f\u8bae\u7f16\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.agreement.code");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u534f\u8bae\u7f16\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.agreement.code";
        }
        ICBC_PRIVATE_KEY = this.payPropertiesVo.getValueByKey("icbc.epay.private.key");
        if (StringUtils.isEmpty((Object)ICBC_PRIVATE_KEY)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.private.key");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.private.key";
        }
        ICBC_PUBLIC_KEY = this.payPropertiesVo.getValueByKey("icbc.epay.public.key");
        if (StringUtils.isEmpty((Object)ICBC_PUBLIC_KEY)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.public.key");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.public.key";
        }
        return null;
    }
}

