/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.ability.PayProBillDetailListQryAbilityService;
import com.tydic.payment.pay.ability.bo.PayProBillDetailListQryAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProBillDetailListQryAbilityRspBo;
import com.tydic.payment.pay.ability.impl.PayProBillResultDataQryAbilityServiceImpl;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.common.base.bo.PayProPageRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PaySettleTransMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaySettleTransPO;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayProRspPageUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProBillDetailListQryAbilityService"})
public class PayProBillDetailListQryAbilityServiceImpl
implements PayProBillDetailListQryAbilityService {
    @Autowired
    private PaySettleTransMapper paySettleTransMapper;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    @PostMapping(value={"qryDetailList"})
    public PayProPageRspBo<PayProBillDetailListQryAbilityRspBo> qryDetailList(@RequestBody PayProBillDetailListQryAbilityReqBo reqBo) {
        PayProPageRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProPageRspBo.class);
        ArgValidator.validateArgWithThrow((Object)reqBo);
        Long startDate = reqBo.getStartDate();
        Long endDate = reqBo.getEndDate();
        if ((startDate == null || startDate <= 0L) && endDate != null && endDate > 0L) {
            throw new IllegalArgumentException("\u8d77\u6b62\u65f6\u95f4\u9700\u540c\u65f6\u5b58\u5728");
        }
        if ((endDate == null || endDate <= 0L) && startDate != null && startDate > 0L) {
            throw new IllegalArgumentException("\u8d77\u6b62\u65f6\u95f4\u9700\u540c\u65f6\u5b58\u5728");
        }
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        PaySettleTransPO qryPo = new PaySettleTransPO();
        if (startDate != null && startDate > 0L) {
            qryPo.setBillStartDate(reqBo.getStartDate());
            qryPo.setBillEndDate(reqBo.getEndDate());
        }
        qryPo.setBillTransId(reqBo.getTransactionId());
        qryPo.setOutOrderId(reqBo.getPayOutOrderId());
        if (!StrUtil.isEmpty((CharSequence)reqBo.getRefundOutOrderId())) {
            qryPo.setOutOrderId(reqBo.getRefundOutOrderId());
        }
        List<PaySettleTransPO> listPage = this.paySettleTransMapper.getListPage((Page<PaySettleTransPO>)page, qryPo);
        PayProRspPageUtil.fillPageArg(rspBo, page);
        for (PaySettleTransPO tmp : listPage) {
            PayProBillDetailListQryAbilityRspBo ret = new PayProBillDetailListQryAbilityRspBo();
            BeanUtils.copyProperties((Object)tmp, (Object)ret);
            ret.setBillDate(PayProBillResultDataQryAbilityServiceImpl.convertBillDate(tmp.getBillDate()));
            if ("01".equals(tmp.getOrderType())) {
                ret.setPayOutOrderId(tmp.getOutOrderId());
            } else {
                ret.setRefundOutOrderId(tmp.getOutOrderId());
            }
            ret.setOrderDate(new DateTime((Object)tmp.getCreateTime()).toString("yyyy-MM-dd"));
            ret.setPayOrderFee(MoneyUtils.fenToYuan((Long)tmp.getRealFee()));
            ret.setPayCenterFee(MoneyUtils.fenToYuan((Long)tmp.getRealFee()));
            ret.setTransactionId(tmp.getBillTransId());
            ret.setPayTransDate(PayProBillResultDataQryAbilityServiceImpl.convertBillDate(tmp.getBillDate()));
            ret.setPayedDate(PayProBillResultDataQryAbilityServiceImpl.convertBillDate(tmp.getBillDate()));
            ret.setTradeTime(PayProBillDetailListQryAbilityServiceImpl.convertTime(tmp.getTradeTime()));
            ret.setOrderType(tmp.getOrderType());
            this.TransInfo(ret);
            rspBo.getData().getRows().add(ret);
        }
        return rspBo;
    }

    private void TransInfo(PayProBillDetailListQryAbilityRspBo ret) {
        PayMethodPo methodInfo;
        MerChantInfoPo merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(ret.getMerchantId());
        if (null != merChantInfo) {
            ret.setMerchantName(merChantInfo.getMerchantName());
        }
        if (null != (methodInfo = this.payMethodAtomService.queryPayMethodById(ret.getPayMethod()))) {
            ret.setPayMethodName(methodInfo.getPayMethodName());
        }
        PaymentInsPo paymentInsPo = new PaymentInsPo();
        paymentInsPo.setPaymentInsId(ret.getPaymentInsId());
        List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
        if (!CollectionUtils.isEmpty(paymentInsList)) {
            PaymentInsPo paymentInsInfo = paymentInsList.get(0);
            ret.setPaymentInsName(paymentInsInfo.getPaymentInsName());
        }
    }

    private static String convertTime(String date) {
        if (StrUtil.isEmpty((CharSequence)date)) {
            return "";
        }
        String format = "yyyyMMddHHmmss";
        String toString = "yyyy-MM-dd HH:mm:ss";
        if (8 == date.length()) {
            format = "yyyyMMdd";
            toString = "yyyy-MM-dd";
        }
        DateTimeFormatter forPattern = DateTimeFormat.forPattern((String)format);
        DateTime dateTime = forPattern.parseDateTime(date);
        return dateTime.toString(toString);
    }
}

