/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProGetMerchantPayeeInfoAbilityService;
import com.tydic.payment.pay.ability.bo.PayProGetMerchantPayeeInfoAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProGetMerchantPayeeInfoAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProGetMerchantPayeeInfoAbilityService"})
public class PayProGetMerchantPayeeInfoAbilityServiceImpl
implements PayProGetMerchantPayeeInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProGetMerchantPayeeInfoAbilityServiceImpl.class);
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PaymentInsAtomService paymentInfAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;
    @Value(value="${paymentIns.para.supported:19}")
    private String supports;
    private Set<String> payMethodSet = new HashSet<String>();

    @PostConstruct
    public void initObject() {
        if (!StringUtils.isEmpty((Object)this.supports)) {
            Collections.addAll(this.payMethodSet, this.supports.split(","));
        }
    }

    @PostMapping(value={"getPayeeInfo"})
    public PayProGetMerchantPayeeInfoAbilityRspBo getPayeeInfo(@RequestBody PayProGetMerchantPayeeInfoAbilityReqBo reqBo) {
        PayProGetMerchantPayeeInfoAbilityRspBo retBo = PayProRspUtil.generateSucRspBo(PayProGetMerchantPayeeInfoAbilityRspBo.class);
        log.debug("=========\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u673a\u6784\u7684\u53c2\u6570\u4fe1\u606f\u670d\u52a1\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long merchantId = Long.valueOf(reqBo.getMerchantId());
        Long paymentInsId = Long.valueOf(reqBo.getPaymentInsId());
        if (!this.payMethodSet.contains(reqBo.getPaymentInsId())) {
            log.error("\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u8be5\u652f\u4ed8\u673a\u6784\uff1a{}", (Object)paymentInsId);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u8be5\u652f\u4ed8\u673a\u6784\uff1a" + paymentInsId);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode(busiCodeRspBo.getRespCode());
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode(busiCodeRspBo.getRespCode());
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        this.getPaymentParaInfo(merchantId, paymentInsId, retBo);
        log.debug("=======\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u673a\u6784\u7684\u53c2\u6570\u4fe1\u606f\u670d\u52a1\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private void getPaymentParaInfo(Long merchantId, Long paymentInsId, PayProGetMerchantPayeeInfoAbilityRspBo retBo) {
        MerchantPayMethodRelPo relQryReqBo = new MerchantPayMethodRelPo();
        relQryReqBo.setMerchantId(merchantId);
        relQryReqBo.setPaymentInsId(paymentInsId);
        List<MerchantPayMethodRelPo> relRelPos = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(relQryReqBo);
        if (CollectionUtils.isEmpty(relRelPos)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5546\u6237ID:{}\u548c\u652f\u4ed8\u673a\u6784ID\uff1a{}\u7684\u5173\u7cfb\u4fe1\u606f", (Object)merchantId, (Object)paymentInsId);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237ID:" + merchantId + "\u548c\u652f\u4ed8\u673a\u6784ID\uff1a" + paymentInsId + "\u7684\u5173\u7cfb\u4fe1\u606f");
            return;
        }
        PaymentInsPo queryPo = new PaymentInsPo();
        queryPo.setPaymentInsId(paymentInsId);
        List<PaymentInsPo> paymentInfos = this.paymentInfAtomService.queryPaymentInf(queryPo);
        if (CollectionUtils.isEmpty(paymentInfos)) {
            log.error("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784ID\uff1a{}\u7684\u4fe1\u606f", (Object)paymentInsId);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u652f\u4ed8\u673a\u6784ID\uff1a" + paymentInsId + "\u7684\u4fe1\u606f");
            return;
        }
        PaymentInsPo paymentInfo = paymentInfos.get(0);
        retBo.setPaymentInsName(paymentInfo.getPaymentInsName());
        retBo.setPaymentInsId(paymentInsId.toString());
        PayRuleParaPo ruleParaReqPo = new PayRuleParaPo();
        ruleParaReqPo.setPaymentInsId(paymentInsId);
        List<PayRuleParaPo> ruleParaInfos = this.payRuleParaAtomService.queryPayRuleParaByCondition(ruleParaReqPo);
        if (CollectionUtils.isEmpty(ruleParaInfos)) {
            log.error("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784ID\uff1a{}\u7684\u53c2\u6570\u4fe1\u606f", (Object)paymentInsId);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u652f\u4ed8\u673a\u6784ID\uff1a" + paymentInsId + "\u7684\u53c2\u6570\u4fe1\u606f");
            return;
        }
        HashMap<String, String> ruleMap = new HashMap<String, String>(16);
        for (PayRuleParaPo paraPo : ruleParaInfos) {
            ruleMap.put(paraPo.getParameterCode(), paraPo.getParameterName());
        }
        PayParaInfoAttrPo paraInfoAttrReqBo = new PayParaInfoAttrPo();
        paraInfoAttrReqBo.setPayParaId(relRelPos.get(0).getPayParaId());
        List<PayParaInfoAttrPo> paraInfoAttrs = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(paraInfoAttrReqBo);
        if (CollectionUtils.isEmpty(paraInfoAttrs)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5546\u6237ID:{}\u914d\u7f6e\u7684\u652f\u4ed8\u673a\u6784ID\uff1a{}\u7684\u53c2\u6570\u4fe1\u606f", (Object)merchantId, (Object)paymentInsId);
            retBo.setRespCode("214034");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237ID:" + merchantId + "\u914d\u7f6e\u7684\u652f\u4ed8\u673a\u6784ID\uff1a" + paymentInsId + "\u53c2\u6570\u4fe1\u606f");
            return;
        }
        ArrayList<PayProPayInsParaDataBo> payeeInfos = new ArrayList<PayProPayInsParaDataBo>();
        for (PayParaInfoAttrPo attrPo : paraInfoAttrs) {
            PayProPayInsParaDataBo paraDataBo = new PayProPayInsParaDataBo();
            paraDataBo.setParameterName((String)ruleMap.get(attrPo.getAttrCode()));
            paraDataBo.setParameterCode(attrPo.getAttrCode());
            paraDataBo.setParameterValue(attrPo.getAttrValue());
            payeeInfos.add(paraDataBo);
        }
        retBo.setPayeeInfos(payeeInfos);
    }

    private String validateArgs(PayProGetMerchantPayeeInfoAbilityReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiCdoe'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paymentInsId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.valueOf(reqBo.getPaymentInsId());
            Long.valueOf(reqBo.getMerchantId());
        }
        catch (NumberFormatException e) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paymentInsId'\u548c'merchantId'\u5fc5\u987b\u4e3a\u7eaf\u6570\u5b57";
        }
        return null;
    }
}

