/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.tydic.payment.pay.ability.PayProOrderRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderRefundAbilityRspBo;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.RefundCombService;
import com.tydic.payment.pay.comb.bo.RefundCombReqBO;
import com.tydic.payment.pay.comb.bo.RefundCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProOrderRefundAbilityService"})
public class PayProOrderRefundAbilityServiceImpl
implements PayProOrderRefundAbilityService {
    private Logger LOG = LoggerFactory.getLogger(PayProOrderRefundAbilityServiceImpl.class);
    @Autowired
    private RefundCombService refundCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;

    @PostMapping(value={"refund"})
    public PayProOrderRefundAbilityRspBo refund(@RequestBody PayProOrderRefundAbilityReqBo reqBo) {
        PayProOrderRefundAbilityRspBo retBo = new PayProOrderRefundAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        String oriOrderId = reqBo.getOriOrderId();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214005");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214005");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        PorderPo qryPo = new PorderPo();
        qryPo.setOutOrderId(oriOrderId);
        List<PorderPo> porderPos = this.payOrderAtomService.queryRefundListByCondition(qryPo);
        if (porderPos.isEmpty()) {
            retBo.setRespCode("214005");
            retBo.setRespDesc("\u8be5\u8ba2\u5355" + oriOrderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        long totalFee = MoneyUtils.haoToFen((Long)porderPos.get(0).getTotalFee()).longValue();
        RefundCombReqBO refundCombBo = new RefundCombReqBO();
        refundCombBo.setBusiCode(reqBo.getBusiCode());
        refundCombBo.setBusiId(busiCodeRspBo.getBusiId() + "");
        refundCombBo.setOrderType("02");
        refundCombBo.setOutOrderId(reqBo.getOutOrderId());
        refundCombBo.setOutRefundId(oriOrderId);
        refundCombBo.setRefundFee(totalFee + "");
        refundCombBo.setRefundFlag("0");
        try {
            RefundCombRspBO refundCombRspBO = this.refundCombService.dealRefund(refundCombBo);
            BeanUtils.copyProperties((Object)refundCombRspBO, (Object)retBo);
            retBo.setRespCode(refundCombRspBO.getRspCode());
            retBo.setRespDesc(refundCombRspBO.getRspName());
        }
        catch (Exception e) {
            this.LOG.error("\u8c03\u7528\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        return retBo;
    }

    private String validateArg(PayProOrderRefundAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOriOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

