/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.ability.PayProPageQryMerchantInfoAbilityService;
import com.tydic.payment.pay.ability.bo.PayProMerchantInfoDataBo;
import com.tydic.payment.pay.ability.bo.PayProPageQryMerchantInfoReqBo;
import com.tydic.payment.pay.ability.bo.PayProPageQryMerchantInfoRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.common.base.bo.PayFrontPageRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantInfoPageReqPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProPageQryMerchantInfoAbilityService"})
public class PayProPageQryMerchantInfoAbilityServiceImpl
implements PayProPageQryMerchantInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProPageQryMerchantInfoAbilityServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"qryMerchantInfos"})
    public PayProPageQryMerchantInfoRspBo qryMerchantInfos(@RequestBody PayProPageQryMerchantInfoReqBo reqBo) {
        log.debug("==\u5546\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u670d\u52a1\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        PayProPageQryMerchantInfoRspBo retBo = new PayProPageQryMerchantInfoRspBo();
        ArrayList<PayProMerchantInfoDataBo> retRows = new ArrayList<PayProMerchantInfoDataBo>();
        PayFrontPageRspBo retData = new PayFrontPageRspBo();
        retData.setRows(retRows);
        retBo.setData((Object)retData);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Page<MerchantInfoPageReqPO> page = this.getPage(reqBo);
        MerchantInfoPageReqPO qryPo = new MerchantInfoPageReqPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)qryPo));
        qryPo.setFlag(reqBo.getStatus());
        List<MerChantInfoPo> queryRspList = this.merchantInfoAtomService.queryMerChantInfoWithPage(page, qryPo);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        if (!CollectionUtils.isEmpty(queryRspList)) {
            for (MerChantInfoPo tempPo : queryRspList) {
                PayProMerchantInfoDataBo dataBo = new PayProMerchantInfoDataBo();
                BeanUtils.copyProperties((Object)tempPo, (Object)dataBo);
                dataBo.setStatus(tempPo.getFlag());
                dataBo.setMerchantTypeDesc(dicMap.get("MERCHANT_TYPE").get(dataBo.getMerchantType().toString()));
                dataBo.setStatusDesc(dicMap.get("MERCHANT_FLAG").get(dataBo.getStatus()));
                dataBo.setCreateTime(tempPo.getCreateTime() == null ? "" : new DateTime((Object)tempPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                dataBo.setUpdateTime(tempPo.getUpdateTime() == null ? "" : new DateTime((Object)tempPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                retRows.add(dataBo);
            }
        }
        retData.setPageNo(page.getPageNo());
        retData.setRecordsTotal(page.getTotalCount());
        retData.setTotal(page.getTotalPages());
        log.debug("==\u5546\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u670d\u52a1\u7ed3\u675f,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        List codesL;
        List codeL;
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCode = new QueryCodeListByTypecodeReqBo();
        qryPCode.setTypeCode("MERCHANT_TYPE");
        QueryCodeListByTypecodeRspBo qryPCodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCode);
        if (qryPCodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codeL = qryPCodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codeL) {
                typeMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        dicMap.put("MERCHANT_TYPE", typeMap);
        HashMap<String, String> flagMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCFlagode = new QueryCodeListByTypecodeReqBo();
        qryPCFlagode.setTypeCode("MERCHANT_FLAG");
        QueryCodeListByTypecodeRspBo qryPCFlagodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCFlagode);
        if (qryPCFlagodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codesL = qryPCFlagodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codesL) {
                flagMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        dicMap.put("MERCHANT_FLAG", flagMap);
        return dicMap;
    }

    private Page<MerchantInfoPageReqPO> getPage(PayProPageQryMerchantInfoReqBo reqBo) {
        Page page = new Page();
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

