/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayAbleRefundCombService;
import com.tydic.payment.pay.comb.bo.PayAbleRefundCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleRefundCombRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProRefundAbilityService"})
public class PayProRefundAbilityServiceImpl
implements PayProRefundAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProRefundAbilityServiceImpl.class);
    @Autowired
    private PayAbleRefundCombService payAbleRefundCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService payProQueryInfoBusiSystemByConditionService;

    @PostMapping(value={"dealRefund"})
    public PayProRefundAbilityRspBo dealRefund(@RequestBody PayProRefundAbilityReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("payPro\u9000\u6b3eability\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProRefundAbilityRspBo retBo = new PayProRefundAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214007");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRetBo = this.payProQueryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(reqBo.getBusiCode());
        if (!"0000".equals(busiCodeRetBo.getRespCode())) {
            retBo.setRespCode("214007");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25,busiCode:" + reqBo.getBusiCode());
            return retBo;
        }
        PayAbleRefundCombReqBo combRefundBo = new PayAbleRefundCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combRefundBo);
        combRefundBo.setRefundFee(Long.valueOf(Long.parseLong(reqBo.getRefundFee())));
        combRefundBo.setBusiId(busiCodeRetBo.getBusiId());
        PayAbleRefundCombRspBo payAbleRefundCombRspBo = this.payAbleRefundCombService.dealRefund(combRefundBo);
        if (!"0000".equals(payAbleRefundCombRspBo.getRespCode())) {
            retBo.setRespCode("214007");
            retBo.setRespDesc(payAbleRefundCombRspBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)payAbleRefundCombRspBo, (Object)retBo);
        retBo.setRefundFee(reqBo.getRefundFee());
        retBo.setPayCenterRefundTransOrderId(payAbleRefundCombRspBo.getPayCenterRefundOrderId() + "");
        retBo.setResultCode("SUCCESS");
        retBo.setResultMsg("\u9000\u6b3e\u6210\u529f");
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setRefundRspExtendValue1(payAbleRefundCombRspBo.getWebUrl());
        if (StringUtils.isEmpty((Object)payAbleRefundCombRspBo.getRefundTransId()) || StringUtils.isEmpty((Object)payAbleRefundCombRspBo.getTradeTime())) {
            retBo.setResultCode("SUBMITTED");
            retBo.setResultMsg("\u9000\u6b3e\u7533\u8bf7\u63d0\u4ea4\u6210\u529f");
        }
        return retBo;
    }

    private String validateArg(PayProRefundAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOriOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String refundFee = reqBo.getRefundFee();
        if (StringUtils.isEmpty((Object)refundFee)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.parseLong(refundFee);
        }
        catch (NumberFormatException e) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u5fc5\u987b\u4e3a\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

