/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.PayProWebRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProWebRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProWebRefundAbilityRspBo;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProWebRefundAbilityService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProWebRefundAbilityService"})
public class PayProWebRefundAbilityServiceImpl
implements PayProWebRefundAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProWebRefundAbilityServiceImpl.class);
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"refund"})
    public PayProWebRefundAbilityRspBo refund(@RequestBody PayProWebRefundAbilityReqBo reqBo) {
        PayProWebRefundAbilityRspBo retBo = new PayProWebRefundAbilityRspBo();
        log.info("\u8fdb\u5165\u652f\u4ed8web\u7ba1\u7406\u9875\u9762\u9000\u6b3e\u6309\u94aeability\u670d\u52a1\uff0c\u5165\u53c2\u4e3a\uff1a" + reqBo);
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long orderId = Long.parseLong(reqBo.getOrderId());
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        if (!"0000".equals(payOrderRspBo.getRspCode())) {
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        String resuitMsg = "";
        if (StringUtils.isEmpty((Object)payOrderRspBo.getOrderId())) {
            resuitMsg = "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u6570\u636e\uff01";
            log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6570\u636e orderId = " + payOrderRspBo.getOrderId());
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u5931\u8d25\uff01");
            retBo.setResultCode("FAIL");
            retBo.setResultMsg(resuitMsg);
            return retBo;
        }
        if (!"A10".equals(payOrderRspBo.getOrderStatus())) {
            resuitMsg = "\u8be5\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\uff01";
            log.info("\u8be5\u8ba2\u5355\uff08" + payOrderRspBo.getOrderId() + ")\u672a\u652f\u4ed8\u6210\u529f\uff01");
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u8be5\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\uff01");
            retBo.setResultCode("FAIL");
            retBo.setResultMsg(resuitMsg);
            return retBo;
        }
        PorderPayTransAtomReqBo qryTransBo = new PorderPayTransAtomReqBo();
        qryTransBo.setOrderId(orderId);
        qryTransBo.setOrderStatus("A10");
        List<PorderPayTransAtomRspBo> porderPayTransAtomRspBos = this.porderPayTransAtomService.queryOrderPayTransByCondition(qryTransBo);
        if (porderPayTransAtomRspBos.isEmpty()) {
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u8ba2\u5355(" + orderId + ")\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u7684\u652f\u4ed8\u5355");
            return retBo;
        }
        Long payMethod = porderPayTransAtomRspBos.get(0).getPayMethod();
        if ("121".equals(payMethod.toString())) {
            resuitMsg = "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u4e0d\u80fd\u5728\u6b64\u9000\u6b3e\uff01";
            log.info("\u8be5\u8ba2\u5355\uff08" + payOrderRspBo.getOrderId() + ")\u4e3a\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u652f\u4ed8\uff0c\u4e0d\u80fd\u5728\u6b64\u9000\u6b3e\uff01");
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u4e0d\u80fd\u5728\u6b64\u9000\u6b3e\uff01");
            retBo.setResultCode("FAIL");
            retBo.setResultMsg(resuitMsg);
            return retBo;
        }
        if (payOrderRspBo.getTotalFee() - payOrderRspBo.getRefundFee() == 0L) {
            resuitMsg = "\u8be5\u8ba2\u5355\u53f7 orderId =" + payOrderRspBo.getOrderId() + "\u65e0\u53ef\u9000\u91d1\u989d\uff01";
            log.info("\u8ba2\u5355\u53f7 orderId =" + payOrderRspBo.getOrderId() + "\u65e0\u53ef\u9000\u91d1\u989d\uff01");
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u5df2\u9000\u6b3e\uff0c\u65e0\u53ef\u9000\u91d1\u989d\uff01");
            retBo.setResultCode("FAIL");
            retBo.setResultMsg(resuitMsg);
            return retBo;
        }
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        Long realRefundFee = payOrderRspBo.getTotalFee() - payOrderRspBo.getRefundFee();
        String refundOutOrderId = "WEB_REFUND" + System.currentTimeMillis();
        if (payOrderRspBo.getRefundFee() == 0L) {
            log.info("\u8be5\u8ba2\u5355\u53f7 orderId =" + payOrderRspBo.getOrderId() + "\u4e3a\u5168\u989d\u9000\u6b3e\uff01");
            payProRefundAbilityReqBo.setOrderType("02");
        } else {
            log.info("\u8be5\u8ba2\u5355\u53f7 orderId =" + payOrderRspBo.getOrderId() + "\u4e3a\u90e8\u5206\u91d1\u989d\u9000\u6b3e\uff01");
            payProRefundAbilityReqBo.setOrderType("06");
        }
        payProRefundAbilityReqBo.setBusiCode(payOrderRspBo.getBusiCode());
        payProRefundAbilityReqBo.setRefundFee(MoneyUtils.haoToFen((Long)realRefundFee).longValue() + "");
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOutOrderId);
        payProRefundAbilityReqBo.setOriOutOrderId(payOrderRspBo.getOutOrderId());
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = null;
        try {
            payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        }
        catch (Exception e) {
            resuitMsg = e.getMessage();
            log.error("\u8c03\u7528\u9000\u6b3eAbility\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            retBo.setRespCode("214016");
            retBo.setRespDesc("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u6355\u6349\u5230\u5f02\u5e38\uff01");
            retBo.setResultCode("FAIL");
            retBo.setResultMsg(resuitMsg);
            return retBo;
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u9000\u6b3e\u5931\u8d25\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            retBo.setRespCode("214016");
            retBo.setRespDesc(payProRefundAbilityRspBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)payProRefundAbilityRspBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u9000\u6b3e\u6210\u529f\uff01");
        log.info("\u9000\u6b3e\u6210\u529f\uff01");
        return retBo;
    }

    private String validateArg(PayProWebRefundAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027OrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

