/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.PayProQuerySysCacheAtomService;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.constant.PayProCacheKeys;
import com.tydic.payment.pay.dao.BusiSystemInfoMapper;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayProQuerySysCacheAtomServiceImpl
implements PayProQuerySysCacheAtomService {
    @Autowired
    private BusiSystemInfoMapper busiSystemInfoMapper;
    @Autowired
    private PayProCacheManager payProCacheManager;

    @Override
    public List<BusiSystemInfoPO> querySysWithCache(BusiSystemInfoPO reqPo) {
        if (reqPo == null) {
            reqPo = new BusiSystemInfoPO();
        }
        ArrayList<BusiSystemInfoPO> retList = new ArrayList<BusiSystemInfoPO>();
        Long busiId = reqPo.getBusiId();
        if (busiId != null) {
            String cachekey = PayProCacheKeys.PAY_CACHE_BUSI_ID.getKey() + busiId;
            BusiSystemInfoPO busiRspPo = this.payProCacheManager.get(cachekey, BusiSystemInfoPO.class);
            if (busiRspPo != null) {
                retList.add(busiRspPo);
                return retList;
            }
            busiRspPo = this.busiSystemInfoMapper.queryBusiSystemById(busiId);
            if (busiRspPo == null) {
                throw new BusinessException("215001", "\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiId + ")\u4e0d\u5b58\u5728");
            }
            this.payProCacheManager.set(cachekey, busiRspPo, true, null);
            retList.add(busiRspPo);
            return retList;
        }
        return this.busiSystemInfoMapper.queryBusiSystemInfoByCondition(reqPo);
    }
}

