/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.dao.PaymentInsMapper;
import com.tydic.payment.pay.dao.po.PaymentInsPageReqPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="paymentInsAtomService")
public class PaymentInfAtomServiceImpl
implements PaymentInsAtomService {
    @Autowired
    private PaymentInsMapper paymentInsMapper;
    private static final String TABLE_NAME = "P_INFO_PAYMENT_INS";

    @Override
    public Long createPaymentInf(PaymentInsPo po) {
        this.validateArgOfCreatePaymentInf(po);
        int createPaymentInf = this.paymentInsMapper.createPaymentInf(po);
        if (createPaymentInf < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAYMENT_INS\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAYMENT_INS\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getPaymentInsId();
    }

    private void validateArgOfCreatePaymentInf(PaymentInsPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() != null) {
            po.setPaymentInsId(null);
        }
        if (StringUtils.isEmpty((String)po.getPaymentInsName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027PaymentInsName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int updatePaymentInf(PaymentInsPo po) {
        this.validateArgOfUpdatePaymentInf(po);
        int delPaymentInf = this.paymentInsMapper.updatePaymentInf(po);
        if (delPaymentInf < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0P_INFO_PAYMENT_INS\u65f6mapper update\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        return delPaymentInf;
    }

    private void validateArgOfUpdatePaymentInf(PaymentInsPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_PAYMENT_INS\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deletePaymentInf(PaymentInsPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_PAYMENT_INS\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int delPaymentInf = this.paymentInsMapper.deletePaymentInf(po);
        if (delPaymentInf < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664P_INFO_PAYMENT_INS\u65f6mapper delete\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        return delPaymentInf;
    }

    @Override
    public List<PaymentInsPo> queryPaymentInf(PaymentInsPo po) {
        List<PaymentInsPo> queryPaymentInf;
        if (po == null) {
            po = new PaymentInsPo();
        }
        if (CollectionUtils.isEmpty(queryPaymentInf = this.paymentInsMapper.queryPaymentInf(po))) {
            queryPaymentInf = new ArrayList<PaymentInsPo>();
        }
        return queryPaymentInf;
    }

    @Override
    public Long createPaymentInfWithId(PaymentInsPo po) {
        this.validateArgOfCreatePaymentInfWithId(po);
        int createPaymentInf = this.paymentInsMapper.createPaymentInfWithId(po);
        if (createPaymentInf < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAYMENT_INS\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAYMENT_INS\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getPaymentInsId();
    }

    private void validateArgOfCreatePaymentInfWithId(PaymentInsPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be5\u65b9\u6cd5\u63d2\u5165P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)po.getPaymentInsName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAYMENT_INS\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027PaymentInsName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<PaymentInsPo> queryPaymentInfByInss(List<Long> list) {
        if (list == null || list.isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u652f\u4ed8\u673a\u6784id\u67e5\u8be2P_INFO_PAYMENT_INS\u5165\u53c2list\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PaymentInsPo> queryPaymentInfByInss = this.paymentInsMapper.queryPaymentInfByInss(list);
        if (CollectionUtils.isEmpty(queryPaymentInfByInss)) {
            return new ArrayList<PaymentInsPo>();
        }
        return queryPaymentInfByInss;
    }

    @Override
    public List<PaymentInsPo> queryAllPaymentIdAndName(PaymentInsPo po) {
        List<PaymentInsPo> queryPaymentIdAndNameL;
        if (po == null) {
            po = new PaymentInsPo();
        }
        if (CollectionUtils.isEmpty(queryPaymentIdAndNameL = this.paymentInsMapper.queryAllPaymentIdAndName(po))) {
            return new ArrayList<PaymentInsPo>();
        }
        return queryPaymentIdAndNameL;
    }

    @Override
    public List<PaymentInsPo> queryPaymentInfWithPage(Page<PaymentInsPageReqPo> page, PaymentInsPageReqPo po) {
        List<PaymentInsPo> queryPaymentInf;
        if (po == null) {
            po = new PaymentInsPageReqPo();
        }
        if ((queryPaymentInf = this.paymentInsMapper.queryPaymentInfWithPage(page, po)) == null || queryPaymentInf.isEmpty()) {
            queryPaymentInf = new ArrayList<PaymentInsPo>();
        }
        return queryPaymentInf;
    }
}

