/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.bill.impl;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.busi.BillCompareDiffRemoveBusiService;
import com.tydic.payment.bill.busi.BillComparisonBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayRemoveBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransRemoveBusiService;
import com.tydic.payment.bill.busi.BillSettleTransRemoveBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareDiffRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayRemoveBatchReqBO;
import com.tydic.payment.bill.busi.bo.BillPaymentTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.BillSettleTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransByGroupNameReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundTransByGroupNameReqBO;
import com.tydic.payment.bill.comb.BillPayBalanceCombService;
import com.tydic.payment.bill.comb.BillPaySettleTransCombService;
import com.tydic.payment.bill.comb.bo.BillComparisonReqBO;
import com.tydic.payment.bill.comb.bo.BillComparisonRspBO;
import com.tydic.payment.bill.constant.BillExecuteStep;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.bill.exception.BillCompareException;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.exception.BillSummaryResultDataException;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.bill.exception.BillSyncSettleTransException;
import com.tydic.payment.pay.bill.impl.api.PayProBillMerchantExecBillService;
import com.tydic.payment.pay.busi.PayProBillInsertToTransBusiService;
import com.tydic.payment.pay.busi.PayProBillSummaryBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayProBillInsertToTransBusiServiceReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillInsertToTransBusiServiceRspBo;
import com.tydic.payment.pay.busi.bo.PayProBillSummaryBusiServiceReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillSummaryBusiServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProBillMerchantExecCombServiceReqBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PBillResultMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PBillResultPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.QueryMerchantAttrPo;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.util.PayBillAbleManager;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayProBillMerchantExecBillServiceImpl
implements PayProBillMerchantExecBillService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PBillResultMapper pBillResultMapper;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;
    @Autowired
    private PayBillAbleManager payBillAbleManager;
    @Autowired
    private PayProBillInsertToTransBusiService payProBillInsertToTransBusiService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private BillPayBillDayCreateBusiService billPayBillDayCreateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private BillComparisonBusiService billComparisonBusiService;
    @Autowired
    private BillCompareDiffRemoveBusiService billCompareDiffRemoveBusiService;
    @Autowired
    private BillPayBalanceCombService billPayBalanceCombService;
    @Autowired
    private BillPaySettleTransCombService billPaySettleTransCombService;
    @Autowired
    private BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService;
    @Autowired
    private BillPayBillDayRemoveBusiService billPayBillDayRemoveBusiService;
    @Autowired
    private BillSettleTransRemoveBusiService billSettleTransRemoveBusiService;
    @Autowired
    private PayProBillSummaryBusiService payProBillSummaryBusiService;

    @Override
    public void execMerchantBill(PayProBillMerchantExecCombServiceReqBo reqBo) {
        Long paymentInsId = reqBo.getPaymentInsId();
        Long billDate = reqBo.getBillDate();
        Map<String, String> paraMap = this.queryMerchantAttr(reqBo);
        PayBillAble payBillAble = this.payBillAbleManager.getPayBillAble(paymentInsId);
        this.deleteFailedData(reqBo);
        this.downloadAndInsertPayTransData(billDate, paraMap, payBillAble);
        this.syncPayBillDayData(reqBo);
        this.compareAndInsertBillData(reqBo);
        BillExecuteRequest dealDiffReqBo = new BillExecuteRequest();
        dealDiffReqBo.setBillDate(reqBo.getBillDate());
        dealDiffReqBo.setPaymentInsId(reqBo.getPaymentInsId());
        dealDiffReqBo.setPaymentMchId(reqBo.getPaymentInsMerchant());
        this.dealBalance(reqBo, dealDiffReqBo);
        this.doSyncSettleTransDay(dealDiffReqBo);
        this.doSummaryResult(billDate);
    }

    private void doSummaryResult(Long billDate) {
        try {
            PayProBillSummaryBusiServiceReqBo summaryReqBo = new PayProBillSummaryBusiServiceReqBo();
            summaryReqBo.setBillDate(billDate);
            PayProBillSummaryBusiServiceRspBo summaryRspBo = this.payProBillSummaryBusiService.addSummaryResult(summaryReqBo);
            if (!"0000".equals(summaryRspBo.getRespCode())) {
                throw new BillSummaryResultDataException("\u6c47\u603b\u5bf9\u8d26\u7ed3\u679c\u6570\u636e\u9519\u8bef\uff1a" + summaryRspBo.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BillSummaryResultDataException("\u6c47\u603b\u5bf9\u8d26\u7ed3\u679c\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void doSyncSettleTransDay(BillExecuteRequest dealDiffReqBo) {
        try {
            this.billPaySettleTransCombService.doSyncSettleTransDay(dealDiffReqBo);
        }
        catch (Exception e) {
            throw new BillSyncSettleTransException("\u540c\u6b65settle\u8868\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void dealBalance(PayProBillMerchantExecCombServiceReqBo reqBo, BillExecuteRequest dealDiffReqBo) {
        try {
            this.billPayBalanceCombService.doBalance(dealDiffReqBo);
        }
        catch (Exception e) {
            throw new BillBalanceException("\u5e73\u8d26\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void downloadAndInsertPayTransData(Long billDate, Map<String, String> paraMap, PayBillAble payBillAble) {
        try {
            PayBillAbleDownloadRspBo payBillAbleDownloadRspBo = this.downloadAndGenerateTransData(paraMap, billDate, payBillAble);
            if (CollectionUtils.isEmpty((Collection)payBillAbleDownloadRspBo.getRspDataBos())) {
                this.LOGGER.info("=======\u4ece\u652f\u4ed8\u673a\u6784\u83b7\u53d6\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u4e09\u65b9\u652f\u4ed8\u673a\u6784\u6570\u636e\u5165\u5e93\u7ed3\u675f");
                return;
            }
            try {
                this.validateDownloadsData(payBillAbleDownloadRspBo);
            }
            catch (Exception e) {
                throw new BillDownAndTransException("\u4e0b\u8f7d\u8d26\u5355\u6570\u636e\u5199\u5165p_trans_payment\u9519\u8bef\uff1a\u652f\u4ed8\u673a\u6784[" + payBillAble.paymentIns() + "]\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff1a" + e.getMessage());
            }
            PayProBillInsertToTransBusiServiceRspBo billInsertToTransBusiServiceRspBo = this.insertDataToTrans(payBillAbleDownloadRspBo);
            if (!"0000".equals(billInsertToTransBusiServiceRspBo.getRespCode())) {
                throw new BillDownAndTransException("\u4e0b\u8f7d\u8d26\u5355\u6570\u636e\u5199\u5165p_trans_payment\u9519\u8bef\uff1a" + billInsertToTransBusiServiceRspBo.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BillDownAndTransException("\u4e0b\u8f7d\u8d26\u5355\u6570\u636e\u5199\u5165p_trans_payment\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private void compareAndInsertBillData(PayProBillMerchantExecCombServiceReqBo reqBo) {
        try {
            BillComparisonReqBO dealBillCheckReqBo = new BillComparisonReqBO();
            dealBillCheckReqBo.setBillDate(reqBo.getBillDate());
            dealBillCheckReqBo.setPaymentInsId(reqBo.getPaymentInsId());
            dealBillCheckReqBo.setPaymentMchId(reqBo.getPaymentInsMerchant());
            BillComparisonRspBO dealBillCheckRsp = this.billComparisonBusiService.dealBillCheck(dealBillCheckReqBo);
            if (!"0000".equals(dealBillCheckRsp.getRespCode())) {
                throw new BillCompareException("\u8d26\u5355\u6570\u636e\u6bd4\u5bf9\u9519\u8bef\uff1a" + dealBillCheckRsp.getRespDesc());
            }
            BillComparisonRspBO updateBillFlag = this.billComparisonBusiService.billFlag(dealBillCheckReqBo);
            if (!"0000".equals(updateBillFlag.getRespCode())) {
                throw new BillCompareException("\u8d26\u5355\u6570\u636e\u6bd4\u5bf9\uff08\u66f4\u65b0\u5bf9\u8d26\u6807\u8bc6\uff09\u9519\u8bef\uff1a" + updateBillFlag.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BillCompareException("\u8d26\u5355\u6570\u636e\u6bd4\u5bf9\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void syncPayBillDayData(PayProBillMerchantExecCombServiceReqBo reqBo) {
        try {
            List<Long> payMethods = this.qryPayMethods(reqBo);
            List<Long> merchantIdList = this.qryMerchants(reqBo);
            this.insertPayOrders(reqBo, payMethods, merchantIdList);
            this.insertRefundOrders(reqBo, payMethods, merchantIdList);
        }
        catch (Exception e) {
            throw new BillSyncPayDayException("\u540c\u6b65\u672c\u5730\u6570\u636e\u5230\u8868\uff1ap_paybill_day \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private void deleteFailedData(PayProBillMerchantExecCombServiceReqBo request) {
        if (request.getBillExecuteStep() != null) {
            BillPayBillDayRemoveBatchReqBO reqBO;
            if (BillExecuteStep.DOWNLOAD_AND_TRANS.getCode() <= request.getBillExecuteStep().getCode()) {
                BillPaymentTransRemoveBusiReqBO paymentReqBO = new BillPaymentTransRemoveBusiReqBO();
                paymentReqBO.setBillDate(request.getBillDate());
                paymentReqBO.setPaymentInsId(request.getPaymentInsId());
                paymentReqBO.setPaymentMchId(request.getPaymentInsMerchant());
                this.billPaymentTransRemoveBusiService.removeBatch(paymentReqBO);
            }
            if (BillExecuteStep.SYNC_PAY_DAY.getCode() <= request.getBillExecuteStep().getCode()) {
                reqBO = new BillPayBillDayRemoveBatchReqBO();
                reqBO.setBillDate(request.getBillDate());
                reqBO.setPaymentInsId(request.getPaymentInsId());
                reqBO.setPaymentMchId(request.getPaymentInsMerchant());
                this.billPayBillDayRemoveBusiService.removeBatch(reqBO);
            }
            if (BillExecuteStep.COMPARE.getCode() <= request.getBillExecuteStep().getCode()) {
                reqBO = new BillCompareDiffRemoveBusiReqBO();
                reqBO.setBillDate(request.getBillDate());
                reqBO.setPaymentInsId(request.getPaymentInsId());
                reqBO.setPaymentMchId(request.getPaymentInsMerchant());
                this.billCompareDiffRemoveBusiService.removeBatch((BillCompareDiffRemoveBusiReqBO)reqBO);
            }
            if (BillExecuteStep.SYNC_SETTLE_TRANS.getCode() <= request.getBillExecuteStep().getCode()) {
                reqBO = new BillSettleTransRemoveBusiReqBO();
                reqBO.setBillDate(request.getBillDate());
                reqBO.setPaymentInsId(request.getPaymentInsId());
                reqBO.setPaymentMchId(request.getPaymentInsMerchant());
                this.billSettleTransRemoveBusiService.removeBatch((BillSettleTransRemoveBusiReqBO)reqBO);
            }
            if (BillExecuteStep.SYNC_SUMMARY_RESULT.getCode() <= request.getBillExecuteStep().getCode()) {
                PBillResultPo remove = new PBillResultPo();
                remove.setBillDate(request.getBillDate());
                remove.setPaymentIns(request.getPaymentInsId());
                remove.setPaymentMchId(request.getPaymentInsMerchant());
                this.pBillResultMapper.removeBatch(remove);
            }
        }
    }

    private void validateDownloadsData(PayBillAbleDownloadRspBo payBillAbleDownloadRspBo) {
        ArgValidator.validateArgWithThrow((Object)payBillAbleDownloadRspBo);
    }

    private void insertRefundOrders(PayProBillMerchantExecCombServiceReqBo request, List<Long> payMethods, List<Long> merchantIdList) {
        String projectName = this.payPropertiesVo.getProjectName();
        QueryRefundTransByGroupNameReqBO queryReqBO = new QueryRefundTransByGroupNameReqBO();
        queryReqBO.setBillDate(request.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIdList);
        List transRefundList = this.queryRefundBusiService.listSuccessTransSingleDataBase(queryReqBO, projectName);
        if (CollectionUtils.isEmpty((Collection)transRefundList)) {
            this.LOGGER.debug("\u540c\u6b65\u9000\u6b3e\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
            return;
        }
        this.createDayByTransRefund(transRefundList, request);
    }

    private void createDayByTransRefund(List<QueryRefundRspBO> transRefundList, PayProBillMerchantExecCombServiceReqBo request) {
        BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
        for (QueryRefundRspBO trans : transRefundList) {
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setPayOrderId(trans.getPayOrderId());
            createReqBO.setRefundOrderId(trans.getRefundOrderId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setBillTransId(trans.getPayNotifyTransId());
            createReqBO.setPayMethod(trans.getPayMethod());
            createReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            createReqBO.setTradeTime(trans.getTradeTime());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentInsMerchant());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            this.billPayBillDayCreateBusiService.createTrans(createReqBO);
        }
    }

    private void insertPayOrders(PayProBillMerchantExecCombServiceReqBo reqBo, List<Long> payMethods, List<Long> merchantIdList) {
        String projectName = this.payPropertiesVo.getProjectName();
        QueryPayTransByGroupNameReqBO queryReqBO = new QueryPayTransByGroupNameReqBO();
        queryReqBO.setBillDate(reqBo.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIdList);
        List transPayList = this.queryPayTransBusiService.listSuccessTransSingleDatabase(queryReqBO, projectName);
        if (CollectionUtils.isEmpty((Collection)transPayList)) {
            this.LOGGER.debug("\u540c\u6b65\u652f\u4ed8\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
            return;
        }
        this.createDayByTransPay(transPayList, reqBo);
    }

    private List<Long> qryMerchants(PayProBillMerchantExecCombServiceReqBo reqBo) {
        MerchantPayMethodRelPo qryMerchantsReqPo = new MerchantPayMethodRelPo();
        qryMerchantsReqPo.setPaymentInsMerchantId(reqBo.getPaymentInsMerchant());
        qryMerchantsReqPo.setPaymentInsId(reqBo.getPaymentInsId());
        return this.merchantPayMethodRelMapper.queryMerchantWithPaymentInsId(qryMerchantsReqPo);
    }

    private List<Long> qryPayMethods(PayProBillMerchantExecCombServiceReqBo reqBo) {
        PayMethodPo qryPaymentReqPo = new PayMethodPo();
        qryPaymentReqPo.setPaymentInsId(reqBo.getPaymentInsId());
        List<PayMethodPo> payMethodPos = this.payMethodMapper.queryPayMethod(qryPaymentReqPo);
        return payMethodPos.stream().map(PayMethodPo::getPayMethod).collect(Collectors.toList());
    }

    private void createDayByTransPay(List<QueryPayTransRspBO> transPayList, PayProBillMerchantExecCombServiceReqBo request) {
        for (QueryPayTransRspBO trans : transPayList) {
            BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setPayOrderId(trans.getPayOrderId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setBillTransId(trans.getPayNotifyTransId());
            createReqBO.setPayMethod(trans.getPayMethod());
            createReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            createReqBO.setTradeTime(trans.getTradeTime());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentInsMerchant());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            this.billPayBillDayCreateBusiService.createTrans(createReqBO);
        }
    }

    private PayProBillInsertToTransBusiServiceRspBo insertDataToTrans(PayBillAbleDownloadRspBo payBillAbleDownloadRspBo) {
        PayProBillInsertToTransBusiServiceReqBo insertTransReqBo = new PayProBillInsertToTransBusiServiceReqBo();
        insertTransReqBo.setDataBos(payBillAbleDownloadRspBo.getRspDataBos());
        return this.payProBillInsertToTransBusiService.insertTrans(insertTransReqBo);
    }

    private PayBillAbleDownloadRspBo downloadAndGenerateTransData(Map<String, String> paraMap, Long billDate, PayBillAble payBillAble) {
        PayBillAbleDownloadReqBo downloadBo = new PayBillAbleDownloadReqBo();
        downloadBo.setParaMap(paraMap);
        downloadBo.setBillDate(billDate);
        return payBillAble.downLoadFile(downloadBo);
    }

    private Map<String, String> queryMerchantAttr(PayProBillMerchantExecCombServiceReqBo reqBo) {
        QueryMerchantAttrPo qryMerchantAttrPo = new QueryMerchantAttrPo();
        qryMerchantAttrPo.setMerchantId(reqBo.getMerchantId());
        qryMerchantAttrPo.setPaymentInsId(reqBo.getPaymentInsId());
        List<PayParaInfoAttrPo> payParaInfoAttrPos = this.payParaInfoAttrMapper.queryMerchantAttrByCondition(qryMerchantAttrPo);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        for (PayParaInfoAttrPo payParaInfoAttrPo : payParaInfoAttrPos) {
            paraMap.put(payParaInfoAttrPo.getAttrCode(), payParaInfoAttrPo.getAttrValue());
        }
        return paraMap;
    }
}

