/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ali.common.Utils;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AlipayNotifyBusiService;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.AlipayNotifyReqBo;
import com.tydic.payment.pay.busi.bo.AlipayNotifyRspBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="alipayNotifyBusiService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.busi.AlipayNotifyBusiService"})
public class AlipayNotifyBusiServiceImpl
implements AlipayNotifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(AlipayNotifyBusiServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"dealAliNotify"})
    public AlipayNotifyRspBo dealAliNotify(@RequestBody AlipayNotifyReqBo alipayNotifyReqBo) {
        if (alipayNotifyReqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (alipayNotifyReqBo.getParams() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("********  \u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u53c2\u6570 ***************");
        log.info(JSON.toJSONString((Object)alipayNotifyReqBo.getParams()));
        AlipayNotifyRspBo alipayNotifyRspBo = new AlipayNotifyRspBo();
        if (((String)alipayNotifyReqBo.getParams().get("trade_status")).equals("WAIT_BUYER_PAY")) {
            alipayNotifyRspBo.setRspCode("0000");
            alipayNotifyRspBo.setStatus(true);
            alipayNotifyRspBo.setRspName("\u8ba2\u5355\u6b63\u5728\u652f\u4ed8");
            return alipayNotifyRspBo;
        }
        try {
            String pay_order_id = (String)alipayNotifyReqBo.getParams().get("out_trade_no");
            String date = (String)alipayNotifyReqBo.getParams().get("gmt_payment");
            log.info("-------------------------------------------------------");
            log.info("\u4ea4\u6613\u65f6\u95f4\u4e3a\uff1adate" + date);
            PorderPayTransAtomReqBo porderPayTransAtomReqBo = new PorderPayTransAtomReqBo();
            porderPayTransAtomReqBo.setPayOrderId(pay_order_id);
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
            if (porderPayTransAtomRspBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34\u597d\u4e3a\u7a7a\uff0c \u5f02\u5e38");
            }
            Long orderId = porderPayTransAtomRspBo.getOrderId();
            PorderPo porderPo = this.payOrderAtomService.queryPorderInfo(orderId);
            if ("A10".equals(porderPo.getOrderStatus())) {
                log.info(pay_order_id + "\u8ba2\u5355\u5df2\u7ecf\u8fd4\u56de\uff0c\u6570\u636e\u5df2\u7ecf\u66f4\u65b0");
                alipayNotifyRspBo.setRspCode("0000");
                alipayNotifyRspBo.setStatus(true);
                alipayNotifyRspBo.setRspName("\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
                return alipayNotifyRspBo;
            }
            Long merchant_id = porderPayTransAtomRspBo.getMerchantId();
            Long PayMethod2 = porderPayTransAtomRspBo.getPayMethod();
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(String.valueOf(merchant_id));
            paraReq.setPayMethod(String.valueOf(PayMethod2));
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            log.info("params = " + alipayNotifyReqBo.getParams());
            log.info("publicKey=" + this.getParamMap(paraInfo).get("publicKey").toString());
            if (!Utils.verify(alipayNotifyReqBo.getParams(), this.getParamMap(paraInfo).get("publicKey").toString())) {
                log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
                alipayNotifyRspBo.setRspCode("0000");
                alipayNotifyRspBo.setStatus(false);
                alipayNotifyRspBo.setRspName("\u8ba2\u5355\u7b7e\u540d\u5931\u8d25");
                return alipayNotifyRspBo;
            }
            String trade_status = (String)alipayNotifyReqBo.getParams().get("trade_status");
            String trade_time = "";
            if (!StringUtils.isEmpty((Object)date)) {
                trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date));
            } else {
                Date dbDate = this.queryDBDateBusiService.getDBDate();
                trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
            }
            if (trade_status.equals("TRADE_FINISHED")) {
                porderPo.setPayNotifyCode("0");
                porderPo.setOrderStatus("A10");
            } else if (trade_status.equals("TRADE_SUCCESS")) {
                porderPo.setPayNotifyCode("0");
                porderPo.setOrderStatus("A10");
            } else if (trade_status.equals("TRADE_CLOSED")) {
                porderPo.setPayNotifyCode("1");
                porderPo.setPayNotifyMsg("\u8ba2\u5355\u5df2\u5173\u95ed");
                porderPo.setOrderStatus("A20");
            } else {
                porderPo.setPayNotifyCode("1");
                porderPo.setPayNotifyMsg(trade_status + "\u652f\u4ed8\u5931\u8d25");
                porderPo.setOrderStatus("A20");
            }
            porderPo.setTradeTime(trade_time);
            porderPo.setCustyNotifyCode("-");
            porderPo.setRealFee(MoneyUtils.yuanToHaoToLong((BigDecimal)new BigDecimal((String)alipayNotifyReqBo.getParams().get("total_amount"))));
            porderPo.setOnlineFee(porderPo.getRealFee());
            log.info("---------------- \u5f00\u59cb\u66f4\u65b0\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355----------------");
            log.info("\u66f4\u65b0\u652f\u4ed8\u8ba2\u5355\u7684\u6570\u636e\u4e3a \uff1a " + porderPo.toString());
            porderPo.setPayNotifyTransId((String)alipayNotifyReqBo.getParams().get("trade_no"));
            this.payOrderAtomService.update(porderPo);
            porderPayTransAtomReqBo.setTradeTime(porderPo.getTradeTime());
            porderPayTransAtomReqBo.setOrderStatus(porderPo.getOrderStatus());
            porderPayTransAtomReqBo.setPayNotifyTransId((String)alipayNotifyReqBo.getParams().get("trade_no"));
            porderPayTransAtomReqBo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
            porderPayTransAtomReqBo.setPayMsg(porderPo.getPayNotifyMsg());
            porderPayTransAtomReqBo.setOrderId(orderId);
            log.info("---------------- \u5f00\u59cb\u66f4\u65b0\u6d41\u6c34\u8ba2\u5355----------------");
            this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderId);
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                log.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
            alipayNotifyRspBo.setRspCode("0000");
            alipayNotifyRspBo.setStatus(true);
            alipayNotifyRspBo.setRspName("\u5f02\u6b65\u901a\u77e5\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u901a\u77e5\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            alipayNotifyRspBo.setRspCode("8888");
            alipayNotifyRspBo.setStatus(false);
            alipayNotifyRspBo.setRspName("\u5f02\u6b65\u901a\u77e5\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return alipayNotifyRspBo;
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            if ("appid".equals(para.getAttrCode())) {
                paramMap.put("appid", para.getAttrValue());
                continue;
            }
            if ("privateKey".equals(para.getAttrCode())) {
                paramMap.put("privateKey", para.getAttrValue());
                continue;
            }
            if (!"publicKey".equals(para.getAttrCode())) continue;
            paramMap.put("publicKey", para.getAttrValue());
        }
        return paramMap;
    }
}

