/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.rsa.util.EncodeUtil;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="dataValidationService")
public class DataValidationServiceImpl
implements DataValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataValidationServiceImpl.class);
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    public DataValidationRspBO validation(DataValidationReqBO reqBo) throws Exception {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743 BUSI_ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataValidationRspBO rsp = new DataValidationRspBO();
        try {
            BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
            busiSystemInfoPO.setBusiId(Long.parseLong(reqBo.getBusiId()));
            List<BusiSystemInfoPO> po = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
            if (po == null || po.isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            busiSystemInfoPO = po.get(0);
            String rsaPrivateKey = busiSystemInfoPO.getRsaPrivateKey().trim();
            String signKey = busiSystemInfoPO.getSignKey().trim();
            String data = EncodeUtil.privateDecode((String)reqBo.getContent(), (String)rsaPrivateKey);
            boolean signResult = EncodeUtil.signValid((String)data, (String)signKey);
            if (!signResult) {
                rsp.setSign(false);
            } else {
                rsp.setSign(true);
                rsp.setBusiId(reqBo.getBusiId());
                LOGGER.info("\u89e3\u5bc6\u8bf7\u6c42\u539f\u59cb\u5185\u5bb9\u4e3a \uff1a" + data);
                rsp.setContentMap(RsaEncodeUtil.getMapFromJson((String)data));
            }
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rsp.setRspCode("8888");
            rsp.setRspName("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    public Map<String, Object> transform(String data) {
        HashMap<String, Object> transform = new HashMap<String, Object>();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        Iterator iterator = jsonObject.keySet().iterator();
        String key = "";
        String transformKey = "";
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            transformKey = this.camelCaseName(key);
            transform.put(transformKey, jsonObject.getString(key));
        }
        return transform;
    }

    public JSONObject transformJson(String data) {
        JSONObject transform = new JSONObject();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        Iterator iterator = jsonObject.keySet().iterator();
        String key = "";
        String transformKey = "";
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            transformKey = this.camelCaseName(key);
            transform.put(transformKey, (Object)jsonObject.getString(key));
        }
        return transform;
    }

    public String camelCaseName(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
        }
        return result.toString();
    }
}

