/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayProQuerySysCacheAtomService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionRspBo;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.constant.PayProCacheKeys;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProQueryInfoBusiSystemByConditionServiceImpl
implements PayProQueryInfoBusiSystemByConditionService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProCacheManager payProCacheManager;
    @Autowired
    private PayProQuerySysCacheAtomService payProQuerySysCacheAtomService;

    public PayProQueryInfoBusiSystemByConditionRspBo queryBusiSysByCondition(PayProQueryInfoBusiSystemByConditionReqBo reqBo) {
        BusiSystemInfoPO qryBusiPo = new BusiSystemInfoPO();
        if (reqBo != null) {
            BeanUtils.copyProperties((Object)reqBo, (Object)qryBusiPo);
        }
        List<BusiSystemInfoPO> busiSystemInfoPOS = this.payProQuerySysCacheAtomService.querySysWithCache(qryBusiPo);
        PayProQueryInfoBusiSystemByConditionRspBo retBo = new PayProQueryInfoBusiSystemByConditionRspBo();
        ArrayList<PayProQueryInfoBusiSystemByConditionBusiInfoRspBo> busiList = new ArrayList<PayProQueryInfoBusiSystemByConditionBusiInfoRspBo>();
        retBo.setBusiSystemList(busiList);
        if (busiSystemInfoPOS != null) {
            for (BusiSystemInfoPO tmpPo : busiSystemInfoPOS) {
                PayProQueryInfoBusiSystemByConditionBusiInfoRspBo tmpBo = new PayProQueryInfoBusiSystemByConditionBusiInfoRspBo();
                BeanUtils.copyProperties((Object)tmpPo, (Object)tmpBo);
                busiList.add(tmpBo);
            }
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f");
        return retBo;
    }

    public PayProQueryInfoBusiSystemByConditionBusiInfoRspBo queryBusiSysByBusiCode(String busiCode) {
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo retBo = new PayProQueryInfoBusiSystemByConditionBusiInfoRspBo();
        if (StringUtils.isEmpty((Object)busiCode)) {
            retBo.setRespCode("212004");
            retBo.setRespDesc("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        String cacheKey = PayProCacheKeys.PAY_CACHE_BUSI_CODE.getKey() + busiCode;
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo cacheRetBo = this.payProCacheManager.get(cacheKey, PayProQueryInfoBusiSystemByConditionBusiInfoRspBo.class);
        if (cacheRetBo != null) {
            return cacheRetBo;
        }
        PayProQueryInfoBusiSystemByConditionReqBo reqBo = new PayProQueryInfoBusiSystemByConditionReqBo();
        reqBo.setBusiCode(busiCode);
        PayProQueryInfoBusiSystemByConditionRspBo queryInfoBusiSystemByConditionRspBo = this.queryBusiSysByCondition(reqBo);
        if (!"0000".equals(queryInfoBusiSystemByConditionRspBo.getRespCode())) {
            retBo.setRespCode("212004");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + queryInfoBusiSystemByConditionRspBo.getRespDesc());
            return retBo;
        }
        List busiSystemList = queryInfoBusiSystemByConditionRspBo.getBusiSystemList();
        if (busiSystemList == null || busiSystemList.isEmpty()) {
            retBo.setRespCode("212004");
            retBo.setRespDesc("\u6839\u636e\u8be5busiCode(" + busiCode + ")\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edf");
            return retBo;
        }
        if (busiSystemList.size() > 1) {
            retBo.setRespCode("212004");
            retBo.setRespDesc("\u6839\u636e\u8be5busiCode(" + busiCode + ")\u67e5\u8be2\u5230\u591a\u4e2a\u4e1a\u52a1\u7cfb\u7edf,\u8bf7\u68c0\u67e5\u6570\u636e");
            return retBo;
        }
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo queryInfoBusiSystemByConditionBusiInfoRspBo = (PayProQueryInfoBusiSystemByConditionBusiInfoRspBo)busiSystemList.get(0);
        BeanUtils.copyProperties((Object)queryInfoBusiSystemByConditionBusiInfoRspBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f(byBusiCode)");
        this.payProCacheManager.set(cacheKey, retBo, true, null);
        return retBo;
    }

    public PayProQueryInfoBusiSystemByConditionBusiInfoRspBo queryBusiSysByBusiId(Long busiId) {
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo retBo = new PayProQueryInfoBusiSystemByConditionBusiInfoRspBo();
        if (busiId == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("busiId\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        PayProQueryInfoBusiSystemByConditionReqBo reqBo = new PayProQueryInfoBusiSystemByConditionReqBo();
        reqBo.setBusiId(busiId);
        PayProQueryInfoBusiSystemByConditionRspBo queryInfoBusiSystemByConditionRspBo = this.queryBusiSysByCondition(reqBo);
        if (!"0000".equals(queryInfoBusiSystemByConditionRspBo.getRespCode())) {
            retBo.setRespCode("212004");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edfid\u5931\u8d25:" + queryInfoBusiSystemByConditionRspBo.getRespDesc());
            return retBo;
        }
        List busiSystemList = queryInfoBusiSystemByConditionRspBo.getBusiSystemList();
        if (busiSystemList == null || busiSystemList.isEmpty()) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6839\u636e\u8be5busiId(" + busiId + ")\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edf");
            return retBo;
        }
        if (busiSystemList.size() > 1) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6839\u636e\u8be5busiId(" + busiId + ")\u67e5\u8be2\u5230\u591a\u4e2a\u4e1a\u52a1\u7cfb\u7edf,\u8bf7\u68c0\u67e5\u6570\u636e");
            return retBo;
        }
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo queryInfoBusiSystemByConditionBusiInfoRspBo = (PayProQueryInfoBusiSystemByConditionBusiInfoRspBo)busiSystemList.get(0);
        BeanUtils.copyProperties((Object)queryInfoBusiSystemByConditionBusiInfoRspBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f(byBusiId)");
        return retBo;
    }
}

