/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.ability.bo.PayProMerchantPayInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaReqBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaRspBo;
import com.tydic.payment.pay.busi.PayProRelPayParaBusiService;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.PayParaInfoMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payProRelPayParaBusiService")
public class PayProRelPayParaBusiServiceImpl
implements PayProRelPayParaBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProRelPayParaBusiServiceImpl.class);
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private PayParaInfoMapper payParaInfoMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;
    private Long merchantId;
    private Long paymentInsId;
    private Boolean isUpdate = false;

    public PayProRelPayParaRspBo addRelPayPara(PayProRelPayParaReqBo reqBo) {
        this.validateMerchantInfo(reqBo);
        this.validateRelInfo(reqBo);
        this.insertRelInfo(reqBo);
        return PayProRspUtil.generateSucRspBo(PayProRelPayParaRspBo.class);
    }

    public PayProRelPayParaRspBo updateRelPayPara(PayProRelPayParaReqBo reqBo) {
        this.validateMerchantInfo(reqBo);
        this.deleteOriginalInfo();
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateOperId())) {
            reqBo.setCreateOperId(reqBo.getCreateOperId());
        }
        this.insertRelInfo(reqBo);
        return PayProRspUtil.generateSucRspBo(PayProRelPayParaRspBo.class);
    }

    public PayProRelPayParaRspBo deleteRelPayPara(PayProRelPayParaReqBo reqBo) {
        this.validateMerchantInfo(reqBo);
        this.deleteOriginalInfo();
        return PayProRspUtil.generateSucRspBo(PayProRelPayParaRspBo.class);
    }

    private void deleteOriginalInfo() {
        MerchantPayMethodRelPo payMethodRelPo = new MerchantPayMethodRelPo();
        payMethodRelPo.setMerchantId(this.merchantId);
        List<MerchantPayMethodRelPo> payMethodRelPos = this.merchantPayMethodRelMapper.queryMerchantPayMethodRelByCondition(payMethodRelPo);
        if (CollectionUtils.isEmpty(payMethodRelPos)) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u83b7\u53d6\u5546\u6237\u914d\u7f6e\u7684\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25");
        }
        Long payParaId = payMethodRelPos.get(0).getPayParaId();
        PayParaInfoAttrPo attrPo = new PayParaInfoAttrPo();
        attrPo.setPayParaId(payParaId);
        int attrResult = this.payParaInfoAttrMapper.deletePayParaInfoAttrByCondition(attrPo);
        if (attrResult < 1) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u5220\u9664\u53c2\u6570\u8be6\u60c5\u4fe1\u606f\u5931\u8d25");
        }
        PayParaInfoPo paraInfoPo = new PayParaInfoPo();
        paraInfoPo.setPayParaId(payParaId);
        int paraResut = this.payParaInfoMapper.deletePayParaInfo(paraInfoPo);
        if (paraResut < 1) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u652f\u4ed8\u53c2\u6570\u5173\u7cfb\u5220\u9664\u5904\u7406\u5931\u8d25");
        }
        int payMethodResult = this.merchantPayMethodRelMapper.deleteMerchantPayMethodRelByCondition(payMethodRelPo);
        if (payMethodResult < 1) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u652f\u4ed8\u652f\u4ed8\u65b9\u5f0f\u5173\u7cfb\u5220\u9664\u5904\u7406\u5931\u8d25");
        }
    }

    private void insertRelInfo(PayProRelPayParaReqBo reqBo) {
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        PayProMerchantPayInsDataBo paymentInsDataBo = reqBo.getPaymentIns();
        this.paymentInsId = reqBo.getPaymentIns().getPaymentInsId();
        PayParaInfoPo paraInfoPo = new PayParaInfoPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)paraInfoPo);
        paraInfoPo.setParaName("\u5546\u6237(" + this.merchantId + ")\u7684\u652f\u4ed8\u53c2\u6570(" + this.paymentInsId + ")");
        paraInfoPo.setPaymentInsId(this.paymentInsId);
        paraInfoPo.setState("1");
        paraInfoPo.setCreateTime(dbDate);
        if (this.isUpdate.booleanValue()) {
            paraInfoPo.setUpdateTime(dbDate);
        }
        this.payParaInfoMapper.createPayParaInfo(paraInfoPo);
        Long payParaId = paraInfoPo.getPayParaId();
        log.debug("\u5546\u6237\u652f\u4ed8\u53c2\u6570Id\u4e3a\uff1a{}", (Object)payParaId);
        if (payParaId == null || payParaId < 1L) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u5199\u5165\u5546\u6237-\u652f\u4ed8\u53c2\u6570\u5173\u7cfb\u8868\u672a\u8fd4\u56de\u652f\u4ed8\u53c2\u6570ID");
        }
        List payMethodList = paymentInsDataBo.getPayMethodList();
        if (CollectionUtils.isEmpty((Collection)payMethodList)) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u4f20\u5165\u7684\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<MerchantPayMethodRelPo> payMethodRelPos = new ArrayList<MerchantPayMethodRelPo>();
        for (Long payMethod : payMethodList) {
            MerchantPayMethodRelPo payMethodPo = new MerchantPayMethodRelPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)paraInfoPo);
            payMethodPo.setPaymentInsId(this.paymentInsId);
            payMethodPo.setMerchantId(this.merchantId);
            payMethodPo.setPayMethod(payMethod);
            payMethodPo.setPayParaId(payParaId);
            payMethodPo.setCreateTime(dbDate);
            if (this.isUpdate.booleanValue()) {
                payMethodPo.setUpdateTime(dbDate);
            }
            payMethodRelPos.add(payMethodPo);
        }
        int result = this.merchantPayMethodRelMapper.insertBranch(payMethodRelPos);
        if (result < payMethodList.size()) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u5199\u5165\u5546\u6237-\u652f\u4ed8\u65b9\u5f0f\u5173\u7cfb\u5931\u8d25");
        }
        List payParaList = paymentInsDataBo.getPayParaList();
        if (CollectionUtils.isEmpty((Collection)payMethodList)) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u4f20\u5165\u7684\u652f\u4ed8\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<PayParaInfoAttrPo> paraInfoAttrPos = new ArrayList<PayParaInfoAttrPo>();
        for (PayProPayInsParaDataBo paraAttrDataBo : payParaList) {
            PayParaInfoAttrPo attrPo = new PayParaInfoAttrPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)attrPo);
            attrPo.setPayParaId(payParaId);
            attrPo.setAttrCode(paraAttrDataBo.getParameterCode());
            attrPo.setAttrValue(paraAttrDataBo.getParameterValue());
            attrPo.setCreateTime(dbDate);
            if (this.isUpdate.booleanValue()) {
                attrPo.setUpdateTime(dbDate);
            }
            paraInfoAttrPos.add(attrPo);
        }
        result = this.payParaInfoAttrMapper.insertBranch(paraInfoAttrPos);
        if (result < paraInfoAttrPos.size()) {
            throw new BusinessException("218023", "\u5904\u7406\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38\uff0c\u5199\u5165\u5546\u6237-\u652f\u4ed8\u53c2\u6570\u8be6\u60c5\u5931\u8d25");
        }
    }

    private void validateMerchantInfo(PayProRelPayParaReqBo reqBo) {
        this.merchantId = Long.parseLong(reqBo.getMerchantId());
        MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
        qryMerchantPo.setMerchantId(this.merchantId);
        MerChantInfoPo qryRetMerchantBo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantPo);
        if (null == qryRetMerchantBo) {
            throw new BusinessException("218023", "\u672a\u67e5\u8be2\u5230\u5546\u6237[" + this.merchantId + "]\u7684\u4fe1\u606f");
        }
    }

    private void validateRelInfo(PayProRelPayParaReqBo reqBo) {
        this.paymentInsId = reqBo.getPaymentIns().getPaymentInsId();
        MerchantPayMethodRelPo qryRelReqPo = new MerchantPayMethodRelPo();
        qryRelReqPo.setMerchantId(this.merchantId);
        qryRelReqPo.setPaymentInsId(this.paymentInsId);
        List<MerchantPayMethodRelPo> relPo = this.merchantPayMethodRelMapper.queryMerchantPayMethodRelByCondition(qryRelReqPo);
        if (!CollectionUtils.isEmpty(relPo)) {
            throw new BusinessException("218023", "\u5546\u6237[" + this.merchantId + "]\u5df2\u914d\u7f6e\u4e86\u652f\u4ed8\u673a\u6784[" + this.paymentInsId + "]\u7684\u4fe1\u606f");
        }
    }
}

