/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.druid.util.StringUtils;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PaymentMethodInquiryService;
import com.tydic.payment.pay.busi.QueryCashierPayMethodService;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayMethodBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PaymentMethodInquiryReqBo;
import com.tydic.payment.pay.busi.bo.PaymentMethodInquiryRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import com.tydic.payment.pay.dao.POrderRelPayMethodMapper;
import com.tydic.payment.pay.dao.po.POrderRelPayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="paymentMethodInquiryService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.busi.PaymentMethodInquiryService"})
public class PaymentMethodInquiryServiceImpl
implements PaymentMethodInquiryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentMethodInquiryServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierPayMethodService queryCashierPayMethodService;
    @Autowired
    private QueryCashierService queryCashierService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private POrderRelPayMethodMapper pOrderRelPayMethodMapper;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;

    @PostMapping(value={"paymentMethodInquiryService"})
    public PaymentMethodInquiryRspBo paymentMethodInquiryService(@RequestBody PaymentMethodInquiryReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f ORDER_ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String order_id = "";
        try {
            Long.parseLong(reqBo.getOrderId());
            order_id = reqBo.getOrderId();
        }
        catch (Exception e) {
            LOGGER.info("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a  \u8bf4\u660e\u662f\u5bc6\u6587\u3002\u5219\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c" + e.getMessage());
            LOGGER.error("\u5bc6\u6587\uff1aorderId = " + reqBo.getOrderId() + "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f");
            try {
                order_id = new String(OrderCiphertext.decode((String)reqBo.getOrderId()));
            }
            catch (UnsupportedEncodingException e1) {
                LOGGER.error(e1.getMessage(), (Throwable)e1);
            }
        }
        PaymentMethodInquiryRspBo payRspBo = new PaymentMethodInquiryRspBo();
        try {
            LOGGER.info("\u660e\u6587\uff1a orderId = " + order_id);
            Long orderId = Long.parseLong(order_id);
            PorderPo porderPo = this.payOrderAtomService.queryPorderInfo(orderId);
            if (porderPo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            payRspBo.setMerchantId(porderPo.getMerchantId().toString());
            payRspBo.setBusiId(porderPo.getBusiId());
            payRspBo.setBusiCode(porderPo.getBusiCode());
            payRspBo.setCreateOperId(porderPo.getCreateOperId());
            payRspBo.setCreateOperIdName(porderPo.getCreateOperIdName());
            payRspBo.setNotifyUrl(porderPo.getNotifyUrl());
            payRspBo.setReqWay(porderPo.getReqWay());
            payRspBo.setChannelId(porderPo.getChannelId());
            payRspBo.setCityId(porderPo.getCityId());
            payRspBo.setDistrictId(porderPo.getDistrictId());
            payRspBo.setProvinceId(porderPo.getProvinceId());
            payRspBo.setOfflinePayUrl(porderPo.getOrderAttrValue3());
            if ("A10".equals(porderPo.getOrderStatus())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            Long merthan_id = porderPo.getMerchantId();
            Long busi_id = porderPo.getBusiId();
            String busiId = String.valueOf(busi_id);
            String merthanId = String.valueOf(merthan_id);
            QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
            queryCashierReqBo.setBusiId(busiId);
            queryCashierReqBo.setReqWay(porderPo.getReqWay());
            QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
            if (queryCashierRspBo == null || "8888".equals(queryCashierRspBo.getRspCode())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u672a\u914d\u7f6e\u6536\u94f6\u53f0\u6a21\u677f");
            }
            QueryCashierPayMethodReqBo queryCashierPayMethodReqBo = new QueryCashierPayMethodReqBo();
            queryCashierPayMethodReqBo.setMerchantId(String.valueOf(merthanId));
            queryCashierPayMethodReqBo.setCashierTemplate(queryCashierRspBo.getCashierTemplate());
            queryCashierPayMethodReqBo.setChannelId(porderPo.getChannelId());
            QueryCashierPayMethodRspBo queryCashierPayMethodRspBo = this.queryCashierPayMethodService.queryCashierPayMethod(queryCashierPayMethodReqBo);
            if (!"0000".equals(queryCashierPayMethodRspBo.getRspCode())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f");
            }
            List<PayMethodBo> payMethodBos = this.filterMethodWithOut(queryCashierPayMethodRspBo.getCodePayMethodList(), orderId);
            this.insertNotice(payMethodBos, porderPo.getMerchantId());
            payRspBo.setPayMethod(payMethodBos);
            payRspBo.setCreateTime(porderPo.getCreateTime());
            Date curDate = this.queryDBDateBusiService.getDBDate();
            Calendar rightNow = Calendar.getInstance();
            rightNow.setTime(porderPo.getExpTime());
            System.out.println("\u6570\u636e\u5e93\u5f53\u524d\u65f6\u95f4\uff1a" + curDate.getTime());
            System.out.println("\u8ba2\u5355\u5230\u671f\u65f6\u95f4\uff1a" + rightNow.getTimeInMillis());
            Long timeOut = rightNow.getTimeInMillis() - curDate.getTime();
            if (timeOut <= 0L) {
                payRspBo.setPayTimeLeft("0");
            } else {
                payRspBo.setPayTimeLeft(String.valueOf(timeOut));
            }
            payRspBo.setDetailName(porderPo.getDetailName());
            payRspBo.setMerchantName(porderPo.getMerchantName());
            payRspBo.setMerchantNameAbb(porderPo.getMerchantNameAbb());
            payRspBo.setOrderId(String.valueOf(porderPo.getOrderId()));
            payRspBo.setRedirectUrl(porderPo.getRedirectUrl());
            payRspBo.setRemark(porderPo.getOutRemark());
            payRspBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)porderPo.getTotalFee())));
            BigDecimal realFee = new BigDecimal(0);
            realFee = porderPo.getDiscountFee() != null ? MoneyUtils.haoToFen((Long)(porderPo.getTotalFee() - porderPo.getDiscountFee())) : MoneyUtils.haoToFen((Long)porderPo.getTotalFee());
            payRspBo.setOutOrderId(porderPo.getOutOrderId());
            payRspBo.setRealFee(realFee.toString());
            payRspBo.setRspCode("0000");
            payRspBo.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            payRspBo.setRspCode("8888");
            payRspBo.setRspName(e.getMessage());
        }
        return payRspBo;
    }

    private List<PayMethodBo> filterMethodWithOut(List<PayMethodBo> codePayMethodList, Long orderId) {
        POrderRelPayMethodPo qryPo = new POrderRelPayMethodPo();
        qryPo.setOrderId(orderId);
        List<POrderRelPayMethodPo> pOrderRelPayMethodPos = this.pOrderRelPayMethodMapper.selectByCondition(qryPo);
        if (CollUtil.isEmpty(pOrderRelPayMethodPos)) {
            return codePayMethodList;
        }
        ArrayList<PayMethodBo> retList = new ArrayList<PayMethodBo>();
        Set collect = pOrderRelPayMethodPos.stream().map(POrderRelPayMethodPo::getPayMethod).collect(Collectors.toSet());
        for (PayMethodBo bo : codePayMethodList) {
            Long payMethod = Long.parseLong(bo.getPayMethod());
            if (!collect.contains(payMethod)) continue;
            retList.add(bo);
        }
        return retList;
    }

    public boolean Validity(Date date) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(6, 1);
        Date olddate = rightNow.getTime();
        Date newDate = this.queryDBDateBusiService.getDBDate();
        return olddate.after(newDate);
    }

    private void insertNotice(List<PayMethodBo> list, Long merchantId) {
        for (PayMethodBo bo : list) {
            if ("190".equals(bo.getPayMethod())) {
                PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
                qryPayParaBo.setPayMethod(Long.valueOf(190L));
                qryPayParaBo.setMerchantId(merchantId);
                PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
                if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
                    throw new BusinessException("8888", "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff01");
                }
                Map detailAttrs = payProQueryPayParaBusiRspBo.getDetailAttrs();
                String accBankFlag = (String)detailAttrs.get("accBankFlag");
                if (StringUtils.isEmpty((String)accBankFlag)) {
                    throw new BusinessException("8888", "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff01");
                }
                if ("1".equals(accBankFlag)) {
                    bo.setRemark("\u53ef\u652f\u6301\u4ed6\u884c\u548c\u5de5\u884c\u652f\u4ed8");
                } else {
                    bo.setRemark("\u4ec5\u652f\u6301\u5de5\u884c\u652f\u4ed8");
                }
            }
            if (!"180".equals(bo.getPayMethod()) && !"181".equals(bo.getPayMethod())) continue;
            bo.setRemark("\u53ef\u652f\u6301\u4ed6\u884c\u548c\u4e2d\u884c\u652f\u4ed8");
        }
    }
}

