/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.PayCenterRspBo;
import com.tydic.payment.pay.busi.UnionHCXPayBusiService;
import com.tydic.payment.pay.busi.bo.UnionHcxPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionHcxPayBusiRspBO;
import com.tydic.payment.pay.busi.impl.UnionWapPayBusiServiceImpl;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.PayHcxUtil;
import com.tydic.payment.pay.web.bo.req.QueryMerchRelBusiAndPaymWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryInfoMechartParaAttrRspBo;
import com.tydic.payment.pay.web.bo.rsp.QueryMerchRelBusiAndPaymWebPaymentRspBo;
import com.tydic.payment.pay.web.bo.rsp.QueryMerchRelBusiAndPaymWebRspBo;
import com.tydic.payment.pay.web.service.ConMerchantInfoMQueryMerchantRelBusiAndPaymentWebService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="unionHCXPayBusiService")
public class UnionHCXPayBusiServiceImpl
implements UnionHCXPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(UnionWapPayBusiServiceImpl.class);
    @Resource
    private PorderMapper porderMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayHcxUtil hcxUtil;
    @Autowired
    private ConMerchantInfoMQueryMerchantRelBusiAndPaymentWebService conMerchantInfoMQueryMerchantRelBusiAndPaymentWebService;

    public UnionHcxPayBusiRspBO dealUnionHCXPay(UnionHcxPayBusiReqBO reqBO) {
        log.info("\u8fdb\u5165\u4f9b\u5e94\u94fe\u91d1\u878d\u652f\u4ed8\u670d\u52a1");
        UnionHCXPayBusiServiceImpl.checkParams(reqBO);
        UnionHcxPayBusiRspBO rspBO = new UnionHcxPayBusiRspBO();
        String hcxCreditIssueUrl = this.payPropertiesVo.getHcxCreditIssueUrl();
        String clientid = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        String parenterId = this.payPropertiesVo.getHcxPartnerId();
        String parenterName = this.payPropertiesVo.getHcxPartnerName();
        String token = this.hcxUtil.getToken(tokenUrl, clientid, clientSecret);
        PorderPo porderPo = this.porderMapper.selectByOrderId(Long.parseLong(reqBO.getOrderId()));
        QueryMerchRelBusiAndPaymWebReqBo queryReqBO = new QueryMerchRelBusiAndPaymWebReqBo();
        queryReqBO.setMerchantId(reqBO.getMerchantId());
        PayCenterRspBo queryRspBO = this.conMerchantInfoMQueryMerchantRelBusiAndPaymentWebService.queryMerchantRelBusiAndPayment(queryReqBO);
        if (!queryRspBO.getRspCode().equals("0000")) {
            throw new BusinessException("", "");
        }
        List paymentInsList = ((QueryMerchRelBusiAndPaymWebRspBo)queryRspBO.getData()).getPaymentInsList();
        List collect = paymentInsList.stream().filter(bo -> bo.getPaymentInsId().equals("6")).collect(Collectors.toList());
        List corpNameAcceptBO = ((QueryMerchRelBusiAndPaymWebPaymentRspBo)collect.get(0)).getPayParaList().stream().filter(bo -> "corpNameAccept".equals(bo.getAttrCode())).collect(Collectors.toList());
        List corpIdTypeAcceptBO = ((QueryMerchRelBusiAndPaymWebPaymentRspBo)collect.get(0)).getPayParaList().stream().filter(bo -> "corpIdTypeAccept".equals(bo.getAttrCode())).collect(Collectors.toList());
        List corpIdCodeAcceptBO = ((QueryMerchRelBusiAndPaymWebPaymentRspBo)collect.get(0)).getPayParaList().stream().filter(bo -> "corpIdCodeAccept".equals(bo.getAttrCode())).collect(Collectors.toList());
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serial", "");
        reqMap.put("parenterId", parenterId);
        reqMap.put("parenterName", parenterName);
        reqMap.put("partnerBusiId", reqBO.getOrderId());
        reqMap.put("corpNameAccept", ((QueryInfoMechartParaAttrRspBo)corpNameAcceptBO.get(0)).getAttrValue());
        reqMap.put("coreIdTypeAccept", ((QueryInfoMechartParaAttrRspBo)corpIdTypeAcceptBO.get(0)).getAttrValue());
        reqMap.put("coreIdCodeAccept", ((QueryInfoMechartParaAttrRspBo)corpIdCodeAcceptBO.get(0)).getAttrValue());
        reqMap.put("financeCode", "");
        reqMap.put("maturityAmount", "");
        reqMap.put("maturityDate", "");
        String body = JSONObject.toJSONString(reqMap);
        String signUrl = hcxCreditIssueUrl.substring(hcxCreditIssueUrl.lastIndexOf("parenter/"));
        int random = PayHcxUtil.getRandom();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        String url = hcxCreditIssueUrl + "?access_token=" + token;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("X-SCF-NONCE", (String)((Object)Integer.valueOf(random)));
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-TV", (String)((Object)timeStamp));
        ResponseEntity<String> response = this.hcxUtil.doPost(url, body, MediaType.APPLICATION_JSON, headersMap);
        return rspBO;
    }

    private static void checkParams(UnionHcxPayBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u94fe\u91d1\u878d\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u94fe\u91d1\u878d\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u94fe\u91d1\u878d\u652f\u4ed8\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getParamMap())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u94fe\u91d1\u878d\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

