/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionPayReverseBusiService;
import com.tydic.payment.pay.busi.bo.UnionPayReverseBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionPayReverseBusiRspBO;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unionPayReverseBusiService")
public class UnionPayReverseBusiServiceImpl
implements UnionPayReverseBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayReverseBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Resource
    FileClient fileClient;

    public UnionPayReverseBusiRspBO dealUnionPayReverse(UnionPayReverseBusiReqBO req) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u94f6\u8054\u4e8c\u7ef4\u7801\uff08\u4e3b\u626b-C\u626bB\u6a21\u5f0f\uff09\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        }
        Date createTime = this.queryDBDateBusiService.getDBDate();
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, req.getParamMap());
        Map<String, String> reqContent = this.createReqContent(req, createTime);
        Map reqData = AcpService.sign(reqContent, (String)"UTF-8");
        String requestAppUrl = SdkConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)requestAppUrl, (String)"UTF-8");
        UnionPayReverseBusiRspBO rsp = new UnionPayReverseBusiRspBO();
        if (rspData.isEmpty()) {
            rsp.setRspCode("212000");
            rsp.setRspName("\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (!AcpService.validate((Map)rspData, (String)"UTF-8")) {
            rsp.setRspCode("212001");
            rsp.setRspName("\u6821\u9a8c\u8fd4\u56de\u7b7e\u540d\u5931\u8d25\uff01");
            return rsp;
        }
        String respCode = (String)rspData.get("respCode");
        if (!"00".equals(respCode)) {
            rsp.setRspCode("8888");
            rsp.setRspName((String)rspData.get("respMsg"));
            return rsp;
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u64a4\u9500\u6210\u529f\uff01");
        return rsp;
    }

    private Map<String, String> createReqContent(UnionPayReverseBusiReqBO req, Date createTime) {
        String merId = (String)req.getParamMap().get("merId");
        HashMap<String, String> data = new HashMap<String, String>(64);
        String txnTime = DateUtils.dateToStr((Date)createTime, (String)"yyyyMMddHHmmss");
        data.put("version", SdkConfig.getConfig().getVersion());
        data.put("encoding", "UTF-8");
        data.put("signMethod", SdkConfig.getConfig().getSignMethod());
        data.put("txnType", "99");
        data.put("txnSubType", "01");
        data.put("bizType", "000000");
        data.put("channelType", "08");
        data.put("merId", merId);
        data.put("accessType", "0");
        data.put("orderId", req.getPayOrderId());
        data.put("txnTime", txnTime);
        return data;
    }
}

