/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.WXMicroPayBusiService;
import com.tydic.payment.pay.busi.WXOrderQueryBusiService;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.busi.WXReverseOrderBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.WXMicroPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXMicroPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXReverseOrderBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXReverseOrderBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiMicroPayReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiOrderQueryReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiMicroPayRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiOrderQueryRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXMicroPayBusiService")
public class WXMicroPayBusiServiceImpl
implements WXMicroPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXMicroPayBusiServiceImpl.class);
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private WXReverseOrderBusiService wXReverseOrderBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXOrderQueryBusiService wXOrderQueryBusiService;

    public WXMicroPayBusiRspBO dealWXMicroPay(WXMicroPayBusiReqBO req) throws Exception {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\uff1a" + req);
        this.checkInputParas(req);
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
        if (orderInfo == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        String outTradeNo = this.createLocalOrder(req, orderInfo);
        String appid = (String)req.getParamMap().get("appid");
        String mchid = (String)req.getParamMap().get("mchid");
        String key = (String)req.getParamMap().get("signkey");
        String sub_mch_id = (String)req.getParamMap().get("subMchId");
        int totalFee = req.getTotalFee().intValue();
        WXApiMicroPayReqBO microPayReqData = new WXApiMicroPayReqBO().setAppid(appid).setMch_id(mchid).setBody(orderInfo.getDetailName()).setOut_trade_no(outTradeNo).setTotal_fee(totalFee).setSpbill_create_ip(orderInfo.getCreateIpAddress()).setAuth_code(req.getAuthCode()).setSub_mch_id(sub_mch_id).setNonce_str("").setKey(key);
        WXMicroPayBusiRspBO rsp = new WXMicroPayBusiRspBO();
        rsp.setPayOrderId(outTradeNo);
        WXApiMicroPayRspBO wXApiMicroPayRspBO = this.microPay(microPayReqData, rsp);
        if (wXApiMicroPayRspBO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        WXApiOrderQueryRspBO wXApiOrderQueryRspBO = new WXApiOrderQueryRspBO();
        wXApiOrderQueryRspBO.setTransaction_id(wXApiMicroPayRspBO.getTransaction_id());
        wXApiOrderQueryRspBO.setTotal_fee(wXApiMicroPayRspBO.getTotal_fee());
        wXApiOrderQueryRspBO.setTime_end(wXApiMicroPayRspBO.getTime_end());
        if (!"SUCCESS".equals(rsp.getPayStatus()) && "FAIL".equals(rsp.getPayStatus())) {
            wXApiOrderQueryRspBO = this.dealMicroPayExc(req, microPayReqData, wXApiMicroPayRspBO, rsp);
        }
        this.updateLocalOrder(req, wXApiOrderQueryRspBO, rsp);
        return rsp;
    }

    private String createLocalOrder(WXMicroPayBusiReqBO req, PorderPo orderInfo) {
        try {
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
            orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
            orderPayTransAtomReq.setMerchantId(Long.parseLong(req.getMerchantId()));
            orderPayTransAtomReq.setPayMethod(Long.parseLong("10"));
            orderPayTransAtomReq.setOrderStatus("A00");
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)req.getTotalFee()));
            return this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u521b\u5efa\u652f\u4ed8\u8bf7\u6c42\u5355\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void updateLocalOrder(WXMicroPayBusiReqBO req, WXApiOrderQueryRspBO wXApiOrderQueryRspBO, WXMicroPayBusiRspBO rsp) throws Exception {
        PorderPayTransAtomReqBo transUpdateInfo = new PorderPayTransAtomReqBo();
        PorderPo updateOrderPo = new PorderPo();
        Long orderId = Long.valueOf(req.getOrderId());
        transUpdateInfo.setPayOrderId(rsp.getPayOrderId());
        transUpdateInfo.setOrderId(orderId);
        updateOrderPo.setOrderId(orderId);
        String tradeTime = wXApiOrderQueryRspBO.getTime_end();
        String totalFee = wXApiOrderQueryRspBO.getTotal_fee();
        if (!StringUtils.isEmpty((Object)totalFee)) {
            totalFee = MoneyUtils.fenToHao((BigDecimal)req.getTotalFee()).longValue() + "";
            updateOrderPo.setRealFee(Long.parseLong(totalFee));
            updateOrderPo.setOnlineFee(Long.parseLong(totalFee));
        }
        if (StringUtils.isEmpty((Object)tradeTime)) {
            Date dbDate = this.queryDBDateBusiService.getDBDate();
            tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
            updateOrderPo.setTradeTime(tradeTime);
            transUpdateInfo.setTradeTime(tradeTime);
        } else {
            updateOrderPo.setTradeTime(tradeTime);
            transUpdateInfo.setTradeTime(tradeTime);
        }
        if ("SUCCESS".equals(rsp.getPayStatus())) {
            transUpdateInfo.setPayNotifyTransId(wXApiOrderQueryRspBO.getTransaction_id());
            transUpdateInfo.setOrderStatus("A10");
            updateOrderPo.setOrderStatus("A10");
            rsp.setPayNotifyTransId(wXApiOrderQueryRspBO.getTransaction_id());
        } else if ("FAIL".equals(rsp.getPayStatus())) {
            transUpdateInfo.setOrderStatus("A20");
            updateOrderPo.setOrderStatus("A20");
        }
        if (!"PAYING".equals(rsp.getPayStatus())) {
            this.payOrderAtomService.update(updateOrderPo);
            this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(transUpdateInfo);
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderId);
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                log.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
        }
    }

    private WXApiMicroPayRspBO microPay(WXApiMicroPayReqBO microPayReqData, WXMicroPayBusiRspBO rsp) throws Exception {
        WXApiMicroPayRspBO wXApiMicroPayRspBO = new WXApiMicroPayRspBO();
        if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
            wXApiMicroPayRspBO = this.wXPayApiBusiService.microPay(microPayReqData);
            if (wXApiMicroPayRspBO == null || wXApiMicroPayRspBO.getReturn_code() == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u83b7\u53d6\u4e0d\u5230\u5fae\u4fe1\u8fd4\u56de\u4fe1\u606f\uff01");
                rsp.setPayStatus("FAIL");
                return wXApiMicroPayRspBO;
            }
            if (!"SUCCESS".equals(wXApiMicroPayRspBO.getReturn_code())) {
                rsp.setRspCode("0000");
                rsp.setRspName(wXApiMicroPayRspBO.getReturn_msg());
                rsp.setPayStatus("FAIL");
            }
            if ("SUCCESS".equals(wXApiMicroPayRspBO.getResult_code())) {
                rsp.setRspCode("0000");
                rsp.setRspName("\u6210\u529f");
                rsp.setPayStatus("SUCCESS");
            }
            if ("FAIL".equals(wXApiMicroPayRspBO.getResult_code()) && "USERPAYING".equals(wXApiMicroPayRspBO.getErr_code())) {
                rsp.setRspCode("0000");
                rsp.setRspName(wXApiMicroPayRspBO.getErr_code_des());
                rsp.setPayStatus("PAYING");
            }
            if ("FAIL".equals(wXApiMicroPayRspBO.getResult_code()) && "AUTH_CODE_INVALID".equals(wXApiMicroPayRspBO.getErr_code())) {
                rsp.setRspCode("0000");
                rsp.setRspName("\u6761\u5f62\u7801\u8fc7\u671f\u4e86");
                rsp.setPayStatus("FAIL");
            }
        } else if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
            JSONObject body = new JSONObject();
            JSONObject bodyInfo = new JSONObject();
            bodyInfo.put("APP_ID", (Object)microPayReqData.getAppid());
            bodyInfo.put("MCH_ID", (Object)microPayReqData.getMch_id());
            bodyInfo.put("SUB_MCH_ID", (Object)microPayReqData.getSub_mch_id());
            bodyInfo.put("NONCE_STR", (Object)microPayReqData.getNonce_str());
            bodyInfo.put("SIGN", (Object)microPayReqData.getSign());
            bodyInfo.put("BODY", (Object)microPayReqData.getBody());
            bodyInfo.put("OUT_TRADE_NO", (Object)microPayReqData.getOut_trade_no());
            bodyInfo.put("TOTAL_FEE", (Object)String.valueOf(microPayReqData.getTotal_fee()));
            bodyInfo.put("SPBILL_CREATE_IP", (Object)microPayReqData.getSpbill_create_ip());
            bodyInfo.put("AUTH_CODE", (Object)microPayReqData.getAuth_code());
            body.put("MICROPAY_REQ", (Object)bodyInfo);
            String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxMicropayUrl(), body);
            ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"MICROPAY_RSP");
            JSONObject bodyJosonInfo = parseInfo.getJsonInfo();
            if (bodyJosonInfo == null) {
                rsp.setRspCode(parseInfo.getRsp_code());
                rsp.setRspName(parseInfo.getRsp_msg());
                rsp.setPayStatus("FAIL");
                return wXApiMicroPayRspBO;
            }
            String err_code = bodyJosonInfo.getString("ERR_CODE");
            if ("0000".equals(parseInfo.getRsp_code()) && StringUtils.isEmpty((Object)err_code)) {
                if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)microPayReqData.getKey())) {
                    rsp.setRspCode("8888");
                    rsp.setRspName("\u6821\u9a8c\u67e5\u8be2\u8ba2\u5355api\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
                    rsp.setPayStatus("FAIL");
                }
                rsp.setRspCode("0000");
                rsp.setRspName("\u6210\u529f");
                rsp.setPayStatus("SUCCESS");
            } else if ("8888".equals(parseInfo.getRsp_code()) && StringUtils.isEmpty((Object)err_code)) {
                rsp.setRspCode(parseInfo.getRsp_code());
                rsp.setRspName(parseInfo.getRsp_msg());
                rsp.setPayStatus("FAIL");
            }
            wXApiMicroPayRspBO = (WXApiMicroPayRspBO)ParseAbilityResponse.parseJsonToMap((JSONObject)bodyJosonInfo, WXApiMicroPayRspBO.class, (boolean)true);
        }
        return wXApiMicroPayRspBO;
    }

    private WXApiOrderQueryRspBO dealMicroPayExc(WXMicroPayBusiReqBO req, WXApiMicroPayReqBO microPayReqData, WXApiMicroPayRspBO wXApiMicroPayRspBO, WXMicroPayBusiRspBO rsp) throws Exception {
        WXApiOrderQueryRspBO wXApiOrderQueryRspBO = new WXApiOrderQueryRspBO();
        String err_code = wXApiMicroPayRspBO.getErr_code();
        String err_code_des = wXApiMicroPayRspBO.getErr_code_des();
        if ("USERPAYING".equals(err_code)) {
            rsp.setRspCode("0000");
            rsp.setRspName(err_code_des);
            rsp.setPayStatus("PAYING");
        } else if ("SYSTEMERROR".equals(err_code) || "BANKERROR".equals(err_code)) {
            wXApiOrderQueryRspBO = this.queryPayStatus(req, microPayReqData, rsp);
        } else {
            rsp.setRspCode("0000");
            rsp.setRspName(err_code_des);
            rsp.setPayStatus("FAIL");
        }
        return wXApiOrderQueryRspBO;
    }

    private void checkInputParas(WXMicroPayBusiReqBO req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getAuthCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5fae\u4fe1\u6761\u7801\u4e32\u3010authCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010sign_key\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("certname"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u8bc1\u4e66\u8def\u5f84\u3010cert_path\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("certpassword"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u8bc1\u4e66\u5bc6\u7801\u3010cert_password\u3011\uff01");
        }
    }

    private WXApiOrderQueryRspBO queryPayStatus(WXMicroPayBusiReqBO req, WXApiMicroPayReqBO microPayReqData, WXMicroPayBusiRspBO rsp) throws Exception {
        WXApiOrderQueryReqBO wXApiOrderQueryReqBO = new WXApiOrderQueryReqBO();
        wXApiOrderQueryReqBO.setAppid(microPayReqData.getAppid());
        wXApiOrderQueryReqBO.setMch_id(microPayReqData.getMch_id());
        wXApiOrderQueryReqBO.setSub_mch_id(microPayReqData.getSub_mch_id());
        wXApiOrderQueryReqBO.setKey(microPayReqData.getKey());
        wXApiOrderQueryReqBO.setOut_trade_no(microPayReqData.getOut_trade_no());
        WXApiOrderQueryRspBO wXApiOrderQueryRspBO = this.wXOrderQueryBusiService.orderQuery(wXApiOrderQueryReqBO);
        if (!"SUCCESS".equals(wXApiOrderQueryRspBO.getReturn_code())) {
            rsp.setRspCode("0000");
            rsp.setRspName(wXApiOrderQueryRspBO.getReturn_msg());
            rsp.setPayStatus("FAIL");
            return wXApiOrderQueryRspBO;
        }
        if (!"SUCCESS".equals(wXApiOrderQueryRspBO.getResult_code())) {
            rsp.setRspCode("0000");
            rsp.setRspName(wXApiOrderQueryRspBO.getErr_code_des());
            rsp.setPayStatus("FAIL");
            return wXApiOrderQueryRspBO;
        }
        String trade_state = wXApiOrderQueryRspBO.getTrade_state();
        String trade_state_desc = wXApiOrderQueryRspBO.getTrade_state_desc();
        if ("SUCCESS".equals(trade_state)) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            rsp.setPayStatus("SUCCESS");
        } else if ("USERPAYING".equals(trade_state)) {
            rsp.setRspCode("0000");
            rsp.setRspName(trade_state_desc);
            rsp.setPayStatus("PAYING");
        } else if ("NOTPAY".equals(trade_state) || "PAYERROR".equals(trade_state)) {
            this.reverseOrder(req, microPayReqData, rsp);
        } else {
            rsp.setRspCode("0000");
            rsp.setRspName(trade_state_desc);
            rsp.setPayStatus("FAIL");
        }
        return wXApiOrderQueryRspBO;
    }

    private void reverseOrder(WXMicroPayBusiReqBO req, WXApiMicroPayReqBO microPayReqData, WXMicroPayBusiRspBO rsp) throws Exception {
        String cert_path = (String)req.getParamMap().get("certname");
        String cert_password = (String)req.getParamMap().get("certpassword");
        WXReverseOrderBusiReqBO wXReverseOrderBusiReq = new WXReverseOrderBusiReqBO();
        wXReverseOrderBusiReq.setAppId(microPayReqData.getAppid());
        wXReverseOrderBusiReq.setMchId(microPayReqData.getMch_id());
        wXReverseOrderBusiReq.setSubMchId(microPayReqData.getSub_mch_id());
        wXReverseOrderBusiReq.setKey(microPayReqData.getKey());
        wXReverseOrderBusiReq.setOutTradeNo(microPayReqData.getOut_trade_no());
        wXReverseOrderBusiReq.setCertPath(cert_path);
        wXReverseOrderBusiReq.setCertPassword(cert_password);
        WXReverseOrderBusiRspBO wXReverseOrderBusiRsp = this.wXReverseOrderBusiService.dealReverseOrder(wXReverseOrderBusiReq);
        if ("8888".equals(wXReverseOrderBusiRsp.getRspCode())) {
            rsp.setRspCode("8888");
            rsp.setRspName(wXReverseOrderBusiRsp.getRspName());
            rsp.setPayStatus("FAIL");
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u652f\u4ed8\u5f02\u5e38\uff0c\u5df2\u64a4\u5355");
        rsp.setPayStatus("FAIL");
    }
}

