/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProUpdatePayOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.PayProUpdateRefundOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.comb.PayAbleQryRefundStatusCombService;
import com.tydic.payment.pay.comb.bo.PayAbleQryRefundStatusCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleQryRefundStatusCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProAsyncNotice;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@EnableAsync
public class PayAbleQryRefundStatusCombServiceImpl
implements PayAbleQryRefundStatusCombService {
    private static final Logger log = LoggerFactory.getLogger(PayAbleQryRefundStatusCombServiceImpl.class);
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayProUpdatePayOrderInfoAfterRefundBusiService payProUpdatePayOrderInfoAfterRefundBusiService;
    @Autowired
    private PayProUpdateRefundOrderInfoAfterRefundBusiService payProUpdateRefundOrderInfoAfterRefundBusiService;
    @Autowired
    private PayProAsyncNotice payProAsyncNotice;
    private static final String QUERY_SUCCESS = "\u67e5\u8be2\u6210\u529f";
    private static final String ORDER_REFUND_ID_SPLIT = "\uff0c";

    /*
     * Enabled aggressive block sorting
     */
    public PayAbleQryRefundStatusCombRspBo queryRefundStatus(PayAbleQryRefundStatusCombReqBo reqBo) {
        PayAbleQryRefundStatusCombRspBo retBo = new PayAbleQryRefundStatusCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("213015");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long orderId = reqBo.getOrderId();
        PayOrderRspBo orderInfoBo = this.payOrderBusiService.selectOrderByOrderId(reqBo.getOrderId());
        if (orderInfoBo == null || !"0000".equals(orderInfoBo.getRspCode())) {
            retBo.setRespCode("213015");
            retBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        PorderRefundTransPo refundTransPo = this.porderRefundTransAtomService.queryLastRecordByOrderId(orderId);
        if (null == refundTransPo) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setRefundStatus("PAYING");
            retBo.setRefundStatusDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u8fd8\u672a\u53d1\u8d77\u9000\u6b3e");
            return retBo;
        }
        String refundOrderId = refundTransPo.getRefundOrderId();
        Long payMethod = refundTransPo.getPayMethod();
        if ("B10".equals(orderInfoBo.getOrderStatus()) && "B10".equals(refundTransPo.getOrderStatus())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setRefundOrderId(refundOrderId);
            retBo.setTradeTime(orderInfoBo.getTradeTime());
            retBo.setRefundStatus("SUCCESS");
            retBo.setRefundStatusDesc("\u9000\u6b3e\u6210\u529f");
            retBo.setRefundTransId(refundTransPo.getPayNotifyTransId());
            this.setProparedData(retBo, orderInfoBo, refundTransPo);
            if (!"1".equals(reqBo.getNeedNotify())) return retBo;
            this.payProAsyncNotice.sendMessage(orderId, refundTransPo.getPayNotifyTransId());
            return retBo;
        }
        if (!"1".equals(reqBo.getRealQueryFlag())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(QUERY_SUCCESS);
            retBo.setRefundStatus("FAIL");
            retBo.setRefundStatusDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u672a\u9000\u6b3e");
            return retBo;
        }
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
        qryParaBo.setMerchantId(orderInfoBo.getMerchantId());
        qryParaBo.setPayMethod(payMethod);
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("213015");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        PayAbleQryRefundStatusReqBo qryRefundStatusReqBo = new PayAbleQryRefundStatusReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryRefundStatusReqBo);
        qryRefundStatusReqBo.setOrderId(orderId);
        qryRefundStatusReqBo.setRefundOrderId(refundOrderId);
        qryRefundStatusReqBo.setPayOrderId(refundTransPo.getPayOrderId());
        qryRefundStatusReqBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        qryRefundStatusReqBo.setTradeTime(refundTransPo.getTradeTime());
        qryRefundStatusReqBo.setPayNotifyTransId(refundTransPo.getPayNotifyTransId());
        qryRefundStatusReqBo.setCreateTime(refundTransPo.getCreateTime());
        qryRefundStatusReqBo.setTradeTime(refundTransPo.getTradeTime());
        PayAbleQryRefundStatusRspBo qryRefundStatusRetBo = payAble.qryRefundStatus(qryRefundStatusReqBo);
        if (!"0000".equals(qryRefundStatusRetBo.getRespCode())) {
            retBo.setRespCode("213015");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u673a\u6784\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25\uff1a" + qryRefundStatusRetBo.getRespDesc());
            return retBo;
        }
        if ("SUCCESS".equals(qryRefundStatusRetBo.getRefundStatus()) && !"B10".equals(refundTransPo.getOrderStatus())) {
            String validateQueryResultStr = this.validateQueryResult(qryRefundStatusRetBo, payMethod);
            if (!StringUtils.isEmpty((Object)validateQueryResultStr)) {
                log.error(validateQueryResultStr);
                throw new BusinessException("217001", validateQueryResultStr);
            }
            String reslut = this.updateOrderInfo(orderInfoBo, qryRefundStatusRetBo, refundTransPo);
            if (!StringUtils.isEmpty((Object)reslut)) {
                retBo.setRespCode("213015");
                retBo.setRespDesc("\u67e5\u8be2\u56de\u6765\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + reslut);
                return retBo;
            }
            this.setRetBoData(retBo, qryRefundStatusRetBo);
            this.setProparedDate(retBo, orderInfoBo, refundTransPo);
            return retBo;
        }
        retBo.setRefundStatusDesc(qryRefundStatusRetBo.getStatusDesc());
        retBo.setRefundStatus(qryRefundStatusRetBo.getRefundStatus());
        retBo.setRefundOrderId(refundOrderId);
        retBo.setRespCode("0000");
        retBo.setRespDesc(QUERY_SUCCESS);
        retBo.setPayMethod(payMethod);
        return retBo;
    }

    private void setProparedDate(PayAbleQryRefundStatusCombRspBo retBo, PayOrderRspBo orderInfoBo, PorderRefundTransPo refundTransPo) {
        retBo.setCreateOperId(orderInfoBo.getCreateOperId());
        retBo.setMerchantId(orderInfoBo.getMerchantId());
        retBo.setOrderId(orderInfoBo.getOrderId());
        retBo.setOutOrderId(orderInfoBo.getOutOrderId());
        retBo.setOutRemark(orderInfoBo.getOutRemark());
        retBo.setReqWay(orderInfoBo.getReqWay());
        retBo.setTotalFee(MoneyUtils.haoToFen((Long)orderInfoBo.getTotalFee()).longValue() + "");
        retBo.setPayMethod(refundTransPo.getPayMethod());
        retBo.setDetailName(orderInfoBo.getDetailName());
        retBo.setRedirectUrl(orderInfoBo.getRedirectUrl());
    }

    private void setRetBoData(PayAbleQryRefundStatusCombRspBo retBo, PayAbleQryRefundStatusRspBo qryRefundStatusRetBo) {
        retBo.setRespCode("0000");
        retBo.setRespDesc(QUERY_SUCCESS);
        retBo.setRefundOrderId(qryRefundStatusRetBo.getRefundOrderId());
        retBo.setRefundStatus("SUCCESS");
        retBo.setRefundStatusDesc(qryRefundStatusRetBo.getStatusDesc());
        retBo.setTradeTime(qryRefundStatusRetBo.getTradeTime());
        retBo.setRefundTransId(qryRefundStatusRetBo.getPayNotifyTransId());
    }

    private String updateOrderInfo(PayOrderRspBo orderInfoBo, PayAbleQryRefundStatusRspBo qryRefundStatusRetBo, PorderRefundTransPo refundTransPo) {
        PorderPo oriOrderInfo = this.payOrderAtomService.queryPorderByOutOrderIdAndBusiId(orderInfoBo.getOutRefundNo(), orderInfoBo.getBusiId());
        if (null == oriOrderInfo) {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355[{}]\u7684\u4fe1\u606f", (Object)orderInfoBo.getOutRefundNo());
            return "\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355[" + orderInfoBo.getOutRefundNo() + "]\u7684\u4fe1\u606f";
        }
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        String payOrderId = refundTransPo.getPayOrderId();
        orderPayTransAtomReq.setPayOrderId(payOrderId);
        orderPayTransAtomReq.setPayMethod(refundTransPo.getPayMethod());
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        if (transAtomList == null || transAtomList.isEmpty()) {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355[{}]\u7684\u4fe1\u606f", (Object)payOrderId);
            return "\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355[" + payOrderId + "]\u7684\u4fe1\u606f";
        }
        PorderPayTransAtomRspBo payTrans = transAtomList.get(0);
        PayProUpdatePayOrderInfoAfterRefundBusiReqBo updatePayOrderInfoAfterBo = new PayProUpdatePayOrderInfoAfterRefundBusiReqBo();
        updatePayOrderInfoAfterBo.setOrderId(oriOrderInfo.getOrderId());
        updatePayOrderInfoAfterBo.setPayOrderId(payOrderId);
        updatePayOrderInfoAfterBo.setRefundedFee(Long.valueOf(MoneyUtils.haoToFen((Long)oriOrderInfo.getRefundFee()).longValue()));
        updatePayOrderInfoAfterBo.setRefundFee(refundTransPo.getPayFee());
        String oldRefundOrderStr = oriOrderInfo.getOrderRefundId();
        String refundOrderStr = null;
        refundOrderStr = StringUtils.isEmpty((Object)oldRefundOrderStr) ? refundTransPo.getOrderId().toString() : oldRefundOrderStr + ORDER_REFUND_ID_SPLIT + orderInfoBo.getOrderId();
        updatePayOrderInfoAfterBo.setOrderRefundIdStr(refundOrderStr);
        PayProUpdatePayOrderInfoAfterRefundBusiRspBo updateRetBo = this.payProUpdatePayOrderInfoAfterRefundBusiService.updatePayOrderInfo(updatePayOrderInfoAfterBo);
        if (!"0000".equals(updateRetBo.getRespCode())) {
            log.error("\u66f4\u65b0\u539f\u652f\u4ed8\u8ba2\u5355\u53ca\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)updateRetBo.getRespDesc());
            return "\u66f4\u65b0\u539f\u652f\u4ed8\u8ba2\u5355\u53ca\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + updateRetBo.getRespDesc();
        }
        PayProUpdateRefundOrderInfoAfterRefundBusiReqBo updateRefundBo = new PayProUpdateRefundOrderInfoAfterRefundBusiReqBo();
        updateRefundBo.setOrderId(refundTransPo.getOrderId());
        updateRefundBo.setRefundOrderId(qryRefundStatusRetBo.getRefundOrderId());
        updateRefundBo.setRefundTransId(qryRefundStatusRetBo.getPayNotifyTransId());
        updateRefundBo.setRefundFee(qryRefundStatusRetBo.getRealFee());
        updateRefundBo.setTradeTime(qryRefundStatusRetBo.getTradeTime());
        PayProUpdateRefundOrderInfoAfterRefundBusiRspBo updateRefundRetBo = this.payProUpdateRefundOrderInfoAfterRefundBusiService.updateRefundInfo(updateRefundBo);
        if (!"0000".equals(updateRefundRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)updateRefundRetBo.getRespDesc());
            return "\u8c03\u7528\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a{}" + updateRefundRetBo.getRespDesc();
        }
        return null;
    }

    private String validateQueryResult(PayAbleQryRefundStatusRspBo qryRefundStatusRetBo, Long payMethod) {
        if (StringUtils.isEmpty((Object)qryRefundStatusRetBo.getOrderId())) {
            return "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56deorderId";
        }
        if (StringUtils.isEmpty((Object)qryRefundStatusRetBo.getPayNotifyTransId())) {
            return "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56depayNotifyTransId";
        }
        if (StringUtils.isEmpty((Object)qryRefundStatusRetBo.getRefundOrderId())) {
            return "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56derefundOrderId";
        }
        if (StringUtils.isEmpty((Object)qryRefundStatusRetBo.getRealFee())) {
            return "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56derealFee";
        }
        if (StringUtils.isEmpty((Object)qryRefundStatusRetBo.getTradeTime())) {
            return "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56detradeTime";
        }
        return null;
    }

    private void setProparedData(PayAbleQryRefundStatusCombRspBo retBo, PayOrderRspBo orderInfoBo, PorderRefundTransPo refundTransPo) {
        retBo.setCreateOperId(orderInfoBo.getCreateOperId());
        retBo.setMerchantId(orderInfoBo.getMerchantId());
        retBo.setOrderId(orderInfoBo.getOrderId());
        retBo.setOutOrderId(orderInfoBo.getOutOrderId());
        retBo.setOutRemark(orderInfoBo.getOutRemark());
        retBo.setReqWay(orderInfoBo.getReqWay());
        retBo.setTotalFee(MoneyUtils.haoToFen((Long)orderInfoBo.getTotalFee()).longValue() + "");
        retBo.setPayMethod(refundTransPo.getPayMethod());
        retBo.setDetailName(orderInfoBo.getDetailName());
        retBo.setRedirectUrl(orderInfoBo.getRedirectUrl());
    }

    private String validateArgs(PayAbleQryRefundStatusCombReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getOrderId()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

