/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.bo.PayHcxCancelReqBO;
import com.tydic.payment.pay.busi.bo.PayHcxCancelRspBO;
import com.tydic.payment.pay.comb.PayHcxCancelIssueService;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.PayProOrderQueryMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.dao.po.PayProOrderQueryPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.hcx.PayHcxRspConstants;
import com.tydic.payment.pay.payable.impl.transbo.HcxDealCancelRspBO;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayHcxUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.comb.PayHcxCancelIssueService"})
public class PayHcxCancelIssueServiceImpl
implements PayHcxCancelIssueService {
    private static final Logger log = LoggerFactory.getLogger(PayHcxCancelIssueServiceImpl.class);
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayProOrderQueryMapper payProOrderQueryMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayHcxUtil hcxUtil;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;

    @PostMapping(value={"dealCancel"})
    public PayHcxCancelRspBO dealCancel(@RequestBody PayHcxCancelReqBO reqBO) {
        ResponseEntity<String> response;
        log.info("\u8fdb\u5165\u6838\u8d22\u4fe1dealCancel\u65b9\u6cd5\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        PayHcxCancelRspBO rspBO = new PayHcxCancelRspBO();
        String validateCancelArgs = this.validateCancelArgs(reqBO);
        if (!StringUtils.isEmpty((Object)validateCancelArgs)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validateCancelArgs);
            return rspBO;
        }
        String outOrderId = reqBO.getOutOrderId();
        PayProOrderQueryPo payProOrderQueryPo = new PayProOrderQueryPo();
        payProOrderQueryPo.setOutOrderId(outOrderId);
        List<PayProOrderQueryPo> payProOrderQueryPos = this.payProOrderQueryMapper.queryOrderQueryByCondition(payProOrderQueryPo);
        if (payProOrderQueryPos.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("outOrderId:\u3010" + outOrderId + "\u3011,\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25");
            return rspBO;
        }
        PayProOrderQueryPo queryPo = payProOrderQueryPos.get(0);
        Long orderId = queryPo.getOrderId();
        PorderPo porderPo = this.porderMapper.selectByOrderId(orderId);
        if (porderPo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u53f7\uff1a\u3010" + outOrderId + "\u3011,\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25");
            return rspBO;
        }
        PRelOrderParamPO pRelOrderParamPO = new PRelOrderParamPO();
        pRelOrderParamPO.setOrderId(porderPo.getOrderId());
        List<PRelOrderParamPO> pRelOrderParamList = this.pRelOrderParamMapper.getList(pRelOrderParamPO);
        if (pRelOrderParamList.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u53f7\uff1a\u3010" + outOrderId + "\u3011,\u672a\u67e5\u5230\u767d\u6761\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25");
            return rspBO;
        }
        List pkCreditIssueList = pRelOrderParamList.stream().filter(bo -> bo.getParamKey().equals("pkCreditIssue")).collect(Collectors.toList());
        if (pkCreditIssueList.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u53f7\uff1a\u3010" + outOrderId + "\u3011,\u672a\u67e5\u5230\u767d\u6761\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25");
            return rspBO;
        }
        PRelOrderParamPO pkPO = (PRelOrderParamPO)pkCreditIssueList.get(0);
        String pkCreditIssue = ((PRelOrderParamPO)pkCreditIssueList.get(0)).getParamValue();
        String parenterId = this.payPropertiesVo.getHcxPartnerId();
        String parenterName = this.payPropertiesVo.getHcxPartnerName();
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setPayNotifyTransId(pkCreditIssue);
        porderPayTransPo.setOrderId(orderId);
        List<PorderPayTransPo> porderPayTransPos = this.porderPayTransMapper.queryOrderPayTrans(porderPayTransPo);
        PorderPayTransPo resultPo = null;
        if (payProOrderQueryPos.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u652f\u4ed8\u5355");
            return rspBO;
        }
        resultPo = porderPayTransPos.get(0);
        if (pkPO.getParamValue().equals("ISSUING_CANCELED")) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5df2\u53d6\u6d88\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            return rspBO;
        }
        Long serial = PayProSequence.nextId();
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serial", serial.toString());
        reqMap.put("partnerId", parenterId);
        reqMap.put("partnerName", parenterName);
        reqMap.put("partnerBusiId", resultPo.getPayOrderId());
        reqMap.put("pkCredit", pkCreditIssue);
        reqMap.put("remark", reqBO.getCancelReason());
        reqMap.put("operatorName", reqBO.getOperatorName());
        reqMap.put("operatorIdType", reqBO.getOperatorIdType());
        reqMap.put("operatorIdCode", reqBO.getOperatorIdCode());
        String body = JSONObject.toJSONString(reqMap);
        String cancelUrl = this.payPropertiesVo.getHcxCancelUrl();
        log.info("\u8c03\u7528\u6838\u8d22\u4fe1\u63a5\u53e3\u67e5\u72b6\u6001\uff0c \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)body);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        int random = PayHcxUtil.getRandom();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        String clientId = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String token = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        String signUrl = cancelUrl.substring(cancelUrl.lastIndexOf("partner") + 7);
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        headersMap.put("X-SCF-TV", timeStamp.toString());
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-NONCE", Integer.toString(random));
        try {
            response = this.hcxUtil.doPost(cancelUrl, body, MediaType.APPLICATION_JSON, headersMap);
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u6838\u8d22\u4fe1\u53d6\u6d88\u767d\u6761\u670d\u52a1\u5f02\u5e38(\u67e5\u8be2\u767d\u6761\u72b6\u6001)\uff0c\u670d\u52a1\u5730\u5740\uff1a{}", (Object)cancelUrl);
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + cancelUrl + e);
        }
        String responseBody = (String)response.getBody();
        log.info("\u6838\u8d22\u4fe1\u53d6\u6d88\u767d\u6761\uff0c \u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBody);
        HcxDealCancelRspBO cancelRspBO = (HcxDealCancelRspBO)JSONObject.parseObject((String)responseBody, HcxDealCancelRspBO.class);
        if (cancelRspBO == null) {
            log.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return rspBO;
        }
        if (cancelRspBO.getData() == null || !cancelRspBO.getData().getCode().equals(PayHcxRspConstants.SUCCESS.getCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(cancelRspBO.getData().getMessage());
            return rspBO;
        }
        PRelOrderParamPO setPO = new PRelOrderParamPO();
        BeanUtils.copyProperties((Object)pkPO, (Object)setPO);
        setPO.setParamValue("ISSUING_CANCELED");
        this.pRelOrderParamMapper.updateBy(setPO, pkPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u652f\u4ed8\u6210\u529f");
        return rspBO;
    }

    private String validateCancelArgs(PayHcxCancelReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getOutOrderId())) {
            return "outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getCancelReason())) {
            return "cancelReason\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperatorName())) {
            return "operatorName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperatorIdType())) {
            return "operatorIdType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperatorIdCode())) {
            return "operatorIdCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

