/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.comb.PayProOneCodeDealWxCombService;
import com.tydic.payment.pay.comb.PayProOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProOneCodeDealWxCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProOneCodeDealWxCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCreateCombBusiRspDataBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BeanUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.comb.PayProOneCodeDealWxCombService"})
public class PayProOneCodeDealWxCombServiceImpl
implements PayProOneCodeDealWxCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String WX_GET_OPEN_ID_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProOrderCombService payProOrderCombService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;

    @PostMapping(value={"dealWxOneCode"})
    public PayProOneCodeDealWxCombRspBo dealWxOneCode(@RequestBody PayProOneCodeDealWxCombReqBo reqBo) {
        this.LOGGER.info("\u4e00\u7801\u4ed8\u5fae\u4fe1\u626b\u7801\u5904\u7406comb\u670d\u52a1\uff1a" + reqBo);
        PayProOneCodeDealWxCombRspBo retBo = new PayProOneCodeDealWxCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRspCode("213012");
            retBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        StringBuffer basePath = reqBo.getBasePath();
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String oneCodePayHtml = this.payPropertiesVo.getValueByKey("pay.one.code.pay.html");
        if (StringUtils.isEmpty((Object)oneCodePayHtml)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
            throw new BusinessException("217003", "\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
        }
        PayOrderRspBo orderRetBo = this.payOrderBusiService.selectOrderByOrderId(Long.valueOf(reqBo.getOrderId()));
        if (!"0000".equals(orderRetBo.getRspCode())) {
            this.LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + orderRetBo.getRspName());
            retBo.setRspCode("213012");
            retBo.setRspName("\u672a\u67e5\u8be2\u8ba2\u5355\uff08" + reqBo.getOrderId() + ")\u7684\u76f8\u5173\u4fe1\u606f");
            return retBo;
        }
        this.LOGGER.info("\u67e5\u8be2\u51fa\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a" + orderRetBo);
        PayProQueryPayParaBusiReqBo qryPayParaReqBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaReqBo.setPayMethod(PayProConstants.PayMethod.WX_JSP.getPayMethod());
        qryPayParaReqBo.setMerchantId(orderRetBo.getMerchantId());
        PayProQueryPayParaBusiRspBo qryPayParaRetBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaReqBo);
        if (!"0000".equals(qryPayParaRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff1a" + qryPayParaRetBo.getRespDesc());
            retBo.setRspCode("213012");
            retBo.setRspName("\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff1a" + qryPayParaRetBo.getRespDesc());
            return retBo;
        }
        Map paramMap = qryPayParaRetBo.getDetailAttrs();
        String openId = this.getOpenId(paramMap, reqBo.getCode());
        if (StringUtils.isEmpty((Object)openId)) {
            this.LOGGER.error("\u83b7\u53d6openId\u5931\u8d25");
            retBo.setRspCode("213012");
            retBo.setRspName("\u83b7\u53d6openId\u5931\u8d25");
            return retBo;
        }
        this.createOrder(reqBo, retBo, orderRetBo, openId);
        this.LOGGER.info("\u4e00\u7801\u4ed8\u5904\u7406\u5fae\u4fe1\u626b\u7801comb\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + retBo);
        String urlEncodeRetStr = this.urlEncode(retBo);
        String url = basePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(urlEncodeRetStr).toString();
        retBo.setJumpUrl(url);
        return retBo;
    }

    private String validateArgs(PayProOneCodeDealWxCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'orderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'code'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBasePath())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'basePath'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String getOpenId(Map<String, String> paramMap, String code) {
        HttpResponse httpResponse;
        String openId = null;
        String appId = paramMap.get("appid");
        String secret = paramMap.get("appsecret");
        String urlStr = this.payPropertiesVo.getValueByKey("accessTokenUrl");
        if (StringUtils.isEmpty((Object)urlStr)) {
            this.LOGGER.error("\u5fae\u4fe1\u83b7\u53d6openId\u7684\u5730\u5740'accessTokenUrl'\u672a\u914d\u7f6e\uff0c\u5c06\u76f4\u63a5\u4f7f\u7528\u5fae\u4fe1\u63d0\u4f9b\u7684\u5730\u5740");
            urlStr = WX_GET_OPEN_ID_URL;
        }
        StringBuilder url = new StringBuilder(urlStr);
        url.append("&appid=").append(appId).append("&secret=").append(secret).append("&code=").append(code).append("&grant_type=authorization_code");
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet reqGet = new HttpGet(url.toString());
        try {
            httpResponse = client.execute((HttpUriRequest)reqGet);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5411\u5fae\u4fe1\u53d1\u8d77\u83b7\u53d6openId\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38");
            return null;
        }
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            String result;
            HttpEntity entity = httpResponse.getEntity();
            try {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.LOGGER.info("\u83b7\u53d6\u62a5\u6587\u7ed3\u679c\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
                return null;
            }
            this.LOGGER.info("\u83b7\u53d6openId\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            openId = jsonObject.getString("openid");
            this.LOGGER.info("\u83b7\u53d6\u5230\u7684openId\u4e3a\uff1a" + openId);
        }
        return openId;
    }

    private void createOrder(PayProOneCodeDealWxCombReqBo reqBo, PayProOneCodeDealWxCombRspBo retBo, PayOrderRspBo orderRetBo, String openId) {
        PayProOrderCombServiceReqBo orderCombReqBo = new PayProOrderCombServiceReqBo();
        BeanUtils.copyProperties((Object)orderRetBo, (Object)orderCombReqBo);
        orderCombReqBo.setMerchantId(orderRetBo.getMerchantId() + "");
        orderCombReqBo.setBusiId(orderRetBo.getBusiId() + "");
        orderCombReqBo.setTotalFee(reqBo.getTotalFee());
        String extTimeStr = this.payPropertiesVo.getValueByKey("pay.one.code.pay.expire.time");
        if (StringUtils.isEmpty((Object)extTimeStr)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u626b\u7801\u8bb0\u5f55\u8fc7\u671f\u65f6\u95f4'pay.one.code.pay.expire.time'\u672a\u914d\u7f6e\uff0c\u5c06\u8bbe\u7f6e\u9ed8\u8ba4\u503c\uff1a1\u5206\u949f");
            extTimeStr = "1";
        }
        orderCombReqBo.setExtTime(extTimeStr);
        orderCombReqBo.setPayMethod(PayProConstants.PayMethod.WX_JSP.getPayMethod() + "");
        JSONObject busiReqDataJson = new JSONObject();
        busiReqDataJson.put("openId", (Object)openId);
        orderCombReqBo.setBusiReqData(busiReqDataJson.toJSONString());
        this.LOGGER.info("\u51c6\u5907\u8c03\u7528\u7edf\u4e00\u4e0b\u5355comb\u670d\u52a1\uff1a" + orderCombReqBo);
        PayProOrderCombServiceRspBo orderCombRetBo = this.payProOrderCombService.dealOrder(orderCombReqBo);
        this.LOGGER.info("\u8c03\u7528\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a" + orderCombRetBo);
        if (!"0000".equals(orderCombRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528comb\u670d\u52a1\u4e0b\u5355\u5931\u8d25\uff1a" + orderCombRetBo.getRespDesc());
            retBo.setRspCode("213011");
            retBo.setRspName(orderCombRetBo.getRespDesc());
            return;
        }
        if (StringUtils.isEmpty((Object)orderCombRetBo.getBusiRspData())) {
            this.LOGGER.error("\u4e1a\u52a1\u53c2\u6570busiRspData\u4e3a\u7a7a\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9700\u8981\u7684\u4fe1\u606f");
            retBo.setRspCode("213011");
            retBo.setRspName("\u4e1a\u52a1\u53c2\u6570busiRspData\u4e3a\u7a7a\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9700\u8981\u7684\u4fe1\u606f");
            return;
        }
        this.LOGGER.info("\u8c03\u7528\u7edf\u4e00\u4e0b\u5355comb\u670d\u52a1\u4e0b\u5355\u8fd4\u56de\u7684busiRetBo\u4e3a\uff1a" + orderCombRetBo.getBusiRspData());
        JSONObject combBusiDataJson = JSONObject.parseObject((String)orderCombRetBo.getBusiRspData());
        PayProOrderCreateCombBusiRspDataBo combBusiDateBo = (PayProOrderCreateCombBusiRspDataBo)JSONObject.toJavaObject((JSON)combBusiDataJson, PayProOrderCreateCombBusiRspDataBo.class);
        BeanUtils.copyProperties((Object)combBusiDateBo, (Object)retBo);
        retBo.setRedirectUrl(combBusiDateBo.getRedirectUrl());
        retBo.setPackage_(combBusiDateBo.getPackageBody());
        retBo.setDetailName(orderRetBo.getDetailName());
        retBo.setPayOrderId(orderCombRetBo.getPayOrderId());
        retBo.setOrderId(orderCombRetBo.getOrderId());
        retBo.setTotalFee(orderCombRetBo.getPayFee());
        retBo.setChannel(PayProConstants.PayMethod.WX_JSP.getPayMethod() + "");
        retBo.setRspCode("0000");
        retBo.setRspName("\u5931\u8d25");
    }

    private String urlEncode(PayProOneCodeDealWxCombRspBo retBo) {
        try {
            return URLEncoder.encode(JSON.toJSONString((Object)retBo), "utf-8");
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return "\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38";
        }
    }
}

