/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.PayProSubmittedNoticeDataBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayProSubmittedNotice {
    private static final Logger log = LoggerFactory.getLogger(PayProSubmittedNotice.class);
    private static final String RESULT_CODE = "resultCode";
    private static final String NOTIFY_RESULT_CODE = "notifyResult";
    private static final String NOTIFY_RESULT_CODE_CAPITAL = "NOTIFY_RESULT";
    private static final String SUCCESS = "SUCCESS";
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;

    @Async(value="payAsyncExecutor")
    public void submittedNotify(PayProSubmittedNoticeDataBo dataBo) {
        String validateStr = ArgValidator.validateArg((Object)dataBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            return;
        }
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(Long.valueOf(dataBo.getOrderId()));
        if (!"0000".equals(payOrderRspBo.getRspCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)payOrderRspBo.getRspName());
            return;
        }
        if (StringUtils.isEmpty((Object)payOrderRspBo.getOrderAttrValue2())) {
            log.error("\u6b64\u8ba2\u5355\u6ca1\u6709\u5728\u4fdd\u7559\u5b57\u6bb52\u3010OrderAttrValue2\u3011\u4fdd\u5b58\u5411\u7b2c\u4e09\u65b9\u652f\u4ed8\u673a\u6784\u63d0\u4ea4\u4ed8\u6b3e\u4fe1\u606f\u6210\u529f\u901a\u77e5\u5730\u5740");
            return;
        }
        String notifyAddress = payOrderRspBo.getOrderAttrValue2();
        JSONObject msgJson = JSON.parseObject((String)JSON.toJSONString((Object)dataBo));
        msgJson.remove((Object)"notifyAddress");
        msgJson.remove((Object)"busiId");
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(dataBo.getBusiId());
        dataEncryptionReqBo.setContent(msgJson.toJSONString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        log.info("\u901a\u77e5\u7684\u6d88\u606f\u4e3b\u9898\u5185\u5bb9\u4e3a\uff1a{}\uff0c\u76ee\u6807\u5730\u5740\u4e3a\uff1a{}", (Object)dataEncryptionRspBo.getEncrypData(), (Object)notifyAddress);
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("busiCode", dataBo.getBusiCode());
        postData.put("content", dataEncryptionRspBo.getEncrypData());
        String result = HttpUtil.post((String)notifyAddress, postData);
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            log.debug("\u8c03\u7528\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (result.contains(RESULT_CODE) || result.contains(NOTIFY_RESULT_CODE) || result.contains(NOTIFY_RESULT_CODE_CAPITAL)) {
            if (result.contains(SUCCESS)) {
                log.debug("===========\u672c\u6b21\u901a\u77e5\u6210\u529f===========");
            } else {
                log.debug("===========\u672c\u6b21\u901a\u77e5\u5931\u8d25===========");
            }
        } else {
            log.debug("===========\u672c\u6b21\u901a\u77e5\u5931\u8d25===========");
        }
    }
}

