/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.constant;

import java.util.ArrayList;
import java.util.List;

public class PayProConstants {

    public class ChinaBankRealPayFlag {
        public static final String PAY_CENTER_TRIGGER = "payCenterTrigger";
    }

    public class HcxLimitType {
        public static final String SOURCE_SELF = "SOURCE_SELF";
        public static final String SOURCE_SELF_NAME = "\u81ea\u6709\u989d\u5ea6";
        public static final String SOURCE_GROUP = "SOURCE_GROUP";
        public static final String SOURCE_GROUP_NAME = "\u96c6\u56e2\u989d\u5ea6";
        public static final String SOURCE_CORE = "SOURCE_CORE";
        public static final String SOURCE_CORE_NAME = "\u6838\u5fc3\u4f01\u4e1a\u989d\u5ea6";
    }

    public class HcxParam {
        public static final String PK_CREDIT_ISSUE = "pkCreditIssue";
    }

    public class HcxProductType {
        public static final String CREDIT = "0";
        public static final String CREDIT_NAME = "\u767d\u6761";
    }

    public class HcxCreditStatus {
        public static final String ISSUE = "ISSUE";
        public static final String ISSUING = "ISSUING";
        public static final String ISSUING_REFUSED = "ISSUING_REFUSED";
        public static final String ISSUING_CANCELED = "ISSUING_CANCELED";
        public static final String DISCARD = "DISCARD";
        public static final String ISSUED = "ISSUED";
        public static final String REDEEM = "REDEEM";
        public static final String REDEEMING = "REDEEMING";
        public static final String REDEEMED = "REDEEMED";
        public static final String RECOVER = "RECOVER";
        public static final String RECOVERED = "RECOVERED";
    }

    public class PayHcxHeadersConstants {
        public static final String X_SCF_TV = "X-SCF-TV";
        public static final String X_SCF_NONCE = "X-SCF-NONCE";
        public static final String X_SCF_SIGN = "X-SCF-SIGN";
        public static final String X_SCF_AUTH_TOKEN = "X-SCF-AUTH-TOKEN";
    }

    public static enum HcxPayParamConstants {
        PARAM_CORP_NAME_CORE("corpNameCore"),
        PARAM_CORP_ID_TYPE_CORE("corpIdTypeCore"),
        PARAM_CORP_ID_CODE_CORE("corpIdCodeCore"),
        PARAM_CORP_NAME_SOURCE("corpNameSource"),
        PARAM_CORP_ID_TYPE_SOURCE("corpIdTypeSource"),
        PARAM_CORP_ID_CODE_SOURCE("corpIdCodeSource"),
        PARAM_CORP_NAME_ACCEPT("corpNameAccept"),
        PARAM_CORP_ID_TYPE_ACCEPT("corpIdTypeAccept"),
        PARAM_CORP_ID_Code_ACCEPT("corpIdCodeAccept"),
        PARAM_MATURITY_DATE("maturityDate");

        private String value;

        private HcxPayParamConstants(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class CnncCaiQiTongStatus {
        public static final String FAIL = "01";
        public static final String WILL_DEAL = "02";
        public static final String DEALING = "03";
        public static final String COMPLETED = "04";
        public static final String REFUSED = "05";
    }

    public static class ICBCPayStatus {
        public static final String WAIT_SUBMIT = "0";
        public static final String SUCCESS = "1";
        public static final String FIAL = "2";
        public static final String PROCESSING = "3";
        public static final String PARTIAL_SUCCESS = "4";
        public static final String REFUND = "5";
    }

    public class ChinaPayStatus {
        public static final String SUCCESS = "0000";
        public static final String PAYING = "0001";
        public static final String SENT = "1015";
        public static final String REFUND_FAIL = "0009";
        public static final String REDOUNDING = "1003";
        public static final String REFUND_SUCCESS = "1013";
        public static final String TRANCE_CANCEL = "0012";
        public static final String REFUND_CANCEL = "1007";
    }

    public static enum CashPayStatus {
        A00("A00"),
        A10("A10"),
        A20("A20"),
        B10("B10"),
        B20("B20");

        private String value;

        private CashPayStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum WxPayTradeStatus {
        SUCCESS("SUCCESS"),
        NOTPAY("NOTPAY"),
        USERPAYING("USERPAYING"),
        REVOKED("REVOKED"),
        PAYERROR("PAYERROR"),
        CLOSED("CLOSED"),
        REFUND("REFUND");

        private String value;

        private WxPayTradeStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class GenericConstants {
        public static final String REAL_QUERY_FLAG_YES = "1";
        public static final String PAY_NOTIFY_CODE_YES = "0";
        public static final String PAY_NOTIFY_CODE_NOT = "1";
        public static final String QUERY_PAY_TRANS_REVERSE = "1";
        public static final String WX_REFUND_FLAG_OUTTER = "1";
        public static final String PAY_CENTER_FILE_SERVER_PATH = "payCenter/";
        public static final String PAY_TRANS = "Trans";
        public static final String NEED_NOTIFY = "1";
    }

    public class AliPayConstants {
        public static final String FORMAT = "json";
        public static final String CHARSET = "UTF-8";
        public static final String SIGNTYPE = "RSA2";
    }

    public static enum AliPayTradeStatus {
        WAIT_BUYER_PAY("WAIT_BUYER_PAY"),
        TRADE_CLOSED("TRADE_CLOSED"),
        TRADE_SUCCESS("TRADE_SUCCESS"),
        TRADE_FINISHED("TRADE_FINISHED");

        private String value;

        private AliPayTradeStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PayMethod {
        WX_BAR(10L),
        WX_QR(11L),
        WX_APP(12L),
        WX_H5(13L),
        WX_JSP(14L),
        WX_APPLET(15L),
        ALI_BAR(20L),
        ALI_QR(21L),
        ALI_APP(22L),
        ALI_H5(23L),
        ALI_WEB(24L),
        ALI_HB_FQ(26L),
        ALI_XCX(27L),
        ALI_TRANS(28L),
        ALI_SING(29L),
        ALI_DEDUCT(210L),
        ALI_APPLET(211L),
        CASH_PAY(30L),
        WOPAY_MOBILE(50L),
        SUPPLY_CHAIN_FINANCE(61L),
        UNION_PAY_ACP(110L),
        UNION_PAY_QR_CB(112L),
        UNION_PAY_WAP(113L),
        UMC_PAY_BALANCE(140L),
        BEST_PAY(150L),
        CNNC_CQT_PUBLIC(160L),
        CNNC_CQT_REAL_PAY(161L),
        CHINA_PAY_NO_CARD(170L),
        CHINA_BANK_ORDER_PAY(180L),
        CHINA_BANK_REAL_PAY(181L),
        ICBC_E_PAY(190L),
        HCX_PAY(61L);

        private Long payMethod;

        private PayMethod(Long payMethod) {
            this.payMethod = payMethod;
        }

        public static List<Long> getAllPayMethod() {
            ArrayList<Long> payMethods = new ArrayList<Long>();
            for (PayMethod payMethod : PayMethod.values()) {
                payMethods.add(payMethod.getPayMethod());
            }
            return payMethods;
        }

        public static boolean containsPayMethod(Long payMethod) {
            if (payMethod == null) {
                return false;
            }
            List<Long> allPayMethod = PayMethod.getAllPayMethod();
            for (Long method : allPayMethod) {
                if (method.longValue() != payMethod.longValue()) continue;
                return true;
            }
            return false;
        }

        public Long getPayMethod() {
            return this.payMethod;
        }
    }
}

