/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.chinabankpay.util.Base64;
import com.tydic.payment.pay.chinabankpay.util.PKCSTool;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankBodyReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankHeadReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankOrderRspBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankRequestBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankResponseBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankTranRspBo;
import com.tydic.payment.pay.util.FileDownloader;
import com.tydic.payment.pay.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public abstract class AbstractChinaBankPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractAliPayAble.class);
    private static final String STATE_CODE_SUCCESS = "OK";
    private static final String TRAN_STATUS_FAIL = "2";
    private static final String INIT_STATUS = "0";
    private static final String ORDER_PAY_SUCCESS = "T1";
    private static final String ORDER_PAY_FAILURE = "T2";
    private static final String ORDER_PAY_UNKNOW = "T3";
    private static final String DEDUCTION_SUCCESS = "T4";
    private static final String REAL_PAY_SUCCESS = "P1";
    private static final String REAL_PAY_FAILURE = "P2";
    private static final String REAL_PAY_UNKNOW = "P3";
    private static final String EXPIRE = "10";
    protected static String CHINA_BANK_MER_ID;
    protected static String CHINA_BANK_MER_PWD;
    protected static String CHINA_BANK_MER_PFX;
    protected static String CHINA_BANK_CA_CERT;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Value(value="${china.bank.cer.url:http://192.168.3.153:8888/group1/M00/02/AB/wKgDNWAdB6GAE5JMAAAKYQgM-zg777.cer}")
    private String cerUrl;
    @Value(value="${china.bank.pfx.url:http://192.168.3.153:8888/group1/M00/21/9C/wKgDNWQdKIWALcSzAAAKYa2nkCQ402.pfx}")
    private String pfxUrl;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        log.debug("\u4e2d\u884c\u9000\u6b3e\u5904\u7406\u65b9\u6cd5\uff1a{}", (Object)reqBo);
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateParamStr = this.validateRefundParam(reqBo);
        if (!StringUtils.isEmpty((Object)validateParamStr)) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateParamStr);
            return retBo;
        }
        String qryTranPath = this.payPropertiesVo.getValueByKey("china.bank.tran.query.url");
        log.debug("\u4e2d\u884c\u5546\u6237\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)qryTranPath);
        if (StringUtils.isEmpty((Object)qryTranPath)) {
            log.error("\u4e2d\u884c\u4ea4\u6613\u67e5\u8be2\u5730\u5740'china.bank.tran.query.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u4e2d\u884c\u4ea4\u6613\u67e5\u8be2\u5730\u5740'china.bank.tran.query.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        Map<String, Object> reqQryTranMap = this.assembleQryTranData(reqBo);
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u7684\u8bf7\u6c42\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(reqQryTranMap));
        if (reqQryTranMap == null) {
            log.error("\u4e2d\u884c-\u4ea4\u6613\u67e5\u8be2\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c-\u4ea4\u6613\u67e5\u8be2\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            return retBo;
        }
        String retTranStr = HttpUtil.post((String)qryTranPath, reqQryTranMap);
        log.debug("\u4e2d\u884c-\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retTranStr);
        String tranResult = new String(Base64.decode((String)retTranStr));
        ChinaBankResponseBo qryTranRspBo = null;
        try {
            qryTranRspBo = (ChinaBankResponseBo)XmlUtils.xmlToObj(tranResult, ChinaBankResponseBo.class);
        }
        catch (Exception e) {
            log.error("\u4e2d\u884c\u4ea4\u6613\u67e5\u8be2\u5b9e\u73b0\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c{}" + e.getMessage());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u4ea4\u6613\u67e5\u8be2\u5b9e\u73b0\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u6709\u8bef");
            return retBo;
        }
        if (!STATE_CODE_SUCCESS.equals(qryTranRspBo.getHead().getResponseCode())) {
            log.error("\u4e2d\u884c\u9000\u6b3e-\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)qryTranRspBo.getHead().getResponseInfo());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u9000\u6b3e-\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + qryTranRspBo.getHead().getResponseInfo());
            return retBo;
        }
        if (qryTranRspBo.getBody().getOrderTrans().size() != 1) {
            log.error("\u4e2d\u884c\u9000\u6b3e\u5931\u8d25\uff0c\u5df2\u5b9e\u4ed8\uff0c\u4e0d\u53ef\u53d1\u8d77\u9000\u6b3e");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u9000\u6b3e\u5931\u8d25\uff0c\u5df2\u5b9e\u4ed8\uff0c\u4e0d\u53ef\u53d1\u8d77\u9000\u6b3e");
            return retBo;
        }
        String refundPath = this.payPropertiesVo.getValueByKey("china.bank.real.pay.url");
        log.debug("\u4e2d\u884c\u5546\u6237\u9000\u6b3e\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)refundPath);
        if (StringUtils.isEmpty((Object)refundPath)) {
            log.error("\u4e2d\u884c\u5546\u6237\u9000\u6b3e\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u9000\u6b3e\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        Map<String, Object> reqRefundMap = this.assembleRefundData(reqBo, qryTranRspBo);
        String retRefundStr = HttpUtil.post((String)refundPath, reqRefundMap);
        log.debug("\u4e2d\u884c-\u9000\u6b3e\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retTranStr);
        ChinaBankResponseBo responseBo = this.base64DeCode(retRefundStr);
        if (responseBo == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u9000\u6b3e\u5b9e\u73b0\u63a5\u53e3\uff0c\u8fd4\u56de\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25");
            return retBo;
        }
        if (!STATE_CODE_SUCCESS.equals(responseBo.getHead().getResponseCode())) {
            log.error("\u4e2d\u884c\u9000\u6b3e\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseBo.getHead().getResponseInfo());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u9000\u6b3e\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + responseBo.getHead().getResponseInfo());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRefundTransId(responseBo.getBody().getTranSeq());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        log.debug("\u4e2d\u884c\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u5904\u7406\u65b9\u6cd5\uff1a{}", (Object)reqBo);
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateParamStr = this.validateQryParam(reqBo);
        if (!StringUtils.isEmpty((Object)validateParamStr)) {
            retBo.setRespCode("212060");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateParamStr);
            return retBo;
        }
        String chinaBankOrderQueryUrl = this.payPropertiesVo.getChinaBankOrderQueryUrl();
        if (StringUtils.isEmpty((Object)chinaBankOrderQueryUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u884c\u67e5\u8be2\u8ba2\u5355\u5730\u5740(CHINA_BANK_ORDER_QUERY_URL)\u672a\u914d\u7f6e");
            throw new BusinessException("216038", "\u4e2d\u56fd\u94f6\u884c\u67e5\u8be2\u8ba2\u5355\u5730\u5740(CHINA_BANK_ORDER_QUERY_URL)\u672a\u914d\u7f6e");
        }
        Map<String, Object> reqMap = this.assembleData(reqBo);
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u7684\u8bf7\u6c42\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(reqMap));
        if (reqMap == null) {
            log.error("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            return retBo;
        }
        String retStr = HttpUtil.post((String)chinaBankOrderQueryUrl, reqMap);
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retStr);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        this.sortQryStatusRetBo(retStr, retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        log.debug("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a{}", (Object)reqBo);
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("212060");
            retBo.setRespDesc("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        log.debug("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u7684\u56de\u8c03\u62a5\u6587\u4e3a\uff1a{}", (Object)reqBo.getReqData());
        this.init();
        JSONObject reqJson = JSONObject.parseObject((String)reqBo.getReqData());
        String message = reqJson.getString("message");
        String signature = reqJson.getString("signature");
        String rtnStr = message + "," + signature;
        ChinaBankResponseBo notifyData = this.base64DeCode(rtnStr);
        if (notifyData == null) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("212061");
            retBo.setRespDesc("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return retBo;
        }
        log.debug("\u8f6c\u6362\u540e\u7684\u56de\u8c03\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)notifyData));
        if (!STATE_CODE_SUCCESS.equals(notifyData.getHead().getResponseCode())) {
            log.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            retBo.setRespCode("212061");
            retBo.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return retBo;
        }
        if (TRAN_STATUS_FAIL.equals(notifyData.getBody().getTranStatus())) {
            log.error("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u5931\u8d25");
            retBo.setRespCode("212062");
            retBo.setRespDesc("\u4e2d\u884c\u4fdd\u4ed8\u652f\u4ed8\u5931\u8d25");
            return retBo;
        }
        retBo.setPayNotifyTransId(notifyData.getBody().getOrderSeq());
        retBo.setPayOrderId(notifyData.getBody().getOrderNo());
        retBo.setTradeTime(notifyData.getBody().getTranTime());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateQryParam(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    private String validateRefundParam(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getRefundFee() == null) {
            return "\u5165\u53c2\u5c5e\u6027'refundFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    protected String validateParaMap(Map<String, String> paraMap) {
        if (StringUtils.isEmpty(paraMap)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("chinaBankAccountNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'chinaBankAccountNo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("chinaBankAccountName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'chinaBankAccountName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.init();
    }

    private Map<String, Object> assembleData(PayAbleQryPayStatusReqBo reqBo) {
        ChinaBankRequestBo chinaBankRequestBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo headReqBo = new ChinaBankHeadReqBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        headReqBo.setRequestTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        chinaBankRequestBo.setHead(headReqBo);
        ChinaBankBodyReqBo bodyReqBo = new ChinaBankBodyReqBo();
        bodyReqBo.setOrderNos(reqBo.getPayOrderId());
        chinaBankRequestBo.setBody(bodyReqBo);
        log.debug("\u4e2d\u884c-\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)chinaBankRequestBo));
        String messageId = "0000111";
        return this.assembleFormData(chinaBankRequestBo, messageId);
    }

    private Map<String, Object> assembleQryTranData(PayAbleRefundReqBo reqBo) {
        ChinaBankRequestBo chinaBankRequestBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo headReqBo = new ChinaBankHeadReqBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        headReqBo.setRequestTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        chinaBankRequestBo.setHead(headReqBo);
        ChinaBankBodyReqBo bodyReqBo = new ChinaBankBodyReqBo();
        bodyReqBo.setOrderNo(reqBo.getPayOrderId());
        chinaBankRequestBo.setBody(bodyReqBo);
        log.debug("\u4e2d\u884c-\u67e5\u8be2\u4ea4\u6613\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)chinaBankRequestBo));
        String messageId = "0000112";
        return this.assembleFormData(chinaBankRequestBo, messageId);
    }

    private Map<String, Object> assembleRefundData(PayAbleRefundReqBo reqBo, ChinaBankResponseBo tranRspBo) {
        ChinaBankRequestBo chinaBankRequestBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo headReqBo = new ChinaBankHeadReqBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        headReqBo.setRequestTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        chinaBankRequestBo.setHead(headReqBo);
        ChinaBankBodyReqBo bodyReqBo = new ChinaBankBodyReqBo();
        bodyReqBo.setOrderNo(reqBo.getPayOrderId());
        bodyReqBo.setCurrency("156");
        bodyReqBo.setAmount(String.valueOf(reqBo.getTotalFee() - reqBo.getRefundFee()));
        bodyReqBo.setInterestFlag(INIT_STATUS);
        bodyReqBo.setTraceNo(new DateTime((Object)dbDate).toString("HHmmss") + reqBo.getPayOrderId().substring(7));
        ChinaBankTranRspBo tran = tranRspBo.getBody().getOrderTrans().get(0);
        bodyReqBo.setPayeeActNum(tran.getPayerActNum());
        bodyReqBo.setPayeeActNam(tran.getPayerActNam());
        bodyReqBo.setPayeeCnaps(tran.getPayerBnkEpsbtp());
        bodyReqBo.setPayeeBnkNam(tran.getPayerBnkNam());
        chinaBankRequestBo.setBody(bodyReqBo);
        log.debug("\u4e2d\u884c-\u9000\u6b3e\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)chinaBankRequestBo));
        String messageId = "0000116";
        return this.assembleFormData(chinaBankRequestBo, messageId);
    }

    protected Map<String, Object> assembleFormData(ChinaBankRequestBo chinaBankRequestBo, String messageId) {
        String version = "1.0.1";
        String security = "P7";
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            map.put("merchantNo", Base64.encode((byte[])CHINA_BANK_MER_ID.getBytes("UTF-8")));
            map.put("version", Base64.encode((byte[])version.getBytes("UTF-8")));
            map.put("messageId", Base64.encode((byte[])messageId.getBytes("UTF-8")));
            map.put("security", Base64.encode((byte[])security.getBytes("UTF-8")));
            String originalMessage = "";
            try {
                originalMessage = XmlUtils.objToXml(chinaBankRequestBo);
            }
            catch (Exception e) {
                log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
            }
            map.put("message", Base64.encode((byte[])originalMessage.getBytes("UTF-8")));
            String signature = this.doSign(originalMessage);
            if (StringUtils.isEmpty((Object)signature)) {
                return null;
            }
            map.put("signature", signature);
            log.debug("\u4e2d\u884c-\u8ba2\u5355\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(map));
        }
        catch (Exception e) {
            log.error("\u4e2d\u884c-\u8ba2\u5355\u5165\u53c2\u7ec4\u88c5\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return null;
        }
        return map;
    }

    private void sortQryStatusRetBo(String retStr, PayAbleQryPayStatusRspBo retBo) {
        retStr = new String(Base64.decode((String)retStr));
        ChinaBankResponseBo responseBo = null;
        try {
            responseBo = (ChinaBankResponseBo)XmlUtils.xmlToObj(retStr, ChinaBankResponseBo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!STATE_CODE_SUCCESS.equals(responseBo.getHead().getResponseCode())) {
            log.debug("\u4e2d\u884c\u8ba2\u5355\u652f\u4ed8\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseBo.getHead().getResponseInfo());
            retBo.setRespCode("8888");
            retBo.setRespDesc(responseBo.getHead().getResponseInfo());
            return;
        }
        ChinaBankOrderRspBo orderRspBo = responseBo.getBody().getOrder().get(0);
        switch (orderRspBo.getOrderStatus()) {
            case "0": 
            case "T4": {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u652f\u4ed8\u4e2d");
                break;
            }
            case "T1": 
            case "P1": {
                retBo.setTradeTime(orderRspBo.getLastTranTime());
                retBo.setPayNotifyTransId(orderRspBo.getOrderSeq());
                retBo.setRealFee(Long.valueOf(Long.parseLong(orderRspBo.getAmount())));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f\uff08\u4e2d\u884c\uff09");
                break;
            }
            case "T2": 
            case "P2": 
            case "10": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5931\u8d25\uff08\u4e2d\u884c\uff09");
                break;
            }
            case "T3": {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u652f\u4ed8\u672a\u660e\uff08\u4e2d\u884c\uff09\uff0c\u4ed8\u6b3e\u4eba\u672a\u5b8c\u6210\u7ecf\u529e\u590d\u6838\u6388\u6743");
                break;
            }
            case "P3": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u5b9e\u4ed8\u672a\u660e\uff08\u4e2d\u884c\uff09");
                break;
            }
            default: {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8fd4\u56de\u4e86\u672a\u77e5\u72b6\u6001\u503c");
            }
        }
    }

    protected String doSign(String message) {
        String signKeyFilePath = "";
        String signType = "PKCS7";
        String sign = "";
        try {
            String chinaBankCert = CHINA_BANK_MER_PFX;
            log.debug("\u8bc1\u4e66\u6240\u5728\u76ee\u5f55\u53ca\u540d\u79f0\uff1a{}", (Object)chinaBankCert);
            File chinaBankPayCertFile = FileDownloader.downloadFile(this.pfxUrl);
            signKeyFilePath = chinaBankPayCertFile.getAbsolutePath();
            log.debug("\u4eceoss\u83b7\u53d6\u8bc1\u4e66\u5b8c\u6bd5\uff0c\u8bc1\u4e66\u8def\u5f84\u4e3a\uff1a{}", (Object)signKeyFilePath);
        }
        catch (Exception e) {
            log.error("\u4eceOSS\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216038", "\u4eceOSS\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
        }
        try {
            log.debug("\u51c6\u5907\u7b7e\u540d\u5de5\u5177");
            PKCSTool tool = PKCSTool.getSigner((String)signKeyFilePath, (String)CHINA_BANK_MER_PWD, (String)CHINA_BANK_MER_PWD, (String)signType);
            byte[] messageBytes = message.getBytes("UTF-8");
            log.debug("\u7b7e\u540d\u5de5\u5177\u51c6\u5907\u5b8c\u6bd5\uff0c\u5f00\u59cb\u7b7e\u540d\uff0c\u7b7e\u540d\u5185\u5bb9\u4e3a\uff1a{}", (Object)message);
            sign = tool.p7Sign(messageBytes);
            log.debug("\u4e2d\u884c-p7\u7b7e\u540d\u6210\u529f\uff0c\u7b7e\u540d\u4e3a\uff1a{}", (Object)sign);
        }
        catch (Exception e) {
            log.error("\u4e2d\u884c-\u7b7e\u540d\u5931\u8d25" + e);
            throw new BusinessException("216038", "\u4e2d\u884c-\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
        }
        return sign;
    }

    protected ChinaBankResponseBo base64DeCode(String rtnStr) {
        int subIndex = rtnStr.indexOf(",");
        if (subIndex == -1) {
            log.error("\u8fd4\u56de\u53c2\u6570\u6570\u636e\u5185\u5bb9\u6216\u683c\u5f0f\u4e0d\u6b63\u786e");
            return null;
        }
        String message = rtnStr.substring(0, subIndex);
        String signture = rtnStr.substring(subIndex + 1);
        ChinaBankResponseBo chinaBankResponseBo = null;
        String signKeyFilePath = "";
        try {
            String chinaBankCert = CHINA_BANK_CA_CERT;
            log.debug("oss\u8bc1\u4e66\u8def\u5f84\uff1a{}", (Object)chinaBankCert);
            File chinaBankCaCertFile = FileDownloader.downloadFile(this.cerUrl);
            signKeyFilePath = chinaBankCaCertFile.getAbsolutePath();
            log.debug("\u4eceoss\u83b7\u53d6\u8bc1\u4e66\u5b8c\u6bd5\uff0c\u8bc1\u4e66\u8def\u5f84\u4e3a\uff1a{}", (Object)signKeyFilePath);
        }
        catch (Exception e) {
            log.error("\u4eceOSS\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216038", "\u4eceOSS\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
        }
        try {
            String originalMessage = new String(Base64.decode((String)message), "UTF-8");
            chinaBankResponseBo = (ChinaBankResponseBo)XmlUtils.xmlToObj(originalMessage, ChinaBankResponseBo.class);
            log.debug("\u4e2d\u884c-\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u6210\u529f");
            if (!STATE_CODE_SUCCESS.equals(chinaBankResponseBo.getHead().getResponseCode())) {
                return chinaBankResponseBo;
            }
            FileInputStream fis4cer = new FileInputStream(signKeyFilePath);
            PKCSTool verifierTool = PKCSTool.getVerifier((InputStream)fis4cer, null);
            verifierTool.p7Verify(signture, originalMessage.getBytes("UTF-8"));
            log.debug("\u4e2d\u884c-p7\u9a8c\u7b7e\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u8fd4\u56de\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff1a" + e);
            return null;
        }
        return chinaBankResponseBo;
    }

    protected String init() {
        CHINA_BANK_MER_ID = this.payPropertiesVo.getValueByKey("china.bank.mer.id");
        if (StringUtils.isEmpty((Object)CHINA_BANK_MER_ID)) {
            log.error("*\u4e2d\u56fd\u94f6\u884c\u7f51\u5173\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.bank.mer.id");
            return "\u4e2d\u56fd\u94f6\u884c\u7f51\u5173\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.bank.mer.id";
        }
        CHINA_BANK_MER_PFX = this.payPropertiesVo.getValueByKey("china.bank.mer.pfx");
        if (StringUtils.isEmpty((Object)CHINA_BANK_MER_PFX)) {
            log.error("*\u4e2d\u56fd\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.bank.mer.pfx");
            return "\u4e2d\u56fd\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.bank.mer.pfx";
        }
        CHINA_BANK_CA_CERT = this.payPropertiesVo.getValueByKey("china.bank.ca.cert");
        if (StringUtils.isEmpty((Object)CHINA_BANK_CA_CERT)) {
            log.error("*\u4e2d\u56fd\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.bank.ca.cert");
            return "\u4e2d\u56fd\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.bank.ca.cert";
        }
        CHINA_BANK_MER_PWD = this.payPropertiesVo.getValueByKey("china.bank.mer.pwd");
        if (StringUtils.isEmpty((Object)CHINA_BANK_MER_PWD)) {
            log.error("*\u4e2d\u56fd\u94f6\u884c\u79c1\u94a5\u5bc6\u7801\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.bank.mer.pwd");
            return "\u4e2d\u56fd\u94f6\u884c\u79c1\u94a5\u5bc6\u7801\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.bank.mer.pwd";
        }
        return null;
    }
}

