/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.hcx.PayHcxRspConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.HcxNotifyRspBO;
import com.tydic.payment.pay.payable.impl.transbo.HcxQueryStateRspBO;
import com.tydic.payment.pay.util.PayHcxUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

public abstract class AbstractHcxPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractHcxPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayHcxUtil hcxUtil;
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        return null;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        log.info("\u8fdb\u5165\u6838\u8d22\u4fe1dealCallBack\u65b9\u6cd5\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        PayAbleCallBackRspBo rspBO = new PayAbleCallBackRspBo();
        String validateStr = this.validateCallBackArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            rspBO.setRespCode("212008");
            rspBO.setRespDesc(validateStr);
            return rspBO;
        }
        String resultBody = reqBo.getReqData();
        log.debug("\u56de\u8c03\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)resultBody);
        HcxNotifyRspBO hcxNotifyRspBO = (HcxNotifyRspBO)JSONObject.parseObject((String)resultBody, HcxNotifyRspBO.class);
        if (hcxNotifyRspBO == null) {
            log.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return rspBO;
        }
        if ("ISSUING_REFUSED".equals(hcxNotifyRspBO.getCreditState())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5df2\u62d2\u6536");
            return rspBO;
        }
        if ("ISSUING_CANCELED".equals(hcxNotifyRspBO.getCreditState())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5df2\u64a4\u56de");
            return rspBO;
        }
        String payOrderId = hcxNotifyRspBO.getPartnerBusiId();
        if (!"ISSUED".equals(hcxNotifyRspBO.getCreditState())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        Date nowData = new Date();
        String nowDataStr = simpleDateFormat.format(nowData);
        rspBO.setTradeTime(nowDataStr);
        rspBO.setPayOrderId(payOrderId);
        rspBO.setPayNotifyTransId(hcxNotifyRspBO.getPkCredit());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static void main(String[] args) {
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        ResponseEntity<String> response;
        PayAbleQryPayStatusRspBo rspBO = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateArgStr(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("212008");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        String queryStateUrl = this.payPropertiesVo.getHcxQueryStateUrl();
        if (StringUtils.isEmpty((Object)queryStateUrl)) {
            log.error("\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.query.State.url)\u672a\u914d\u7f6e");
            throw new BusinessException("218024", "\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.query.State.url)\u672a\u914d\u7f6e");
        }
        log.info("\u8c03\u7528\u6838\u8d22\u4fe1\u63a5\u53e3\u7684\u5730\u5740\uff08\u67e5\u72b6\u6001\uff09\uff1a" + queryStateUrl);
        Long serial = PayProSequence.nextId();
        String partnerId = this.payPropertiesVo.getHcxPartnerId();
        String partnerName = this.payPropertiesVo.getHcxPartnerName();
        String partnerBusiId = reqBo.getPayOrderId();
        PRelOrderParamPO pRelOrderParamPO = new PRelOrderParamPO();
        pRelOrderParamPO.setOrderId(reqBo.getOrderId());
        pRelOrderParamPO.setStatus(1);
        List<PRelOrderParamPO> list = this.pRelOrderParamMapper.getList(pRelOrderParamPO);
        List resultList = list.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_CORE.getValue())).collect(Collectors.toList());
        String corpNameCore = ((PRelOrderParamPO)resultList.get(0)).getParamValue();
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serial", serial.toString());
        reqMap.put("partnerId", partnerId);
        reqMap.put("partnerName", partnerName);
        reqMap.put("partnerBusiId", partnerBusiId);
        reqMap.put("corpNameCore", corpNameCore);
        String body = JSONObject.toJSONString(reqMap);
        log.info("\u8c03\u7528\u6838\u8d22\u4fe1\u63a5\u53e3\u67e5\u72b6\u6001\uff0c \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)body);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        int random = PayHcxUtil.getRandom();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        String clientId = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String token = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        String signUrl = queryStateUrl.substring(queryStateUrl.lastIndexOf("partner") + 7);
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        headersMap.put("X-SCF-TV", timeStamp.toString());
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-NONCE", Integer.toString(random));
        try {
            response = this.hcxUtil.doPost(queryStateUrl, body, MediaType.APPLICATION_JSON, headersMap);
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38(\u67e5\u8be2\u767d\u6761\u72b6\u6001)\uff0c\u670d\u52a1\u5730\u5740\uff1a{} --------\u9519\u8bef\u4fe1\u606f\uff1a + {}", (Object)queryStateUrl, (Object)e);
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + queryStateUrl + "--------\u9519\u8bef\u4fe1\u606f\uff1a" + e);
        }
        String responseBody = (String)response.getBody();
        HcxQueryStateRspBO queryStateRspBO = (HcxQueryStateRspBO)JSONObject.parseObject((String)responseBody, HcxQueryStateRspBO.class);
        log.info("\u8c03\u7528\u6838\u8d22\u4fe1\u63a5\u53e3\u67e5\u72b6\u6001\uff0c \u54cd\u5e94\u62a5\u6587\u62a5\u6587\uff1a{}", (Object)responseBody);
        if (queryStateRspBO != null && queryStateRspBO.getCode() != null && !queryStateRspBO.getCode().equals(PayHcxRspConstants.SUCCESS.getCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38(\u67e5\u8be2\u767d\u6761\u72b6\u6001)");
            return rspBO;
        }
        AbstractHcxPayAble.sortQryStateRspBO(reqBo, rspBO, response);
        return rspBO;
    }

    public String validateArgStr(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)this.payPropertiesVo.getHcxTokenUrl())) {
            return "\u914d\u7f6e\u6587\u4ef6 \u3010hcx.token.url\u3011 \u672a\u914d\u7f6e";
        }
        if (StringUtils.isEmpty((Object)this.payPropertiesVo.getHcxTokenUrl())) {
            return "\u914d\u7f6e\u6587\u4ef6 \u3010hcx.client.id\u3011 \u672a\u914d\u7f6e";
        }
        if (StringUtils.isEmpty((Object)this.payPropertiesVo.getHcxClientSecret())) {
            return "\u914d\u7f6e\u6587\u4ef6 \u3010hcx.client.secret\u3011 \u672a\u914d\u7f6e";
        }
        return null;
    }

    public static void sortQryStateRspBO(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo rspBO, ResponseEntity<String> response) {
        String state;
        rspBO.setOrderId(reqBo.getOrderId());
        rspBO.setPayOrderId(reqBo.getPayOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        String responseBody = (String)response.getBody();
        HcxQueryStateRspBO queryStateRspBO = (HcxQueryStateRspBO)JSONObject.parseObject((String)responseBody, HcxQueryStateRspBO.class);
        assert (queryStateRspBO != null);
        HcxQueryStateRspBO.DataDTO.DataListDTO dataListDTO = queryStateRspBO.getData().getDataList().get(0);
        switch (state = dataListDTO.getCreditState()) {
            case "ISSUE": 
            case "ISSUING": {
                rspBO.setPayStatus("PAYING");
                break;
            }
            case "ISSUING_REFUSED": 
            case "ISSUING_CANCELED": 
            case "DISCARD": {
                rspBO.setPayStatus("FAIL");
                break;
            }
            case "ISSUED": 
            case "REDEEM": 
            case "REDEEMING": 
            case "REDEEMED": 
            case "RECOVER": 
            case "RECOVERED": {
                rspBO.setPayStatus("SUCCESS");
                break;
            }
            default: {
                rspBO.setRespDesc("\u5931\u8d25");
                rspBO.setRespCode("8888");
            }
        }
    }

    private String validateCallBackArgs(PayAbleCallBackReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

