/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProDealMemberAddReqBO;
import com.tydic.payment.pay.busi.bo.PayProDealMemberAddRspBO;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.DefaultIcbcClient;
import com.tydic.payment.pay.icbc.IcbcApiException;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCporderqueryRequestV2;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCporderqueryResponseV2;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCppayapplyRequestV2;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCppayapplyResponseV2;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayMemberapplyRequestV1;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayMemberapplyResponseV1;
import com.tydic.payment.pay.icbc.bo.MybankPayCpaymemberconfirmRequestV1;
import com.tydic.payment.pay.icbc.bo.MybankPayCpaymemberconfirmRequestV1Biz;
import com.tydic.payment.pay.icbc.bo.MybankPayCpaymemberconfirmResponseV1;
import com.tydic.payment.pay.icbc.intf.BizContent;
import com.tydic.payment.pay.icbc.intf.IcbcRequest;
import com.tydic.payment.pay.icbc.util.IcbcSignature;
import com.tydic.payment.pay.icbc.util.WebUtils;
import com.tydic.payment.pay.payable.api.PayAble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public abstract class AbstractIcbcPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractIcbcPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayProGetParamsBusiService payProGetParamsBusiService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    private static final String SLASH = "/";
    protected static String ICBC_APP_ID;
    protected static String ICBC_AGREEMENT_CODE;
    protected static String ICBC_PRIVATE_KEY;
    protected static String ICBC_PUBLIC_KEY;
    @Value(value="${icbc.refund.approve.mark:1}")
    private String approveMark;
    @Value(value="${icbc.test.time:20201201}")
    protected String icbcTestTime;
    @Value(value="${icbc.is.test:0}")
    protected String icbcTest;
    protected static final String IS_TEST = "1";
    @Value(value="${icbc.epay.member.apply.url:123}")
    private String memberApplyUrl;
    @Value(value="${icbc.epay.member.confirm.url:123}")
    private String memberConfirmUrl;
    @Value(value="${icbc.epay.member.confirm.redirect:123}")
    private String redirectUrl;
    @Value(value="${icbc.epay.icp.code:123}")
    private String icpCode;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        MybankPayCpayCppayapplyResponseV2 response;
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateStr = this.validateRefundArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String icbcNotifyUrl = this.payPropertiesVo.getValueByKey("icbc.epay.refund.notify.url");
        if (StringUtils.isEmpty((Object)icbcNotifyUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.refund.notify.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.refund.notify.url");
            return retBo;
        }
        String icbcRefundUrl = this.payPropertiesVo.getValueByKey("icbc.epay.url");
        if (StringUtils.isEmpty((Object)icbcRefundUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String accountNo = (String)paraMap.get("accountNo");
        String accountName = (String)paraMap.get("accountName");
        Map payTransMap = reqBo.getPayTransParam();
        String payerAccNo = (String)payTransMap.get("payerAccNo");
        String payerAccName = (String)payTransMap.get("payerAccName");
        String payOrderId = reqBo.getPayOrderId();
        ArrayList<MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo> recvMallInfoList = new ArrayList<MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo>();
        MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo recvMallInfo = new MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo();
        recvMallInfo.setMallCode(payerAccNo);
        recvMallInfo.setMallName(payerAccName);
        recvMallInfo.setPayeeCompanyName(payerAccName);
        recvMallInfo.setPayeeSysflag(IS_TEST);
        recvMallInfo.setPayeeAccno(payerAccNo);
        recvMallInfo.setPayAmount(reqBo.getRefundFee().toString());
        recvMallInfoList.add(recvMallInfo);
        ArrayList<MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo> goodsInfoList = new ArrayList<MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo>();
        MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo goodsInfo = new MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo();
        String subId = String.valueOf(PayProSequence.nextId());
        goodsInfo.setGoodsSubId(subId.substring(subId.length() - 5));
        goodsInfo.setGoodsName("\u9000\u6b3e");
        goodsInfo.setPayeeCompanyName(payerAccName);
        goodsInfo.setGoodsNumber(IS_TEST);
        goodsInfo.setGoodsUnit("\u5355");
        goodsInfo.setGoodsAmt(reqBo.getRefundFee().toString());
        goodsInfoList.add(goodsInfo);
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        MybankPayCpayCppayapplyRequestV2 request = new MybankPayCpayCppayapplyRequestV2();
        request.setServiceUrl(icbcRefundUrl);
        MybankPayCpayCppayapplyRequestV2.MybankPayCpayCppayapplyRequestV2Biz bizContent = new MybankPayCpayCppayapplyRequestV2.MybankPayCpayCppayapplyRequestV2Biz();
        bizContent.setAgreeCode(ICBC_AGREEMENT_CODE);
        bizContent.setPartnerSeq(reqBo.getRefundOrderId());
        bizContent.setPartnerSeqOrigin(reqBo.getPayOrderId());
        bizContent.setPayChannel(IS_TEST);
        bizContent.setInternationalFlag(IS_TEST);
        bizContent.setPayMode(IS_TEST);
        bizContent.setPayEntitys(IS_TEST);
        bizContent.setAsynFlag("0");
        bizContent.setPayMemno(payOrderId.substring(payOrderId.length() - 15));
        bizContent.setOrderCode(reqBo.getPayOrderId());
        bizContent.setOrderAmount(reqBo.getRefundFee().toString());
        bizContent.setOrderCurr("001");
        bizContent.setSumPayamt(reqBo.getRefundFee().toString());
        bizContent.setIdentityMode(this.approveMark);
        bizContent.setReturnUrl(reqBo.getRefundExtendValue1());
        DateTime nowTime = new DateTime((Object)this.payMethodMapper.getDBDate().getDate());
        bizContent.setSubmitTime(nowTime.toString("yyyyMMddHHmmss"));
        if (IS_TEST.equals(this.icbcTest)) {
            bizContent.setSubmitTime(this.icbcTestTime + nowTime.toString("HHmmss"));
        }
        bizContent.setCallbackUrl(icbcNotifyUrl);
        bizContent.setPayeeList(recvMallInfoList);
        bizContent.setGoodsList(goodsInfoList);
        bizContent.setPayerAccno(accountNo);
        bizContent.setPayerAccname(accountName);
        request.setBizContent((BizContent)bizContent);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u7684request\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        }
        String msgId = String.valueOf(PayProSequence.nextId());
        try {
            response = (MybankPayCpayCppayapplyResponseV2)client.execute((IcbcRequest)request, msgId);
        }
        catch (IcbcApiException e) {
            log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getErrMsg());
            return retBo;
        }
        log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u5f97\u5230\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess()) {
            log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u63a5\u53e3\u4e0b\u5355\u5931\u8d25\uff1a{}", (Object)response.getReturnMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u63a5\u53e3\u4e0b\u5355\u5931\u8d25\uff1a" + response.getReturnMsg());
            return retBo;
        }
        if (!StringUtils.isEmpty((Object)response.getRedirectParam())) {
            retBo.setWebUrl(response.getRedirectParam());
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        String tradeStatus;
        if (log.isDebugEnabled()) {
            log.debug("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\u89e3\u6790\u5f02\u6b65\u901a\u77e5\u53c2\u6570\u5f00\u59cb\uff1a{}", (Object)reqBo);
        }
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            log.error(validateConfig);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateConfig);
            return retBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        log.debug("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u56de\u8c03\u62a5\u6587\u4e3a\uff1a{}", (Object)reqBo.getReqData());
        JSONObject notifyJson = JSON.parseObject((String)reqBo.getReqData());
        JSONObject bizContent = notifyJson.getJSONObject("biz_content");
        String payOrderId = bizContent.getString("partnerSeq");
        String dealResult = this.verify(notifyJson, payOrderId, reqBo.isRefund());
        if (StringUtils.isEmpty((Object)dealResult)) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7");
            return retBo;
        }
        log.debug("==============\u7b7e\u540d\u9a8c\u8bc1\u6210\u529f==============");
        retBo.setPayOrderId(payOrderId);
        retBo.setDealResult(dealResult);
        if (null == bizContent.getString("payStatus")) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5de5\u884c\u6ca1\u6709\u8fd4\u56de\u652f\u4ed8\u72b6\u6001");
            return retBo;
        }
        String timeStamp = notifyJson.getString("timestamp");
        DateTime date = DateTime.parse((String)timeStamp, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        String tradeTime = date.toString("yyyyMMddHHmmss");
        switch (tradeStatus = bizContent.getString("payStatus")) {
            case "1": 
            case "4": 
            case "3": {
                retBo.setTradeTime(tradeTime);
                retBo.setPayNotifyTransId(payOrderId);
                retBo.setStatus("SUCCESS");
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u6210\u529f(icbcEpay)");
                break;
            }
            case "0": {
                retBo.setStatus("PAYING");
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u5f85\u63d0\u4ea4(icbcEpay)");
                break;
            }
            case "2": {
                retBo.setStatus("FAIL");
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u5931\u8d25(icbcEpay)");
                break;
            }
            default: {
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u5de5\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setStatus("FAIL");
            }
        }
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        MybankPayCpayCporderqueryResponseV2 response;
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateStr = this.validateQryArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String icbcQuryUrl = this.payPropertiesVo.getValueByKey("icbc.epay.query.url");
        if (StringUtils.isEmpty((Object)icbcQuryUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.query.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.query.url");
            return retBo;
        }
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        MybankPayCpayCporderqueryRequestV2 request = new MybankPayCpayCporderqueryRequestV2();
        request.setServiceUrl(icbcQuryUrl);
        MybankPayCpayCporderqueryRequestV2.QueryPayApplyRequestV2Biz bizContent = new MybankPayCpayCporderqueryRequestV2.QueryPayApplyRequestV2Biz();
        Random rand = new Random();
        String msgId = rand.nextInt(99999) + "msg";
        bizContent.setAgreeCode(ICBC_AGREEMENT_CODE);
        bizContent.setOrderCode(reqBo.getPayOrderId());
        bizContent.setPartnerSeq(reqBo.getPayOrderId());
        request.setBizContent((BizContent)bizContent);
        log.debug("\u8c03\u7528\u5de5\u884c\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        try {
            response = (MybankPayCpayCporderqueryResponseV2)client.execute((IcbcRequest)request, msgId);
        }
        catch (IcbcApiException e) {
            log.error("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getErrMsg());
            throw new BusinessException("216039", e.getErrMsg());
        }
        log.debug("\u8c03\u7528\u5de5\u884c\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess()) {
            log.error("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)response.getReturnMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + response.getReturnMsg());
            return retBo;
        }
        this.sortRetBo(reqBo, retBo, response);
        return retBo;
    }

    public PayAbleQryRefundStatusRspBo qryRefundStatus(PayAbleQryRefundStatusReqBo reqBo) {
        MybankPayCpayCporderqueryResponseV2 response;
        PayAbleQryRefundStatusRspBo retBo = new PayAbleQryRefundStatusRspBo();
        String validateStr = this.validateRefundQryArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String icbcQuryUrl = this.payPropertiesVo.getValueByKey("icbc.epay.query.url");
        if (StringUtils.isEmpty((Object)icbcQuryUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.query.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.query.url");
            return retBo;
        }
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        MybankPayCpayCporderqueryRequestV2 request = new MybankPayCpayCporderqueryRequestV2();
        request.setServiceUrl(icbcQuryUrl);
        MybankPayCpayCporderqueryRequestV2.QueryPayApplyRequestV2Biz bizContent = new MybankPayCpayCporderqueryRequestV2.QueryPayApplyRequestV2Biz();
        Random rand = new Random();
        String msgId = rand.nextInt(99999) + "msg";
        bizContent.setAgreeCode(ICBC_AGREEMENT_CODE);
        bizContent.setOrderCode(reqBo.getPayOrderId());
        bizContent.setPartnerSeq(reqBo.getRefundOrderId());
        request.setBizContent((BizContent)bizContent);
        log.debug("\u8c03\u7528\u5de5\u884c\u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        try {
            response = (MybankPayCpayCporderqueryResponseV2)client.execute((IcbcRequest)request, msgId);
        }
        catch (IcbcApiException e) {
            log.error("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getErrMsg());
            throw new BusinessException("216039", e.getErrMsg());
        }
        log.debug("\u8c03\u7528\u5de5\u884c\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess()) {
            log.error("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)response.getReturnMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u5de5\u884c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + response.getReturnMsg());
            return retBo;
        }
        this.sortRefundRetBo(reqBo, retBo, response);
        return retBo;
    }

    private void sortRefundRetBo(PayAbleQryRefundStatusReqBo reqBo, PayAbleQryRefundStatusRspBo retBo, MybankPayCpayCporderqueryResponseV2 response) {
        String tradeStatus;
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setRefundOrderId(reqBo.getRefundOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (null == response.getPayStatus()) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5de5\u884c\u6ca1\u6709\u8fd4\u56de\u652f\u4ed8\u72b6\u6001");
            return;
        }
        String tradeTime = new DateTime((Object)reqBo.getCreateTime()).toString("yyyyMMddHHmmss");
        switch (tradeStatus = response.getPayStatus()) {
            case "1": 
            case "3": {
                retBo.setTradeTime(tradeTime);
                retBo.setPayNotifyTransId(response.getSerialNo());
                retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getOrderAmount()).longValue()));
                retBo.setRefundStatus("SUCCESS");
                retBo.setStatusDesc("\u9000\u6b3e\u6210\u529f(icbcEpay)");
                break;
            }
            case "4": {
                retBo.setRefundStatus("SUBMITTED");
                retBo.setStatusDesc("\u5df2\u63d0\u4ea4(icbcEpay)");
                break;
            }
            case "2": {
                retBo.setRefundStatus("FAIL");
                retBo.setStatusDesc("\u9000\u6b3e\u5931\u8d25(icbcEpay)");
                break;
            }
            default: {
                retBo.setRespCode("212008");
                retBo.setRespDesc("\u5de5\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setRefundStatus("FAIL");
            }
        }
    }

    private String validateRefundQryArgs(PayAbleQryRefundStatusReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            return validateConfig;
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payOrderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[refundOrderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    private String verify(JSONObject notifyJson, String payOrderId, boolean isRefund) {
        String icbcNotifyUrl;
        PayProGetParamsBusiReqBo payProGetParamsBusiReqBo = new PayProGetParamsBusiReqBo();
        payProGetParamsBusiReqBo.setPayOrderId(payOrderId);
        payProGetParamsBusiReqBo.setRefund(isRefund);
        Map paraMap = this.payProGetParamsBusiService.getParamMap(payProGetParamsBusiReqBo).getParamMap();
        if (isRefund) {
            icbcNotifyUrl = this.payPropertiesVo.getValueByKey("icbc.epay.refund.notify.url");
            if (StringUtils.isEmpty((Object)icbcNotifyUrl)) {
                log.error("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u9000\u6b3e\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.refund.notify.url");
                return null;
            }
        } else {
            icbcNotifyUrl = this.payPropertiesVo.getValueByKey("icbc.epay.notify.url");
            if (StringUtils.isEmpty((Object)icbcNotifyUrl)) {
                log.error("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.notify.url");
                return null;
            }
        }
        Matcher slashMatcher = Pattern.compile(SLASH).matcher(icbcNotifyUrl);
        int index = 0;
        while (slashMatcher.find() && ++index != 3) {
        }
        icbcNotifyUrl = icbcNotifyUrl.substring(slashMatcher.start());
        HashMap<String, String> params = new HashMap<String, String>(16);
        String from = notifyJson.getString("from");
        String api = notifyJson.getString("api");
        String app_id = notifyJson.getString("app_id");
        String charset = notifyJson.getString("charset");
        String format = notifyJson.getString("format");
        String timestamp = notifyJson.getString("timestamp");
        String biz_content = notifyJson.getString("biz_content");
        String sign_type = notifyJson.getString("sign_type");
        String sign = notifyJson.getString("sign");
        params.put("from", from);
        params.put("api", api);
        params.put("app_id", app_id);
        params.put("charset", charset);
        params.put("format", format);
        params.put("encrypt_type", "");
        params.put("timestamp", timestamp);
        params.put("biz_content", biz_content);
        params.put("sign_type", sign_type);
        String signStr = WebUtils.buildOrderedSignStr((String)icbcNotifyUrl, params);
        boolean passed = false;
        try {
            passed = IcbcSignature.verify((String)signStr, (String)sign_type, (String)ICBC_PUBLIC_KEY, (String)charset, (String)sign);
        }
        catch (IcbcApiException e) {
            log.error("\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getErrMsg());
        }
        if (!passed) {
            log.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            return null;
        }
        JSONObject contentJson = JSON.parseObject((String)biz_content);
        String msg_id = contentJson.getString("msg_id");
        String return_code = "0";
        String return_msg = "success";
        String responseBizContent = "{\"return_code\":" + return_code + ",\"return_msg\":\"" + return_msg + "\",\"msg_id\":\"" + msg_id + "\",\"busi_param_rp\":\"thisisresponseparameter\"}";
        signStr = "\"response_biz_content\":" + responseBizContent + ",\"sign_type\":\"RSA2\"";
        try {
            sign = IcbcSignature.sign((String)signStr, (String)"RSA2", (String)ICBC_PRIVATE_KEY, (String)charset);
        }
        catch (IcbcApiException e) {
            log.error("\u7ec4\u88c5\u8fd4\u56de\u7ed9\u5de5\u884c\u7684\u7ed3\u679c\u5b57\u7b26\u4e32\u7b7e\u540d\u65f6\u5f02\u5e38\uff1a" + (Object)((Object)e));
        }
        String dealResult = "{" + signStr + ",\"sign\":\"" + sign + "\"}";
        return dealResult;
    }

    private void sortRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, MybankPayCpayCporderqueryResponseV2 response) {
        String tradeStatus;
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (null == response.getPayStatus()) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5de5\u884c\u6ca1\u6709\u8fd4\u56de\u652f\u4ed8\u72b6\u6001");
            return;
        }
        String tradeTime = new DateTime((Object)reqBo.getCreateTime()).toString("yyyyMMddHHmmss");
        switch (tradeStatus = response.getPayStatus()) {
            case "1": 
            case "4": {
                retBo.setTradeTime(tradeTime);
                retBo.setPayNotifyTransId(response.getSerialNo());
                retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getOrderAmount()).longValue()));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(icbcEpay)");
                break;
            }
            case "3": {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u5904\u7406\u4e2d(icbcEpay)");
                break;
            }
            case "2": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5931\u8d25(icbcEpay)");
                break;
            }
            default: {
                retBo.setRespCode("212008");
                retBo.setRespDesc("\u5de5\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setPayStatus("FAIL");
            }
        }
    }

    private String validateQryArgs(PayAbleQryPayStatusReqBo reqBo) {
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            return validateConfig;
        }
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payOrderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    protected String validateParaMap(Map<String, String> paraMap) {
        if (null == paraMap) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paraMap]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("accountNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paraMap]\u4e2d\u7684[accountNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("accountName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paraMap]\u4e2d\u7684[accountName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateRefundArgs(PayAbleRefundReqBo reqBo) {
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            return validateConfig;
        }
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayTransParam())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payTransParam'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map payTransParam = reqBo.getPayTransParam();
        if (StringUtils.isEmpty(payTransParam.get("payerAccName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[payerAccName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("payerAccNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[payerAccNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    protected String init() {
        ICBC_APP_ID = this.payPropertiesVo.getValueByKey("icbc.epay.app.id");
        if (StringUtils.isEmpty((Object)ICBC_APP_ID)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884cAPP_ID\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.app.id");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884cAPP_ID\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.app.id";
        }
        ICBC_AGREEMENT_CODE = this.payPropertiesVo.getValueByKey("icbc.epay.agreement.code");
        if (StringUtils.isEmpty((Object)ICBC_AGREEMENT_CODE)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u534f\u8bae\u7f16\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.agreement.code");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u534f\u8bae\u7f16\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.agreement.code";
        }
        ICBC_PRIVATE_KEY = this.payPropertiesVo.getValueByKey("icbc.epay.private.key");
        if (StringUtils.isEmpty((Object)ICBC_PRIVATE_KEY)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.private.key");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u5546\u6237\u79c1\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.private.key";
        }
        ICBC_PUBLIC_KEY = this.payPropertiesVo.getValueByKey("icbc.epay.public.key");
        if (StringUtils.isEmpty((Object)ICBC_PUBLIC_KEY)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.public.key");
            return "\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.public.key";
        }
        return null;
    }

    public PayProDealMemberAddRspBO dealMember(PayProDealMemberAddReqBO reqBO) {
        PayProDealMemberAddRspBO rspBO = new PayProDealMemberAddRspBO();
        PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaBo.setPayMethod(Long.valueOf(190L));
        qryPayParaBo.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
        Map paraMap = payProQueryPayParaBusiRspBo.getDetailAttrs();
        String unifyId = (String)paraMap.get("unifyId");
        String legalPersion = (String)paraMap.get("legalPersion");
        String legalPersonID = (String)paraMap.get("legalPersonID");
        String dealName = (String)paraMap.get("dealName");
        String dealTelephone = (String)paraMap.get("dealTelephone");
        String accBankFlag = (String)paraMap.get("accBankFlag");
        String accountNo = (String)paraMap.get("accountNo");
        String accountName = (String)paraMap.get("accountName");
        String bankNo = (String)paraMap.get("bankNo");
        String icbcBankName = (String)paraMap.get("icbcBankName");
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            log.error(validateConfig);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validateConfig);
            return rspBO;
        }
        log.info("#######################\u4f1a\u5458\u6863\u6848\u5f55\u5165\u5f00\u59cb########################################");
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        MybankPayCpayMemberapplyRequestV1 req = new MybankPayCpayMemberapplyRequestV1();
        req.setServiceUrl(this.memberApplyUrl);
        MybankPayCpayMemberapplyRequestV1.MybankPayCpayMemberapplyRequestV1Biz biz = new MybankPayCpayMemberapplyRequestV1.MybankPayCpayMemberapplyRequestV1Biz();
        biz.setAgreeCode(ICBC_AGREEMENT_CODE);
        String merchantNoStr = reqBO.getMerchantId().toString();
        String memberNo = merchantNoStr.length() > 15 ? merchantNoStr.substring(0, 15) : merchantNoStr;
        biz.setMemberNo(memberNo);
        biz.setMemberName(memberNo);
        biz.setMemberType("01");
        biz.setMemberRole("2");
        biz.setCertificateType("107");
        biz.setCertificateId(unifyId);
        biz.setCorpRepreName(legalPersion);
        biz.setCorpRepreIdType("0");
        biz.setCorpRepreId(legalPersonID);
        biz.setDealName(dealName);
        biz.setDealTelphoneNo(dealTelephone);
        biz.setIcpCode(this.icpCode);
        biz.setEnterAmtType("0");
        biz.setAccBankFlag(accBankFlag);
        biz.setAccno(accountNo);
        biz.setAccName(accountName);
        biz.setAccBankNo(bankNo);
        biz.setAccBankName(icbcBankName);
        biz.setOperType(reqBO.getOperType().toString());
        ArrayList<MybankPayCpayMemberapplyRequestV1.BeanBillAccInfo> billAccInfoList = new ArrayList<MybankPayCpayMemberapplyRequestV1.BeanBillAccInfo>();
        MybankPayCpayMemberapplyRequestV1.BeanBillAccInfo billAccInfo = new MybankPayCpayMemberapplyRequestV1.BeanBillAccInfo();
        billAccInfo.setBillAccBankFlag(accBankFlag);
        billAccInfo.setBillBankNo(bankNo);
        billAccInfoList.add(billAccInfo);
        biz.setBillAccInfo(billAccInfoList);
        req.setBizContent((BizContent)biz);
        MybankPayCpayMemberapplyResponseV1 response = new MybankPayCpayMemberapplyResponseV1();
        String msgId = PayProSequence.nextId() + "msg";
        log.info(msgId);
        try {
            log.info("\u5de5\u884c\u5165\u6863\u7533\u8bf7\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)req));
            response = (MybankPayCpayMemberapplyResponseV1)client.execute((IcbcRequest)req, msgId);
            log.info("\u5de5\u884c\u5165\u6863\u7533\u8bf7\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                log.info("success");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(response.getReturnMsg());
                return rspBO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("#######################\u4f1a\u5458\u6863\u6848\u5f55\u5165\u7ed3\u675f########################################");
        log.info("#######################\u4f1a\u5458\u8ba4\u8bc1\u5f00\u59cb###########################");
        MybankPayCpaymemberconfirmRequestV1 confirmReq = new MybankPayCpaymemberconfirmRequestV1();
        confirmReq.setServiceUrl(this.memberConfirmUrl);
        MybankPayCpaymemberconfirmRequestV1Biz confirmBiz = new MybankPayCpaymemberconfirmRequestV1Biz();
        confirmBiz.setAgreeCode(ICBC_AGREEMENT_CODE);
        confirmBiz.setMemberNo(memberNo);
        confirmBiz.setReturnUrl(this.redirectUrl);
        confirmReq.setBizContent((BizContent)confirmBiz);
        MybankPayCpaymemberconfirmResponseV1 confirmResponse = new MybankPayCpaymemberconfirmResponseV1();
        String confirmMsgId = PayProSequence.nextId() + "msg";
        try {
            log.info("\u5de5\u884c\u4f1a\u5458\u8ba4\u8bc1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)confirmReq));
            confirmResponse = (MybankPayCpaymemberconfirmResponseV1)client.execute((IcbcRequest)confirmReq, confirmMsgId);
            log.info("\u5de5\u884c\u4f1a\u5458\u8ba4\u8bc1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)confirmResponse));
            if (!confirmResponse.isSuccess()) {
                rspBO.setRespCode("\u5931\u8d25");
                rspBO.setRespDesc(confirmResponse.getReturnMsg());
                return rspBO;
            }
        }
        catch (IcbcApiException e) {
            e.printStackTrace();
        }
        log.info("#######################\u4f1a\u5458\u8ba4\u8bc1\u7ed3\u675f###########################");
        rspBO.setConfirmUrl(confirmResponse.getRedirectParam());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

