/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.PayProOrderQueryMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.hcx.PayHcxRspConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractHcxPayAble;
import com.tydic.payment.pay.payable.impl.transbo.HcxDealPayRspBO;
import com.tydic.payment.pay.util.PayHcxUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="hcxPayAbleImpl")
public class HcxPayAbleImpl
extends AbstractHcxPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(HcxPayAbleImpl.class);
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;
    @Autowired
    private PayHcxUtil hcxUtil;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayProOrderQueryMapper payProOrderQueryMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.HCX_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        ResponseEntity<String> response;
        log.info("\u8fdb\u5165\u6838\u8d22\u4fe1\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b dealPay\u65b9\u6cd5 --> \u5165\u53c2\uff1a{}", JSONObject.toJSON((Object)reqBo));
        PayAbleDealPayRspBo rspBO = new PayAbleDealPayRspBo();
        rspBO.setRespCode("8888");
        String validateArgs = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgs)) {
            log.info("\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgs);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validateArgs);
            return rspBO;
        }
        String creditIssueUrl = this.payPropertiesVo.getHcxCreditIssueUrl();
        if (StringUtils.isEmpty((Object)creditIssueUrl)) {
            log.error("\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.credit.issue.url)\u672a\u914d\u7f6e");
            throw new BusinessException("218024", "\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.credit.issue.url)\u672a\u914d\u7f6e");
        }
        PRelOrderParamPO pRelOrderParamPO = new PRelOrderParamPO();
        pRelOrderParamPO.setOrderId(reqBo.getOrderId());
        pRelOrderParamPO.setStatus(1);
        List<PRelOrderParamPO> pRelOrderParamPOList = this.pRelOrderParamMapper.getList(pRelOrderParamPO);
        List pkCreditIssueList = pRelOrderParamPOList.stream().filter(bo -> bo.getParamKey().equals("pkCreditIssue")).collect(Collectors.toList());
        if (pkCreditIssueList.size() > 0) {
            rspBO.setRespDesc("\u8be5\u8ba2\u5355\u65e0\u6cd5\u7533\u8bf7\uff0c\u8bf7\u52ff\u91cd\u590d");
            return rspBO;
        }
        Long orderId = reqBo.getOrderId();
        Map payTransParam = reqBo.getPayTransParam();
        String partnerId = this.payPropertiesVo.getHcxPartnerId();
        String partnerName = this.payPropertiesVo.getHcxPartnerName();
        String corpNameSource = payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_SOURCE.getValue()).toString();
        String corpIdTypeSource = payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_SOURCE.getValue()).toString();
        String corpIdCodeSource = payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_CODE_SOURCE.getValue()).toString();
        String maturiDate = payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_MATURITY_DATE.getValue()).toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        Date date = null;
        try {
            date = simpleDateFormat.parse(maturiDate);
        }
        catch (ParseException e) {
            log.info("\u627f\u8bfa\u4ed8\u6b3e\u65f6\u95f4 String -> Date \u9519\u8bef");
            throw new BusinessException("RSP_CODE_PARA_NOT_MATCH", "\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c maturityDate\u683c\u5f0f\u4e0d\u5339\u914d");
        }
        List corpNameCoreList = pRelOrderParamPOList.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_CORE.getValue())).collect(Collectors.toList());
        List corpIdTypeCoreList = pRelOrderParamPOList.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_CORE.getValue())).collect(Collectors.toList());
        List corpIdCodeCoreList = pRelOrderParamPOList.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_CODE_CORE.getValue())).collect(Collectors.toList());
        if (corpNameCoreList.size() < 1 || corpIdTypeCoreList.size() < 1 || corpIdCodeCoreList.size() < 1) {
            rspBO.setRespDesc("\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u652f\u4ed8");
            return rspBO;
        }
        String corpNameCore = ((PRelOrderParamPO)corpNameCoreList.get(0)).getParamValue();
        String corpIdTypeCore = ((PRelOrderParamPO)corpIdTypeCoreList.get(0)).getParamValue();
        String corpIdCodeCore = ((PRelOrderParamPO)corpIdCodeCoreList.get(0)).getParamValue();
        Map paraMap = reqBo.getParaMap();
        String corpNameAccept = (String)paraMap.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_ACCEPT.getValue());
        String corpIdTypeAccept = (String)paraMap.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_ACCEPT.getValue());
        String corpIdCodeAccept = (String)paraMap.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_Code_ACCEPT.getValue());
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        double fee = Double.parseDouble(reqBo.getPayFee().toString());
        String maturityAmount = decimalFormat.format(fee / 100.0);
        Long serial = PayProSequence.nextId();
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serial", serial.toString());
        reqMap.put("partnerId", partnerId);
        reqMap.put("partnerName", partnerName);
        reqMap.put("partnerBusiId", reqBo.getPayOrderId());
        reqMap.put("corpNameCore", corpNameCore);
        reqMap.put("corpIdTypeCore", corpIdTypeCore);
        reqMap.put("corpIdCodeCore", corpIdCodeCore);
        reqMap.put("corpNameAccept", corpNameAccept);
        reqMap.put("corpIdTypeAccept", corpIdTypeAccept);
        reqMap.put("corpIdCodeAccept", corpIdCodeAccept);
        reqMap.put("corpNameSource", corpNameSource);
        reqMap.put("corpIdTypeSource", corpIdTypeSource);
        reqMap.put("corpIdCodeSource", corpIdCodeSource);
        reqMap.put("maturityAmount", maturityAmount);
        reqMap.put("maturityDate", maturiDate);
        String body = JSONObject.toJSONString(reqMap);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        Integer random = PayHcxUtil.getRandom();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        if (StringUtils.isEmpty((Object)tokenUrl)) {
            log.error("\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.token.url)\u672a\u914d\u7f6e");
            throw new BusinessException("218024", "\u6838\u8d22\u4fe1\u8bf7\u6c42\u5730\u5740(hcx.token.url)\u672a\u914d\u7f6e");
        }
        String clientId = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String token = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        String signUrl = creditIssueUrl.substring(creditIssueUrl.lastIndexOf("partner") + 7);
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        headersMap.put("X-SCF-TV", timeStamp.toString());
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-NONCE", random.toString());
        try {
            response = this.hcxUtil.doPost(creditIssueUrl, body, MediaType.APPLICATION_JSON, headersMap);
        }
        catch (Exception e) {
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + creditIssueUrl + e);
        }
        String responseBody = (String)response.getBody();
        log.info("\u6838\u8d22\u4fe1\u5f00\u7acb\u767d\u6761\uff0c \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)body));
        log.info("\u6838\u8d22\u4fe1\u5f00\u7acb\u767d\u6761\uff0c\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBody);
        HcxDealPayRspBO dealPayRspBO = (HcxDealPayRspBO)JSONObject.parseObject((String)responseBody, HcxDealPayRspBO.class);
        if (dealPayRspBO == null || StringUtils.isEmpty((Object)dealPayRspBO.getCode())) {
            log.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return rspBO;
        }
        if (!dealPayRspBO.getCode().equals(PayHcxRspConstants.SUCCESS.getCode())) {
            log.error("\u6838\u8d22\u65b0\u7533\u8bf7\u5f00\u7acb\u767d\u6761\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6838\u8d22\u65b0\u7533\u8bf7\u5f00\u7acb\u767d\u6761\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBO);
        if (!dealPayRspBO.getData().getCode().equals(PayHcxRspConstants.SUCCESS.getCode()) || StringUtils.isEmpty((Object)dealPayRspBO.getData().getPkCreditIssue())) {
            log.info(dealPayRspBO.getData().getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(dealPayRspBO.getData().getMessage());
            return rspBO;
        }
        String pkCreditIssue = dealPayRspBO.getData().getPkCreditIssue().toString();
        rspBO.setPkCreditIssue(pkCreditIssue);
        PRelOrderParamPO insertPO = new PRelOrderParamPO();
        insertPO.setParamId(PayProSequence.nextId());
        insertPO.setPayOrderId(reqBo.getPayOrderId());
        insertPO.setOrderId(reqBo.getOrderId());
        insertPO.setParamKey("pkCreditIssue");
        insertPO.setParamValue(pkCreditIssue);
        insertPO.setStatus(1);
        int insert = this.pRelOrderParamMapper.insert(insertPO);
        if (insert < 1) {
            log.info("\u5c06\u7533\u8bf7\u7684\u767d\u6761\u7f16\u53f7\u5b58\u5165p_rel_order_param\u8868\u5931\u8d25");
            throw new BusinessException("218024", "\u5c06\u7533\u8bf7\u7684\u767d\u6761\u7f16\u53f7\u5b58\u5165p_rel_order_param\u8868\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee().toString())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayTransParam())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payTransParam'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map payTransParam = reqBo.getPayTransParam();
        if (StringUtils.isEmpty(payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_SOURCE.getValue()))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[corpNameSource]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_SOURCE.getValue()))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[corpIdTypeSource]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_CODE_SOURCE.getValue()))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[corpIdCodeSource]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_ACCEPT.getValue()))) {
            return "\u5546\u6237\u3010" + reqBo.getMerchantId() + "\u3011\u672a\u914d\u7f6e\u6838\u8d22\u4fe1\u652f\u4ed8\u4fe1\u606f\uff1acorpNameAccept";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_ACCEPT.getValue()))) {
            return "\u5546\u6237\u3010" + reqBo.getMerchantId() + "\u3011\u672a\u914d\u7f6e\u6838\u8d22\u4fe1\u652f\u4ed8\u4fe1\u606f\uff1acorpIdTypeAccept";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_Code_ACCEPT.getValue()))) {
            return "\u5546\u6237\u3010" + reqBo.getMerchantId() + "\u3011\u672a\u914d\u7f6e\u6838\u8d22\u4fe1\u652f\u4ed8\u4fe1\u606f\uff1acorpIdCodeAccept";
        }
        if (StringUtils.isEmpty(reqBo.getPayTransParam().get(PayProConstants.HcxPayParamConstants.PARAM_MATURITY_DATE.getValue()))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027maturityDate\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

