/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import com.jcraft.jsch.ChannelSftp;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.PayFtpUtil;
import com.tydic.payment.pay.util.PayProBillUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PayBillAbleChinaUnipayImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleChinaUnipayImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Value(value="${bill.unipay.host:39.105.201.15}")
    private String unipayHost;
    @Value(value="${bill.unipay.port:22}")
    private int unipayPort;
    @Value(value="${bill.unipay.user:admin}")
    private String unipayUser;
    @Value(value="${bill.unipay.password:3edcMJU&}")
    private String unipayPwd;
    @Value(value="${bill.unipay.targetPrefix:/home/admin/bill-test}")
    private String targetPrefix;
    private static final String FILE_SUFFIX = ".zip";
    private static final String TRAN_TYPE_REFUND = "0401";
    private static final String BACKSLASH = "/";

    public Long paymentIns() {
        return BillConstant.PaymentIns.CHINA_UNION_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        FileOutputStream outputStream;
        PayBillAbleDownloadRspBo retBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        Long billDate = reqBo.getBillDate();
        Map paraMap = reqBo.getParaMap();
        String merId = (String)paraMap.get("MerId");
        ChannelSftp channelSftp = PayFtpUtil.openSftpChannel(this.unipayHost, this.unipayPort, this.unipayUser, this.unipayPwd);
        log.info("========sftp\u901a\u9053\u83b7\u53d6\u6210\u529f========");
        String sftpPrefix = this.targetPrefix + BACKSLASH + merId + BACKSLASH + billDate;
        log.info("========\u672c\u6b21\u7684\u76ee\u6807\u8def\u5f84\u4e3a\uff1a{}", (Object)sftpPrefix);
        List<String> list = PayFtpUtil.lsDir(channelSftp, sftpPrefix);
        log.info("========\u4ece\u94f6\u8054sftp\u83b7\u53d6\u5230\u7684\u6587\u4ef6\u96c6\u5408\u4e3a\uff1a{}", list);
        String fillNamePrefixDateStr = String.valueOf(billDate + 1L);
        String fileNamePrefix = merId + "_" + billDate + "_" + fillNamePrefixDateStr;
        log.info("========\u672c\u6b21\u7684\u76ee\u6807\u5bf9\u8d26\u6587\u4ef6\u524d\u7f00\u4e3a\uff1a{}", (Object)fileNamePrefix);
        List collect = list.stream().filter(str -> str.startsWith(fileNamePrefix) && str.endsWith(FILE_SUFFIX)).collect(Collectors.toList());
        if (CollUtil.isEmpty(collect)) {
            throw new BillDownAndTransException("\u672a\u7b5b\u9009\u5230\u7b26\u5408\u8981\u6c42\u7684\u5bf9\u8d26\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u94f6\u884c\u8be5\u65e5(" + billDate + ")\u8d26\u5355\u662f\u5426\u751f\u6210\u5b8c\u6210");
        }
        String fileName = (String)collect.get(0);
        String targetPath = sftpPrefix + BACKSLASH + fileName;
        String localPath = PayProBillUtil.getBillFileSavePath("unionPay", String.valueOf(billDate), merId, FILE_SUFFIX);
        List dataList = retBo.getRspDataBos();
        channelSftp = PayFtpUtil.openSftpChannel(this.unipayHost, this.unipayPort, this.unipayUser, this.unipayPwd);
        try {
            outputStream = new FileOutputStream(localPath);
        }
        catch (FileNotFoundException e) {
            throw new BillDownAndTransException("\u94f6\u8054\u5bf9\u8d26\uff0c\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        PayFtpUtil.downloadToStream(channelSftp, targetPath, outputStream);
        log.info("========\u5bf9\u8d26\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6587\u4ef6\u4fdd\u5b58\u5728\u76ee\u5f55\uff1a{}", (Object)localPath);
        ArrayList fileDataList = new ArrayList();
        try {
            ZipEntry entry;
            ZipFile zf = new ZipFile(localPath, CharsetUtil.CHARSET_UTF_8);
            ZipInputStream zin = new ZipInputStream((InputStream)new FileInputStream(localPath), CharsetUtil.CHARSET_UTF_8);
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                if (!entry.getName().endsWith(".txt")) continue;
                IoUtil.readLines((InputStream)zf.getInputStream(entry), (Charset)CharsetUtil.CHARSET_UTF_8, fileDataList);
            }
            zin.closeEntry();
            zin.close();
            zf.close();
        }
        catch (Exception e) {
            throw new BillDownAndTransException("\u94f6\u8054\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(fileDataList)) {
            log.info("=======\u5546\u6237[{}]\u5728\u65e5\u671f[{}]\u7684\u5bf9\u8d26\u6587\u4ef6\u8bb0\u5f55\u6d41\u6c34\u4e3a\u7a7a", (Object)merId, (Object)billDate);
            return retBo;
        }
        for (int i = 0; i < fileDataList.size(); ++i) {
            if (i < 1) continue;
            if (i == fileDataList.size() - 1) break;
            String data = (String)fileDataList.get(i);
            String[] split = data.split(Pattern.quote("|"), -1);
            if (split.length != 23) {
                throw new BillDownAndTransException("\u94f6\u8054\u5bf9\u8d26\u6587\u4ef6\u6570\u636e\u6709\u8bef\uff0c\u7b2c" + i + "\u884c\u7684\u6570\u636e\u957f\u5ea6\u4e3a:" + split.length);
            }
            PayBillAbleDownloadRspDataBo dataBo = new PayBillAbleDownloadRspDataBo();
            dataList.add(dataBo);
            PayBillAbleChinaUnipayImpl.fillDataBo(data, dataBo);
            System.out.println(data);
        }
        log.info("========\u6587\u4ef6\u89e3\u6790\u5b8c\u6210========");
        return retBo;
    }

    private static void fillDataBo(String data, PayBillAbleDownloadRspDataBo dataBo) {
        String[] split = data.split(Pattern.quote("|"), -1);
        dataBo.setPaymentInsId(BillConstant.PaymentIns.CHINA_UNION_PAY.getPaymentInsId());
        String tranType = split[8];
        String orderType = "01";
        if (TRAN_TYPE_REFUND.equals(tranType)) {
            orderType = "02";
        }
        dataBo.setOrderType(orderType);
        String oriOrderNo = split[5];
        dataBo.setTypeOrderId(oriOrderNo);
        Long liqDate = Long.parseLong(split[4]);
        dataBo.setBillDate(Long.valueOf(liqDate - 1L));
        String acqSeqId = split[20];
        dataBo.setTypeTransId(acqSeqId);
        Long orderAmt = Long.parseLong(split[12]);
        dataBo.setRealFee(orderAmt);
        dataBo.setBillFlag("0");
        String merId = split[2];
        dataBo.setPaymentMchId(merId);
        dataBo.setPaymentInsObj((Object)data);
        String completeDateTime = split[10] + split[11];
        dataBo.setTradeTime(completeDateTime);
    }

    public static void main(String[] args) throws IOException {
        String appId = "000092009169004";
        String host = "39.105.201.15";
        int port = 22;
        String user = "admin";
        String password = "3edcMJU&";
        String targetPath = "/home/admin/bill-test/999999999999999_20200306_20200306090000.txt.zip";
        String localPath = PayProBillUtil.getBillFileSavePath("unionPay", String.valueOf(20201010), appId, ".txt.zip");
        ArrayList dataList = new ArrayList();
        ChannelSftp channelSftp = PayFtpUtil.openSftpChannel(host, port, user, password);
        PayFtpUtil.downloadToStream(channelSftp, targetPath, new FileOutputStream(localPath));
    }
}

