/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncIssItreasuryBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncQueryContentBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncQueryReqBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncRenContentBo;
import com.tydic.payment.pay.util.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class PayBillAbleCnncImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleCnncImpl.class);
    private static String CNNC_CAI_QI_TONG_SYSTEM_ID;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long paymentIns() {
        return BillConstant.PaymentIns.CNNC_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo retBo = new PayBillAbleDownloadRspBo();
        String validateStr = this.validateBillArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String cnncBillPath = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.url");
        log.debug("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)cnncBillPath);
        if (StringUtils.isEmpty((Object)cnncBillPath)) {
            log.error("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u5730\u5740'cnnc.caiqitong.query.bill.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u5730\u5740'cnnc.caiqitong.query.bill.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        String reqStr = this.assembleCnncBillData(reqBo);
        if (StringUtils.isEmpty((Object)reqStr)) {
            log.error("CNNC\u8d22\u4f01\u901a\u5bf9\u8d26\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u5bf9\u8d26\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            return retBo;
        }
        HashMap<String, String> reqMap = new HashMap<String, String>(1);
        reqMap.put("_USER_REQUEST_DATA", reqStr);
        String retBillStr = ((HttpRequest)HttpRequest.post((String)cnncBillPath).contentType("application/x-www-form-urlencoded;charset=GBK").charset("GBK")).form(reqMap).execute().body();
        log.debug("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retBillStr);
        CnncIssItreasuryBo cnncIssItreasury = null;
        try {
            cnncIssItreasury = (CnncIssItreasuryBo)XmlUtils.xmlToObj(retBillStr, CnncIssItreasuryBo.class, "GBK");
        }
        catch (Exception e) {
            log.error("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25");
            return retBo;
        }
        if (cnncIssItreasury == null) {
            log.error("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u5185\u90e8\u4ea4\u6613\u6d41\u6c34\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2\u4e3a\u7a7a");
            return retBo;
        }
        this.parseResultData(cnncIssItreasury, reqBo, retBo);
        return retBo;
    }

    private void parseResultData(CnncIssItreasuryBo cnncIssItreasury, PayBillAbleDownloadReqBo reqBo, PayBillAbleDownloadRspBo retBo) {
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        List<CnncRenContentBo> contentBos = cnncIssItreasury.getQueryRen().getRenContent();
        for (CnncRenContentBo content : contentBos) {
            PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
            String excuteDate = content.getExcuteDate().replaceAll("_", "");
            trans.setBillDate(Long.valueOf(Long.parseLong(excuteDate)));
            trans.setBillFlag("0");
            trans.setPaymentMchId(content.getAccountCode());
            trans.setTypeTransId(content.getTransNo());
            trans.setRealFee(Long.valueOf(Long.parseLong(content.getAmount())));
            trans.setPaymentInsId(BillConstant.PaymentIns.CNNC_PAY.getPaymentInsId());
            trans.setTradeTime(excuteDate);
            if ("3".equals(content.getTransStatus())) {
                trans.setTypeOrderId(content.getAccountCode());
                trans.setOrderType("01");
            }
            trans.setPaymentInsObj((Object)content);
            retBo.getRspDataBos().add(trans);
        }
    }

    private String assembleCnncBillData(PayBillAbleDownloadReqBo reqBo) {
        CnncIssItreasuryBo Iss_Itreasury = new CnncIssItreasuryBo();
        CnncQueryReqBo queryReqBo = new CnncQueryReqBo();
        Iss_Itreasury.setQueryReq(queryReqBo);
        queryReqBo.setOperationType("7");
        queryReqBo.setSystemId(CNNC_CAI_QI_TONG_SYSTEM_ID);
        ArrayList<CnncQueryContentBo> contentBos = new ArrayList<CnncQueryContentBo>();
        CnncQueryContentBo contentBo = new CnncQueryContentBo();
        contentBos.add(contentBo);
        queryReqBo.setQueryContent(contentBos);
        String accountCode = (String)reqBo.getParaMap().get("cnncPayeeAcctNo");
        contentBo.setAccountCode(accountCode);
        contentBo.setCurrencyType("1");
        String transActionType = accountCode.contains("-") ? "6" : "1";
        contentBo.setTransActionType(transActionType);
        StringBuffer billDate = new StringBuffer(reqBo.getBillDate().toString());
        billDate.insert(4, "-").insert(7, "-");
        contentBo.setDateStart(billDate.toString());
        contentBo.setDateEnd(billDate.toString());
        log.debug("\u7ec4\u88c5\u5b8c\u6210\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)Iss_Itreasury));
        String xmlStr = null;
        try {
            xmlStr = XmlUtils.objToXml(Iss_Itreasury, "GBK");
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return xmlStr;
    }

    private String validateBillArgs(PayBillAbleDownloadReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getBillDate() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'billDate'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        CNNC_CAI_QI_TONG_SYSTEM_ID = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.system.id");
        if (StringUtils.isEmpty((Object)CNNC_CAI_QI_TONG_SYSTEM_ID)) {
            log.error("*CNNC\u8d22\u4f01\u901a\u7cfb\u7edf\u6807\u8bc6\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"cnnc.caiqitong.system.id");
            return "CNNC\u8d22\u4f01\u901a\u7cfb\u7edf\u6807\u8bc6\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0cnnc.caiqitong.system.id";
        }
        return null;
    }
}

