/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.jptangchina.jxcel.JxcelParser;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.hcx.PayHcxRspConstants;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.payable.impl.transbo.HcxBillCheckRspBO;
import com.tydic.payment.pay.payable.impl.transbo.HcxBillContentInfoBO;
import com.tydic.payment.pay.payable.impl.transbo.HcxCorpInfo;
import com.tydic.payment.pay.util.PayHcxUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayBillAbleHcxImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleHcxImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayHcxUtil hcxUtil;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;

    public Long paymentIns() {
        return BillConstant.PaymentIns.HCX_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        ResponseEntity<byte[]> fileResponse;
        ResponseEntity<String> response;
        String billDate;
        PayBillAbleDownloadRspBo rspBO = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        String validateStr = this.validateBillArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validateStr);
            return rspBO;
        }
        Long serial = PayProSequence.nextId();
        String partnerId = this.payPropertiesVo.getHcxPartnerId();
        String partnerName = this.payPropertiesVo.getHcxPartnerName();
        String billType = "0";
        String maturityDateStart = billDate = new StringBuilder(reqBo.getBillDate().toString()).insert(4, "-").insert(7, "-").toString();
        String maturityDateEnd = billDate;
        String productType = "0";
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serial", serial.toString());
        reqMap.put("partnerId", partnerId);
        reqMap.put("partnerName", partnerName);
        reqMap.put("billType", billType);
        reqMap.put("maturityDateStart", maturityDateStart);
        reqMap.put("maturityDateEnd", maturityDateEnd);
        reqMap.put("productType", productType);
        String body = JSONObject.toJSONString(reqMap);
        log.info("\u6838\u8d22\u4fe1\u8bf7\u6c42\u5bf9\u8d26 \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)body);
        String billCheckUrl = this.payPropertiesVo.getHcxBillCheckUrl();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        Integer random = PayHcxUtil.getRandom();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        String clientId = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String token = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        String signUrl = billCheckUrl.substring(billCheckUrl.lastIndexOf("partner") + 7);
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        headersMap.put("X-SCF-TV", timeStamp.toString());
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-NONCE", random.toString());
        try {
            response = this.hcxUtil.doPost(billCheckUrl, body, MediaType.APPLICATION_JSON, headersMap);
        }
        catch (Exception e) {
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + billCheckUrl + e);
        }
        String responseBody = (String)response.getBody();
        log.info("\u6838\u8d22\u4fe1\u8bf7\u6c42\u5bf9\u8d26 \u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBody);
        HcxBillCheckRspBO billCheckRspBO = (HcxBillCheckRspBO)JSONObject.parseObject((String)responseBody, HcxBillCheckRspBO.class);
        if (billCheckRspBO == null || StringUtils.isEmpty((Object)billCheckRspBO.getCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u4ea4\u6613\u5bf9\u8d26\u54cd\u5e94\u62a5\u6587\u8f6c\u5bf9\u8c61\u5931\u8d25");
            return rspBO;
        }
        if (!billCheckRspBO.getCode().equals(PayHcxRspConstants.SUCCESS.getCode()) || !billCheckRspBO.getData().getCode().equals(PayHcxRspConstants.SUCCESS.getCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u4ea4\u6613\u5bf9\u8d26\u5931\u8d25");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)billCheckRspBO.getData().getPkFile())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u4ea4\u6613\u5bf9\u8d26\u5931\u8d25");
            return rspBO;
        }
        Long fileSerial = PayProSequence.nextId();
        String pkFile = billCheckRspBO.getData().getPkFile();
        HashMap<String, String> fileReqMap = new HashMap<String, String>();
        fileReqMap.put("serial", fileSerial.toString());
        fileReqMap.put("partnerId", partnerId);
        fileReqMap.put("partnerName", partnerName);
        fileReqMap.put("pkFile", pkFile);
        String fileBody = JSONObject.toJSONString(fileReqMap);
        log.info("\u6838\u8d22\u4fe1\u53d1\u8d77\u6587\u4ef6\u4e0b\u8f7d \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)fileBody);
        String fileDownloadUrl = this.payPropertiesVo.getHcxFileDownloadUrl();
        HashMap<String, String> fileHeadersMap = new HashMap<String, String>();
        Long filetimeStamp = PayHcxUtil.getTimeStamp();
        Integer fileRandom = PayHcxUtil.getRandom();
        String fileToken = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        String fileSignUrl = fileDownloadUrl.substring(fileDownloadUrl.lastIndexOf("partner") + 7);
        String fileSign = PayHcxUtil.getSign(fileSignUrl, fileRandom, filetimeStamp, fileBody, fileToken);
        fileHeadersMap.put("X-SCF-TV", filetimeStamp.toString());
        fileHeadersMap.put("X-SCF-AUTH-TOKEN", fileToken);
        fileHeadersMap.put("X-SCF-SIGN", fileSign);
        fileHeadersMap.put("X-SCF-NONCE", fileRandom.toString());
        try {
            fileResponse = this.hcxUtil.doPostFile(fileDownloadUrl, fileBody, MediaType.APPLICATION_JSON, fileHeadersMap);
        }
        catch (Exception e) {
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + fileDownloadUrl + e);
        }
        if (fileResponse.getBody() == null) {
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + fileDownloadUrl);
        }
        byte[] billFIleBytes = (byte[])fileResponse.getBody();
        List<HcxBillContentInfoBO> hcxBillContentInfoBOS = PayBillAbleHcxImpl.parseObjFromBillContent(billFIleBytes, HcxBillContentInfoBO.class);
        this.parseAndSavaToRspBos(hcxBillContentInfoBOS, rspBO, reqBo.getBillDate());
        return rspBO;
    }

    private String validateBillArgs(PayBillAbleDownloadReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getBillDate() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'billDate'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public static <T> List<T> parseObjFromBillContent(byte[] bytes, Class<T> clazz) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        HSSFWorkbook sheets = new HSSFWorkbook();
        try {
            sheets = new XSSFWorkbook((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JxcelParser.parser().parseFromWorkbook(clazz, (Workbook)sheets);
    }

    public void parseAndSavaToRspBos(List<HcxBillContentInfoBO> billContentInfoBOList, PayBillAbleDownloadRspBo rspBo, Long billDate) {
        List<HcxCorpInfo> infos = this.pRelOrderParamMapper.listCorpInfo();
        HashMap<String, String> corpInfoMap = new HashMap<String, String>();
        for (HcxCorpInfo info : infos) {
            corpInfoMap.put(info.getName(), info.getCode());
        }
        for (HcxBillContentInfoBO billContentInfoBO : billContentInfoBOList) {
            this.buildDownloadRspDataBO(billContentInfoBO, rspBo, billDate, corpInfoMap);
        }
    }

    public void buildDownloadRspDataBO(HcxBillContentInfoBO billContentInfoBO, PayBillAbleDownloadRspBo rspBo, Long billDate, Map<String, String> corpInfoMap) {
        PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
        trans.setOrderType("01");
        switch (billContentInfoBO.getCreditState()) {
            case "ISSUED": 
            case "REDEEM": 
            case "REDEEMING": 
            case "REDEEMED": 
            case "RECOVER": 
            case "RECOVERED": {
                trans.setTypeOrderId(billContentInfoBO.getPartnerBusiId());
                trans.setBillDate(billDate);
                trans.setPaymentInsId(BillConstant.PaymentIns.HCX_PAY.getPaymentInsId());
                trans.setTypeTransId(billContentInfoBO.getPkCreditIssue());
                String maturityAmount = billContentInfoBO.getMaturityAmount();
                Double doubleMaturityAmount = Double.parseDouble(maturityAmount) * 100.0;
                long amount = doubleMaturityAmount.longValue();
                trans.setRealFee(Long.valueOf(amount));
                trans.setBillFlag("0");
                String paymentMchId = corpInfoMap.get(billContentInfoBO.getCorpNameAccept());
                if (StringUtils.isEmpty((Object)paymentMchId)) break;
                trans.setPaymentMchId(paymentMchId);
                trans.setPaymentInsObj((Object)billContentInfoBO);
                trans.setTradeTime(billContentInfoBO.getSignDate());
                rspBo.getRspDataBos().add(trans);
                break;
            }
        }
    }
}

