/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.jcraft.jsch.ChannelSftp;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.PayFtpUtil;
import com.tydic.payment.pay.util.PayProBillUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PayBillAbleIcbcImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleIcbcImpl.class);
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Value(value="${bill.icbc.hostUrl:106.120.68.125}")
    private String hostUrl;
    @Value(value="${bill.icbc.hostPort:8001}")
    private int hostPort;
    @Value(value="${bill.icbc.hostUser:zhonghe}")
    private String hostUser;
    @Value(value="${bill.icbc.rsaPath:~/.ssh/id_rsa}")
    private String rsaPath;
    @Value(value="${bill.icbc.targetNamePrefix:/PartnerStatement/download/ICBC_0100106889060220001700000000084004_}")
    private String targetNamePrefix;
    @Value(value="${bill.icbc.ossRsaPath:payCenter/icbc_id_rsa.rsa}")
    private String ossRsaPath;
    @Value(value="${bill.icbc.ossRsaPubPath:payCenter/icbc_id_rsa.pub}")
    private String ossRsaPubPath;
    private static final String RSA_PUB_SUFFIX = ".pub";
    @Autowired
    private FileClient fileClient;
    private static final String ICBC_ORDER_TYPE_PAY = "101";
    private static final String ICBC_ORDER_TYPE_COMB_PAY = "103";

    public Long paymentIns() {
        return BillConstant.PaymentIns.ICBC_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo retBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        Map paraMap = reqBo.getParaMap();
        Long billDate = reqBo.getBillDate();
        String accountNo = (String)paraMap.get("accountNo");
        String targetPath = this.targetNamePrefix + billDate + ".xls";
        String localPath = PayProBillUtil.getBillFileSavePath("icbc", String.valueOf(billDate), accountNo, ".xls");
        File rsaFile = new File(this.rsaPath);
        File rsaPubFile = new File(this.rsaPath + RSA_PUB_SUFFIX);
        boolean exists = rsaFile.exists();
        if (!exists) {
            File rsaDownloadFile = this.fileClient.downloadToFile(this.ossRsaPath);
            File rsaPubDownloadFile = this.fileClient.downloadToFile(this.ossRsaPubPath);
            FileUtil.copy((File)rsaDownloadFile, (File)rsaFile, (boolean)true);
            FileUtil.copy((File)rsaPubDownloadFile, (File)rsaPubFile, (boolean)true);
            this.chmodFile("chmod 600 " + this.rsaPath);
            this.chmodFile("chmod 644 " + this.rsaPath + RSA_PUB_SUFFIX);
        }
        try {
            this.downLoadToOutputStream(this.hostUrl, this.hostPort, this.hostUser, this.rsaPath, localPath, targetPath, retBo, accountNo, billDate);
        }
        catch (FileNotFoundException e) {
            throw new BillDownAndTransException("\u4e0b\u8f7d\u6587\u4ef6\u6216\u7ec4\u88c5\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return retBo;
    }

    private void chmodFile(String command) {
        boolean isLinux = System.getProperty("os.name").toLowerCase().startsWith("linux");
        this.LOGGER.info("\u662f\u5426\u662flinux\uff1a" + isLinux);
        String realCommand = "sh -c \"" + command + "\"";
        if (isLinux) {
            try {
                Process exec = Runtime.getRuntime().exec(realCommand);
                InputStream inputStream = exec.getInputStream();
                this.LOGGER.info("linux\u547d\u4ee4\u6267\u884c\u8fd4\u56de\u7ed3\u679c\u5982\u4e0b\uff1a");
                IoUtil.readUtf8Lines((InputStream)inputStream, (LineHandler)new LineHandler(){

                    public void handle(String line) {
                        PayBillAbleIcbcImpl.this.LOGGER.info(line);
                    }
                });
            }
            catch (IOException e) {
                this.LOGGER.error("\u6267\u884clinux\u547d\u4ee4(" + realCommand + ")\u62a5\u9519");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downLoadToOutputStream(String host, int port, String userName, String rsaPath, String localPath, String targetPath, PayBillAbleDownloadRspBo retBo, String accountNo, Long billDate) throws FileNotFoundException {
        ChannelSftp ftpClient = PayFtpUtil.openSftpWithRsa(host, port, userName, rsaPath, "");
        FileOutputStream outputStream = new FileOutputStream(localPath);
        PayFtpUtil.downloadToStream(ftpClient, targetPath, outputStream);
        ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
        SyncReadListener syncReadListener = new SyncReadListener();
        FileInputStream inputStream = new FileInputStream(localPath);
        try {
            ExcelReader build = EasyExcel.read((InputStream)inputStream, (ReadListener)syncReadListener).build();
            build.read(new ReadSheet[]{readSheet});
            List list = syncReadListener.getList();
            List rspDataBos = retBo.getRspDataBos();
            for (int i = 0; i < list.size(); ++i) {
                Map map;
                PayBillAbleDownloadRspDataBo dataBo;
                if (i <= 1 || null == (dataBo = this.convertMapToRsp(map = (Map)list.get(i), accountNo, billDate))) continue;
                rspDataBos.add(dataBo);
            }
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private PayBillAbleDownloadRspDataBo convertMapToRsp(Map<Integer, String> map, String accountNo, Long billDate) {
        String payeeAccount = map.get(9);
        String payerAccount = map.get(15);
        String tradeType = map.get(4);
        if (tradeType.contains(ICBC_ORDER_TYPE_COMB_PAY) || tradeType.contains(ICBC_ORDER_TYPE_PAY)) {
            tradeType = "01";
            if (!accountNo.equals(payeeAccount)) {
                return null;
            }
        } else {
            tradeType = "02";
            if (!accountNo.equals(payerAccount)) {
                return null;
            }
        }
        PayBillAbleDownloadRspDataBo dataBo = new PayBillAbleDownloadRspDataBo();
        dataBo.setOrderType(tradeType);
        dataBo.setTypeOrderId(map.get(1));
        dataBo.setBillDate(billDate);
        dataBo.setPaymentInsId(BillConstant.PaymentIns.ICBC_PAY.getPaymentInsId());
        dataBo.setTypeTransId(map.get(1));
        String realFeeStr = map.get(7);
        BigDecimal peyFeeYuan = new BigDecimal(realFeeStr);
        dataBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)peyFeeYuan).longValue()));
        dataBo.setBillFlag("0");
        dataBo.setPaymentMchId(accountNo);
        dataBo.setPaymentInsObj(map);
        dataBo.setTradeTime(map.get(0));
        return dataBo;
    }
}

