/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.impl.AbstractUmcPayAble;
import com.tydic.payment.pay.payable.impl.transbo.PayAbleUmcEnterpriseChargeBo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UmcPayBalancePayAbleImpl
extends AbstractUmcPayAble {
    private static final Logger log = LoggerFactory.getLogger(UmcPayBalancePayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.UMC_PAY_BALANCE.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u4f1a\u5458\u4f59\u989d\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff1a" + validateStr);
            retBo.setRespCode("212037");
            retBo.setRespDesc("\u4f1a\u5458\u4f59\u989d\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        BigDecimal fen = new BigDecimal(reqBo.getPayFee());
        String yuan = MoneyUtils.fenToYuanToString((BigDecimal)fen);
        PayAbleUmcEnterpriseChargeBo chargeBo = new PayAbleUmcEnterpriseChargeBo();
        chargeBo.setOrgId(Long.parseLong((String)paraMap.get("orgId")));
        chargeBo.setAmount(yuan);
        chargeBo.setOperType("2");
        chargeBo.setPayOrderId(reqBo.getPayOrderId());
        String resultStr = super.callUmc(chargeBo);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        this.dealResult(retBo, resultStr);
        return retBo;
    }

    private void dealResult(PayAbleDealPayRspBo retBo, String resultStr) {
        super.dealResult((PayProBaseRspBo)retBo, resultStr);
        if ("0000".equals(retBo.getRespCode())) {
            JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
            String logId = jsonObject.getJSONObject("data").getLong("logId").toString();
            retBo.setPayNotifyTransId(logId);
            Date nowTime = this.queryDBDateBusiService.getDBDate();
            retBo.setTradeTime(new DateTime((Object)nowTime).toString("yyyy-MM-ss HH:mm:ss"));
            retBo.setPayResultCode("SUCCESS");
            retBo.setPayResultMsg(retBo.getRespDesc());
        }
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a'";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get("orgId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'orgId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

