/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractUnionPayAble;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UnionPayQrCodePayAbleImpl
extends AbstractUnionPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(UnionPayQrCodePayAbleImpl.class);
    private static final String SUCCESS = "00";
    private static final String UNION_RESP_CODE = "respCode";
    private static final String UNION_RESP_MSG = "respMsg";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource
    private FileClient fileClient;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.UNION_PAY_QR_CB.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        Map rspDate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u8fdb\u5165\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u670d\u52a1\u5b9e\u73b0\u7c7b");
        }
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validataArgStr = this.validataArg(reqBo);
        if (StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("212025");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
        }
        this.loadProperties(reqBo);
        String payOrderId = reqBo.getPayOrderId();
        PorderPayTransAtomRspBo orderInfo = super.getOrderPayTrans(payOrderId);
        Map<String, String> payReqContent = this.createPayReqContent(reqBo, orderInfo);
        Map reqData = AcpService.sign(payReqContent, (String)"UTF-8");
        String requestAppUrl = SdkConfig.getConfig().getBackRequestUrl();
        if (StringUtils.isEmpty((Object)requestAppUrl)) {
            LOG.error("\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u5730\u5740\u672a\u914d\u7f6e");
            throw new BusinessException("216022", "\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u5730\u5740\u672a\u914d\u7f6e");
        }
        try {
            rspDate = AcpService.post((Map)reqData, (String)requestAppUrl, (String)"UTF-8");
        }
        catch (Exception e) {
            LOG.error("\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216022", "\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e);
        }
        if (rspDate.isEmpty()) {
            LOG.error("\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56demap\u4e3a\u7a7a");
            throw new BusinessException("216022", "\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56demap\u4e3a\u7a7a");
        }
        try {
            if (!AcpService.validate((Map)rspDate, (String)"UTF-8")) {
                LOG.error("\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
                throw new BusinessException("216022", "\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOG.error("\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38");
            throw new BusinessException("216022", "\u94f6\u8054\u4e8c\u7ef4\u7801(\u4e3b\u626b-C\u626bB\u6a21\u5f0f)\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38");
        }
        if (!SUCCESS.equals(rspDate.get(UNION_RESP_CODE))) {
            retBo.setRespCode("212025");
            retBo.setRespDesc((String)rspDate.get(UNION_RESP_MSG));
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setQrCodeUrl((String)rspDate.get("qrCode"));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        LOG.info("\u94f6\u8054\u8fd4\u56de\u7684url\uff1a" + (String)rspDate.get("qrCode"));
        return retBo;
    }

    private Map<String, String> createPayReqContent(PayAbleDealPayReqBo reqBo, PorderPayTransAtomRspBo orderInfo) {
        String merId = (String)reqBo.getParaMap().get("merId");
        HashMap<String, String> payReqContent = new HashMap<String, String>(64);
        payReqContent.put("version", SdkConfig.getConfig().getVersion());
        payReqContent.put("encoding", "UTF-8");
        payReqContent.put("signMethod", SdkConfig.getConfig().getSignMethod());
        payReqContent.put("txnType", "01");
        payReqContent.put("txnSubType", "07");
        payReqContent.put("bizType", "000000");
        payReqContent.put("channelType", "08");
        payReqContent.put("merId", merId);
        payReqContent.put("accessType", "0");
        payReqContent.put("orderId", reqBo.getPayOrderId());
        payReqContent.put("txnTime", DateUtils.dateToStr((Date)orderInfo.getCreateTime(), (String)"yyyyMMddHHmmss"));
        payReqContent.put("txnAmt", String.valueOf(reqBo.getPayFee()));
        payReqContent.put("currencyCode", "156");
        payReqContent.put("backUrl", SdkConfig.getConfig().getBackUrl());
        payReqContent.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis() + 180000L));
        return payReqContent;
    }

    private void loadProperties(PayAbleDealPayReqBo req) {
        HashMap<String, String> payParaMap = new HashMap<String, String>(req.getParaMap().size());
        Set set = req.getParaMap().keySet();
        for (String key : set) {
            payParaMap.put(key, (String)req.getParaMap().get(key));
        }
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
    }

    private String validataArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get("merId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(merId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

