/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.common.base.bo.PayProPageDataBo;
import com.tydic.payment.pay.common.base.bo.PayProPageRspBo;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PaymentInsMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.payment.pay.web.bo.req.PayProMerchantRelPayInsQryWebServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.PayProMerchantRelPayInsQryWebServiceRspBo;
import com.tydic.payment.pay.web.service.PayProMerchantRelPayInsQryWebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProMerchantRelPayInsQryWebService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.web.service.PayProMerchantRelPayInsQryWebService"})
public class PayProMerchantRelPayInsQryWebServiceImpl
implements PayProMerchantRelPayInsQryWebService {
    private static final Logger log = LoggerFactory.getLogger(PayProMerchantRelPayInsQryWebServiceImpl.class);
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PaymentInsMapper paymentInsMapper;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"qryRelPayIns"})
    public PayProPageRspBo<PayProMerchantRelPayInsQryWebServiceRspBo> qryRelPayIns(@RequestBody PayProMerchantRelPayInsQryWebServiceReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u8fdb\u5165\u5546\u6237\u914d\u7f6e\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u67e5\u8be2web\u670d\u52a1\uff1a\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        PayProPageRspBo retBo = PayProRspUtil.generateSucRspBo(PayProPageRspBo.class);
        PayProPageDataBo data = new PayProPageDataBo();
        ArrayList<PayProMerchantRelPayInsQryWebServiceRspBo> rows = new ArrayList<PayProMerchantRelPayInsQryWebServiceRspBo>();
        data.setRows(rows);
        retBo.setData(data);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            log.error("\u5165\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
        qryMerchantPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        MerChantInfoPo merChantInfo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantPo);
        if (null == merChantInfo) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237[" + reqBo.getMerchantId() + "]\u7684\u4fe1\u606f");
            return retBo;
        }
        String merchantType = null;
        if (merChantInfo.getMerchantType() != null) {
            QueryPCodeInfoReqBO typeReq = new QueryPCodeInfoReqBO();
            typeReq.setTypeCode("MERCHANT_TYPE");
            typeReq.setCodeValue(merChantInfo.getMerchantType().toString());
            QueryPCodeInfoRspBO typeRsp = this.queryPCodeInfoService.queryPCodeInfo(typeReq);
            if (typeRsp.getRespCode().equals("0000")) {
                merchantType = StringUtils.isEmpty((String)typeRsp.getCodeInfo()) ? merChantInfo.getMerchantType().toString() : typeRsp.getCodeInfo();
            }
        }
        Page<MerchantPayMethodRelPo> page = this.getPage(reqBo);
        MerchantPayMethodRelPo reqPo = new MerchantPayMethodRelPo();
        reqPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        if (!StringUtils.isEmpty((String)reqBo.getPaymentInsId())) {
            reqPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        }
        if (!StringUtils.isEmpty((String)reqBo.getPayMethod())) {
            reqPo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        }
        List<MerchantPayMethodRelPo> relPos = this.merchantPayMethodRelMapper.queryRelInfoPage(page, reqPo);
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty(relPos)) {
            return retBo;
        }
        Map<Long, String> paymentInsMap = this.getPaymentInsMap();
        Map<Long, String> payMethodMap = this.getPayMethodMap();
        for (MerchantPayMethodRelPo relPo : relPos) {
            PayProMerchantRelPayInsQryWebServiceRspBo dataBo = new PayProMerchantRelPayInsQryWebServiceRspBo();
            dataBo.setMerchantId(relPo.getMerchantId().toString());
            dataBo.setMerchantName(merChantInfo.getMerchantName());
            dataBo.setMerchantType(merchantType);
            dataBo.setPaymentInsId(relPo.getPaymentInsId().toString());
            dataBo.setPaymentInsName(paymentInsMap.get(relPo.getPaymentInsId()));
            List<String> payMethods = Arrays.asList(relPo.getPayMethods().split(","));
            dataBo.setPayMethods(payMethods);
            if (null != relPo.getCreateTime()) {
                dataBo.setUpdateTime(new DateTime(relPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            }
            StringBuilder payMethodNameBuilder = new StringBuilder();
            for (String payMethod : payMethods) {
                payMethodNameBuilder.append(payMethodMap.get(Long.valueOf(payMethod)) + "\uff0c");
            }
            dataBo.setPayMethodName(payMethodNameBuilder.substring(0, payMethodNameBuilder.length() - 1));
            rows.add(dataBo);
        }
        return retBo;
    }

    private Map<Long, String> getPayMethodMap() {
        Map<Long, String> payMethodMap = new HashMap<Long, String>(1);
        List<PayMethodPo> methodPos = this.payMethodMapper.queryPayMethod(new PayMethodPo());
        if (CollectionUtils.isEmpty(methodPos)) {
            return payMethodMap;
        }
        payMethodMap = methodPos.stream().collect(Collectors.toMap(PayMethodPo::getPayMethod, PayMethodPo::getPayMethodName));
        return payMethodMap;
    }

    private Map<Long, String> getPaymentInsMap() {
        Map<Long, String> paymentInsMap = new HashMap<Long, String>(1);
        List<PaymentInsPo> paymentInsPos = this.paymentInsMapper.queryPaymentInf(new PaymentInsPo());
        if (CollectionUtils.isEmpty(paymentInsPos)) {
            return paymentInsMap;
        }
        paymentInsMap = paymentInsPos.stream().collect(Collectors.toMap(PaymentInsPo::getPaymentInsId, PaymentInsPo::getPaymentInsName));
        return paymentInsMap;
    }

    private Page<MerchantPayMethodRelPo> getPage(PayProMerchantRelPayInsQryWebServiceReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private String validateArgs(PayProMerchantRelPayInsQryWebServiceReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBo.getMerchantId())) {
            return "\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

