/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.bo.PayCenterRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.PayProOtherCenterReqBo;
import com.tydic.payment.pay.web.bo.rsp.PayProOtherCenterRspBo;
import com.tydic.payment.pay.web.bo.rsp.PayProUmcDataBo;
import com.tydic.payment.pay.web.service.PayProOtherCenterService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProOtherCenterService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.web.service.PayProOtherCenterService"})
public class PayProOtherCenterServiceImpl
implements PayProOtherCenterService {
    private static final Logger log = LoggerFactory.getLogger(PayProOtherCenterServiceImpl.class);
    @Value(value="${cnnc.umc.url:http://baidu.com}")
    private String umcUrl;
    @Value(value="${cnnc.fsc.url:http://baidu.com}")
    private String fscUrl;

    @PostMapping(value={"transUms"})
    public PayCenterRspBo<PayProOtherCenterRspBo> transUms(@RequestBody PayProOtherCenterReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        String reqJson = JSON.toJSONString((Object)reqBo);
        String result = HttpUtil.post((String)this.umcUrl, (String)reqJson);
        log.info("\u5f97\u5230\u7684\u51fa\u53c2\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        PayProOtherCenterRspBo data = new PayProOtherCenterRspBo();
        try {
            String rows = resultJson.getString("rows");
            List dataBos = JSON.parseArray((String)rows, PayProUmcDataBo.class);
            data.setDataBos(dataBos);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5217\u8868\u5931\u8d25\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u83b7\u53d6\u6570\u636e\u5217\u8868\u5931\u8d25\u5f02\u5e38: {}" + e.getMessage());
        }
        PayCenterRspBo retBo = new PayCenterRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRspCode("0000");
        retBo.setRspName("\u6210\u529f");
        retBo.setData((BaseRspInfoBO)data);
        if (log.isDebugEnabled()) {
            log.debug("\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    @PostMapping(value={"tranFsc"})
    public PayCenterRspBo<PayProOtherCenterRspBo> tranFsc(@RequestBody PayProOtherCenterReqBo reqBo) {
        String respDesc;
        String respCode;
        if (log.isDebugEnabled()) {
            log.debug("\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        String reqJson = JSON.toJSONString((Object)reqBo);
        String result = HttpUtil.post((String)this.fscUrl, (String)reqJson);
        log.info("\u5f97\u5230\u7684\u51fa\u53c2\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        try {
            respCode = resultJson.getString("respCode");
            respDesc = resultJson.getString("respDesc");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7ed3\u7b97\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u8c03\u7528\u7ed3\u7b97\u5f02\u5e38: {}" + e.getMessage());
        }
        PayCenterRspBo retBo = new PayCenterRspBo();
        if (!"0000".equals(respCode)) {
            retBo.setRespCode(respCode);
            retBo.setRespDesc(respDesc);
            retBo.setRspCode(respCode);
            retBo.setRspName(respDesc);
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRspCode("0000");
        retBo.setRspName("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }
}

