/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.hcx.PayHcxRspConstants;
import com.tydic.payment.pay.util.PayHcxUtil;
import com.tydic.payment.pay.web.bo.req.QueryQuotaInfoReqBO;
import com.tydic.payment.pay.web.bo.rsp.PayHcxRspDataListBO;
import com.tydic.payment.pay.web.bo.rsp.QueryQuotaInfoRspBO;
import com.tydic.payment.pay.web.service.QueryHcxQuotaInfoBusiService;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="queryHcxQuotaInfoBusiService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.web.service.QueryHcxQuotaInfoBusiService"})
public class QueryHcxQuotaInfoWebServiceImpl
implements QueryHcxQuotaInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(QueryHcxQuotaInfoWebServiceImpl.class);
    private static final String SERVICE_NAME = "\u67e5\u8be2\u6838\u8d22\u4fe1\u989d\u5ea6\u4fe1\u606f\u670d\u52a1";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;
    @Autowired
    private PayHcxUtil hcxUtil;

    @PostMapping(value={"queryQuota"})
    public QueryQuotaInfoRspBO queryQuota(@RequestBody QueryQuotaInfoReqBO reqBO) {
        ResponseEntity<String> response;
        QueryQuotaInfoRspBO rspBO = new QueryQuotaInfoRspBO();
        rspBO.setRspCode("8888");
        rspBO.setRspName("\u67e5\u8be2\u989d\u5ea6\u4fe1\u606f\u5931\u8d25");
        QueryHcxQuotaInfoWebServiceImpl.valid(reqBO);
        PayHcxRspDataListBO data = new PayHcxRspDataListBO();
        String tokenUrl = this.payPropertiesVo.getHcxTokenUrl();
        String clientId = this.payPropertiesVo.getHcxClientid();
        String clientSecret = this.payPropertiesVo.getHcxClientSecret();
        String quotaUrl = this.payPropertiesVo.getHcxQueryQuotaUrl();
        String partnerId = this.payPropertiesVo.getHcxPartnerId();
        String partnerName = this.payPropertiesVo.getHcxPartnerName();
        PRelOrderParamPO pRelOrderParamPO = new PRelOrderParamPO();
        pRelOrderParamPO.setOrderId(Long.parseLong(reqBO.getOrderId()));
        List<PRelOrderParamPO> list = this.pRelOrderParamMapper.getList(pRelOrderParamPO);
        List name = list.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_NAME_CORE.getValue())).collect(Collectors.toList());
        List idType = list.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_TYPE_CORE.getValue())).collect(Collectors.toList());
        List idCode = list.stream().filter(bo -> bo.getParamKey().equals(PayProConstants.HcxPayParamConstants.PARAM_CORP_ID_CODE_CORE.getValue())).collect(Collectors.toList());
        if (name.size() < 1 || idType.size() < 1 || idCode.size() < 1) {
            rspBO.setRspName("\u8be5\u8ba2\u5355\u65e0\u6cd5\u67e5\u8be2\u989d\u5ea6");
            return rspBO;
        }
        String corpNameCore = ((PRelOrderParamPO)name.get(0)).getParamValue();
        String corpIdTypeCore = ((PRelOrderParamPO)idType.get(0)).getParamValue();
        String corpIdCodeCore = ((PRelOrderParamPO)idCode.get(0)).getParamValue();
        String token = this.hcxUtil.getToken(tokenUrl, clientId, clientSecret);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        Long serial = PayProSequence.nextId();
        reqMap.put("serial", serial);
        reqMap.put("partnerId", partnerId);
        reqMap.put("partnerName", partnerName);
        reqMap.put("corpNameCore", corpNameCore);
        reqMap.put("corpIdTypeCore", corpIdTypeCore);
        reqMap.put("corpIdCodeCore", corpIdCodeCore);
        reqMap.put("productType", "0");
        reqMap.put("page", "1");
        reqMap.put("pageSize", "50");
        String body = JSONObject.toJSONString(reqMap);
        log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)body);
        String signUrl = quotaUrl.substring(quotaUrl.lastIndexOf("partner") + 7);
        Integer random = PayHcxUtil.getRandom();
        Long timeStamp = PayHcxUtil.getTimeStamp();
        String sign = PayHcxUtil.getSign(signUrl, random, timeStamp, body, token);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("X-SCF-NONCE", random.toString());
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-AUTH-TOKEN", token);
        headersMap.put("X-SCF-TV", timeStamp.toString());
        log.info("headerMap:{}", (Object)JSON.toJSONString(headersMap));
        String requestUrl = quotaUrl;
        try {
            response = this.hcxUtil.doPost(requestUrl, body, MediaType.APPLICATION_JSON, headersMap);
        }
        catch (Exception e) {
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8bf7\u6c42\u6838\u8d22\u4fe1\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + requestUrl + e);
        }
        log.info("\u67e5\u8be2\u6838\u5f69\u4fe1\u989d\u5ea6\u4fe1\u606f\uff0c\u54cd\u5e94\u62a5\u6587\uff1a{}", response.getBody());
        String rspBody = (String)response.getBody();
        log.info("\u6838\u8d22\u4fe1\uff1a\u8ba2\u5355\u53f7\u3010{}\u3011,\u67e5\u8be2\u989d\u5ea6\u4fe1\u606f  -----> \u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)reqBO.getOrderId(), (Object)rspBody);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryQuotaInfoRspBO queryRspBO = (QueryQuotaInfoRspBO)JSONObject.parseObject((String)rspBody, QueryQuotaInfoRspBO.class);
        if (queryRspBO == null) {
            rspBO.setRspCode("8888");
            rspBO.setRspName("\u54cd\u5e94\u62a5\u6587\u8f6c\u5bf9\u8c61\u5931\u8d25");
            return rspBO;
        }
        if (ObjectUtils.isEmpty((Object)queryRspBO.getData())) {
            rspBO.setRspCode("8888");
            rspBO.setRspName("\u5931\u8d25");
            return rspBO;
        }
        block18: for (int i = 0; i < queryRspBO.getData().getCorpLimitDetail().size(); ++i) {
            ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setEffectDate(((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getExpiryDate().substring(0, 19).replaceAll("T", " "));
            ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setExpiryDate(((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getExpiryDate().substring(0, 19).replaceAll("T", " "));
            ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setIssueMinterm(((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getIssueMinterm().substring(0, 19).replaceAll("T", " "));
            ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setIssueMaxterm(((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getIssueMaxterm().substring(0, 19).replaceAll("T", " "));
            switch (((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getProductType()) {
                case "0": {
                    ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setProductType("\u767d\u6761");
                    break;
                }
            }
            switch (((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).getLimitType()) {
                case "SOURCE_CORE": {
                    ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setLimitType("\u6838\u5fc3\u4f01\u4e1a\u989d\u5ea6");
                    continue block18;
                }
                case "SOURCE_GROUP": {
                    ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setLimitType("\u96c6\u56e2\u989d\u5ea6");
                    continue block18;
                }
                case "SOURCE_SELF": {
                    ((QueryQuotaInfoRspBO.DataDTO.CorpLimitDetailDTO)queryRspBO.getData().getCorpLimitDetail().get(i)).setLimitType("\u81ea\u6709\u989d\u5ea6");
                    continue block18;
                }
            }
        }
        if (PayHcxRspConstants.SUCCESS.getCode().equals(queryRspBO.getCode())) {
            rspBO.setRspCode("0000");
            rspBO.setRspName("\u6210\u529f");
            rspBO.setData(queryRspBO.getData());
            return rspBO;
        }
        rspBO.setRspCode("8888");
        rspBO.setRspName("\u5931\u8d25");
        return rspBO;
    }

    private static void valid(QueryQuotaInfoReqBO reqBO) {
        if (reqBO == null) {
            log.info("\u67e5\u8be2\u6838\u8d22\u4fe1\u989d\u5ea6\u4fe1\u606f\u670d\u52a1 -> \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            log.info("\u67e5\u8be2\u6838\u8d22\u4fe1\u989d\u5ea6\u4fe1\u606f\u670d\u52a1 -> \u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public static String splicUrl(String url, String token, String sign) {
        return url + "?access_token=" + token + "&sign=" + sign;
    }
}

