/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class PayHcxUtil {
    private static final Logger log = LoggerFactory.getLogger(PayHcxUtil.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    private static final String GRANTTYPE = "client_credentials";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES_IN = "expires_in";
    private static final String HCX_TOKEN = "hcx_token";
    private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.generateHttpRequestFactory());

    public String getToken(String tokenUrl, String clientId, String clientSecret) {
        return this.requestToken(tokenUrl, clientId, clientSecret);
    }

    public String requestToken(String tokenUrl, String clientId, String clientSecret) {
        log.info("\u8c03\u7528\u5916\u90e8\u670d\u52a1\uff0c\u83b7\u53d6\u6838\u8d22\u4fe1token, clientId:{} ----------- clientSecret:{}", (Object)clientId, (Object)clientSecret);
        String url = tokenUrl + "?grant_type=" + GRANTTYPE;
        HttpHeaders requestHeaders = new HttpHeaders();
        try {
            requestHeaders.add("Authorization", "Basic " + Base64.encodeBase64String((byte[])(clientId + ":" + URLDecoder.decode(clientSecret, "utf-8")).getBytes()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public static String getSign(String url, int random, Long timeStamp, String body, String token) {
        String plaintext = url + "X-SCF-NONCE" + "=" + random + "&" + "X-SCF-TV" + "=" + timeStamp + body + token;
        return DigestUtils.md5Hex((byte[])plaintext.getBytes(StandardCharsets.UTF_8)).toUpperCase();
    }

    public static int getRandom() {
        return new Random().nextInt(1000) + 1;
    }

    public static Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public ResponseEntity<String> doPost(String url, String body, MediaType type, Map<String, String> headersMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(type);
        try {
            httpHeaders.add("X-SCF-TV", headersMap.get("X-SCF-TV"));
            httpHeaders.add("X-SCF-AUTH-TOKEN", headersMap.get("X-SCF-AUTH-TOKEN"));
            httpHeaders.add("X-SCF-SIGN", headersMap.get("X-SCF-SIGN"));
            httpHeaders.add("X-SCF-NONCE", headersMap.get("X-SCF-NONCE"));
        }
        catch (NullPointerException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5fc5\u987b\u8bf7\u6c42\u5934\u6709\u4e3a\u7a7a\u503c" + e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("PAY_CALL_EXTERNAL_SERVICE_ERROE", "\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + url);
        }
        return response;
    }

    public ResponseEntity<byte[]> doPostFile(String url, String body, MediaType type, Map<String, String> headersMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(type);
        try {
            httpHeaders.add("X-SCF-TV", headersMap.get("X-SCF-TV"));
            httpHeaders.add("X-SCF-AUTH-TOKEN", headersMap.get("X-SCF-AUTH-TOKEN"));
            httpHeaders.add("X-SCF-SIGN", headersMap.get("X-SCF-SIGN"));
            httpHeaders.add("X-SCF-NONCE", headersMap.get("X-SCF-NONCE"));
        }
        catch (NullPointerException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5fc5\u987b\u8bf7\u6c42\u5934\u6709\u4e3a\u7a7a\u503c" + e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class, new Object[0]);
        return response;
    }

    private HttpComponentsClientHttpRequestFactory generateHttpRequestFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        TrustStrategy acceptingTrustStrategy = (x509Certificates, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
        SSLConnectionSocketFactory connectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionSocketFactory);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setHttpClient((HttpClient)httpClient);
        return factory;
    }
}

