/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PayProFileDownload {
    private static final Logger log = LoggerFactory.getLogger(PayProFileDownload.class);
    private static final String SEPA = File.separator;
    private static final String BACKSLASH = "/";
    private static final String COMM = ",";
    private static String downloadUrl;

    @Value(value="${fastdfs.downloadUrl:http://172.16.100.64:18000}")
    public void setDownloadUrl(String downloadUrl) {
        PayProFileDownload.downloadUrl = downloadUrl;
    }

    public static File download(String url) {
        url = url.replace(COMM, BACKSLASH);
        log.info("\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84\uff1a" + downloadUrl + BACKSLASH + url);
        String fileName = url.substring(url.lastIndexOf(BACKSLASH) + 1);
        String tempPath = PayProFileDownload.getTempPath() + fileName;
        FileUtil.mkParentDirs((String)tempPath);
        log.info("\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\uff1a{}", (Object)tempPath);
        File file = null;
        try {
            HttpUtil.downloadFile((String)(downloadUrl + BACKSLASH + url), (String)tempPath);
            file = new File(tempPath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return file;
    }

    private static String getTempPath() {
        StringBuilder sb = new StringBuilder();
        String tempDir = System.getProperty("java.io.tmpdir");
        sb.append(tempDir);
        if (!tempDir.endsWith(SEPA)) {
            sb.append(SEPA);
        }
        sb.append("peyCentFile").append(SEPA);
        return sb.toString();
    }
}

