/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private boolean hasInit = false;
    private int socketTimeout = 60000;
    private int connectTimeout = 30000;
    private RequestConfig requestConfig;
    private CloseableHttpClient closeableHttpClient;
    private static HttpClient httpClient = HttpClientBuilder.create().build();
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public HttpUtil() {
        this.init();
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        this.closeableHttpClient = HttpClients.createDefault();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    public static String sendPost(String url, Map<String, String> params) throws ClientProtocolException, IOException {
        return HttpUtil.sendPost(url, params, 0, 0);
    }

    public static String sendPost(String url, Map<String, String> params, int socketTimeout, int connectTimeout) throws ClientProtocolException, IOException {
        HttpUtil httpUtil = new HttpUtil();
        if (socketTimeout > 0) {
            httpUtil.setSocketTimeout(socketTimeout);
        }
        if (connectTimeout > 0) {
            httpUtil.setConnectTimeout(connectTimeout);
        }
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (String key : params.keySet()) {
            list.add(new BasicNameValuePair(key, params.get(key)));
        }
        UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(list, "UTF-8");
        httpPost.setEntity((HttpEntity)uefEntity);
        httpPost.setConfig(httpUtil.getRequestConfig());
        CloseableHttpResponse response = httpUtil.getHttpClient().execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        httpPost.abort();
        return result;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.resetRequestConfig();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.resetRequestConfig();
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    private void resetRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
    }

    public CloseableHttpClient getHttpClient() {
        return this.closeableHttpClient;
    }

    static {
        if (httpClient == null) {
            httpClient = HttpClientBuilder.create().build();
        }
    }
}

