/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.common.util;

import java.math.BigDecimal;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.StringUtils;

public class Utils {
    private Utils() {
    }

    public static String toAmount(long amount) {
        return new BigDecimal(amount).divide(new BigDecimal(100)).toString();
    }

    public static String toDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static boolean isEmpty(Object object) {
        if (object instanceof String) {
            return StringUtils.isEmpty((Object)((String)object));
        }
        return object == null;
    }

    public static boolean isNotEmpty(Object object) {
        return !Utils.isEmpty(object);
    }

    public static <T> boolean isListNotEmpty(List<T> list) {
        return list != null && list.size() > 0;
    }

    public static <T> boolean isListEmpty(List<T> list) {
        return !Utils.isListNotEmpty(list);
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean verify(Map<String, String> params, String publicKey) throws Exception {
        String sign = params.get("sign");
        params.remove("sign");
        params.remove("sign_type");
        String preSignStr = Utils.createLinkString(params);
        return Utils.verify(preSignStr, sign, publicKey, params.get("charset"));
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    private static boolean verify(String content, String sign, String ali_public_key, String input_charset) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodedKey = Base64.decodeBase64((String)ali_public_key);
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initVerify(pubKey);
        signature.update(content.getBytes(input_charset));
        boolean bverify = signature.verify(Base64.decodeBase64((String)sign));
        return bverify;
    }

    public static Map<String, Object> createHumpMap(Map<String, Object> map) throws Exception {
        Pattern linePattern = Pattern.compile("_(\\w)");
        HashMap<String, Object> humpMap = new HashMap<String, Object>();
        Set<String> set1 = map.keySet();
        for (String key : set1) {
            String str = key.toLowerCase();
            Matcher matcher = linePattern.matcher(str);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
            }
            matcher.appendTail(sb);
            humpMap.put(sb.toString(), map.get(key));
        }
        return humpMap;
    }

    public static <T> T str2Bean(String str, Class<T> clazz) throws Exception {
        String[] strs = str.split("\\&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : strs) {
            String[] ms = s.split("=");
            if (ms[1] == null || StringUtils.isEmpty((Object)ms[1].trim()) || "null".equals(ms[1])) continue;
            map.put(ms[0], ms[1]);
        }
        T bean = clazz.newInstance();
        BeanUtils.populate(bean, map);
        return bean;
    }

    public static Map<String, String> createLineUpperCaseMap(Map<String, String> map) throws Exception {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        HashMap<String, String> lineUpperCaseMap = new HashMap<String, String>();
        Set<String> set1 = map.keySet();
        for (String key : set1) {
            String value = map.get(key);
            Matcher matcher = humpPattern.matcher(key);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "_" + matcher.group(0));
            }
            matcher.appendTail(sb);
            lineUpperCaseMap.put(sb.toString().toUpperCase(), value);
        }
        return lineUpperCaseMap;
    }

    public static Map<String, Object> mapKeytoLowerCase(Map<String, Object> map) throws Exception {
        HashMap<String, Object> neaMap = new HashMap<String, Object>();
        Set<String> set1 = map.keySet();
        for (String key : set1) {
            String str = key.toLowerCase();
            neaMap.put(str, map.get(key));
        }
        return neaMap;
    }
}

