/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wx.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpsRequest.class);
    private boolean hasInit = false;
    private int socketTimeout = 10000;
    private int connectTimeout = 30000;
    private RequestConfig requestConfig;
    private CloseableHttpClient httpClient;
    private boolean isNeedCert = false;
    private String certPath = "";
    private String certPassword = "";

    public HttpsRequest() throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.init();
    }

    public HttpsRequest(String certPath, String certPassword) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.isNeedCert = true;
        this.certPath = certPath;
        this.certPassword = certPassword;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = null;
        if (this.isNeedCert) {
            keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = null;){
                instream = new FileInputStream(new File(this.certPath));
                keyStore.load(instream, this.certPassword.toCharArray());
            }
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, this.certPassword.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPost(String url, Object xmlObj) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        XStream xStreamForRequestPostData = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
        xStreamForRequestPostData.omitField(xmlObj.getClass(), "key");
        String postDataXML = xStreamForRequestPostData.toXML(xmlObj);
        logger.debug(postDataXML);
        StringEntity postEntity = new StringEntity(postDataXML, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.setEntity((HttpEntity)postEntity);
        httpPost.setConfig(this.requestConfig);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            System.out.println("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            System.out.println("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            System.out.println("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            System.out.println("http get throw Exception");
        }
        finally {
            httpPost.abort();
        }
        return result;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.resetRequestConfig();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.resetRequestConfig();
    }

    private void resetRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public static interface ResultListener {
        public void onConnectionPoolTimeoutError();
    }
}

