/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wx.req.bo;

import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class WXApiUnifiedOrderReqBO {
    private static final int expireTime = 3;
    private String appid = "";
    private String mch_id = "";
    private String sub_appid;
    private String sub_mch_id = "";
    private String device_info = "";
    private String nonce_str = "";
    private String sign = "";
    private String sign_type;
    private String body = "";
    private String detail;
    private String attach;
    private String out_trade_no = "";
    private String fee_type;
    private int total_fee = 0;
    private String spbill_create_ip = "";
    private String time_start;
    private String time_expire;
    private String goods_tag;
    private String notify_url = "";
    private String trade_type = "";
    private String product_id = "";
    private String limit_pay;
    private String openid = "";
    private String sub_openid;
    private String scene_info = "";
    private String key = "";

    public WXApiUnifiedOrderReqBO setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public WXApiUnifiedOrderReqBO setMch_id(String mch_id) {
        this.mch_id = mch_id;
        return this;
    }

    public WXApiUnifiedOrderReqBO setSub_appid(String sub_appid) {
        this.sub_appid = sub_appid;
        return this;
    }

    public WXApiUnifiedOrderReqBO setSub_mch_id(String sub_mch_id) {
        this.sub_mch_id = sub_mch_id;
        return this;
    }

    public WXApiUnifiedOrderReqBO setDevice_info(String device_info) {
        this.device_info = device_info;
        return this;
    }

    public WXApiUnifiedOrderReqBO setNonce_str(String nonce_str) {
        this.nonce_str = StringUtils.isNotEmpty((String)nonce_str) ? nonce_str : RandomStringGenerator.getRandomStringByLength(32);
        return this;
    }

    public WXApiUnifiedOrderReqBO setSign_type(String sign_type) {
        this.sign_type = sign_type;
        return this;
    }

    public WXApiUnifiedOrderReqBO setBody(String body) {
        this.body = body;
        return this;
    }

    public WXApiUnifiedOrderReqBO setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public WXApiUnifiedOrderReqBO setAttach(String attach) {
        this.attach = attach;
        return this;
    }

    public WXApiUnifiedOrderReqBO setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
        return this;
    }

    public WXApiUnifiedOrderReqBO setFee_type(String fee_type) {
        this.fee_type = fee_type;
        return this;
    }

    public WXApiUnifiedOrderReqBO setTotal_fee(int total_fee) {
        this.total_fee = total_fee;
        return this;
    }

    public WXApiUnifiedOrderReqBO setSpbill_create_ip(String spbill_create_ip) {
        this.spbill_create_ip = spbill_create_ip;
        return this;
    }

    public WXApiUnifiedOrderReqBO setTime_start(Date time_start) {
        this.time_start = new SimpleDateFormat("yyyyMMddHHmmss").format(time_start.getTime());
        return this;
    }

    public WXApiUnifiedOrderReqBO setTime_expire(Date time_expire) throws ParseException {
        if (time_expire != null) {
            this.time_start = new SimpleDateFormat("yyyyMMddHHmmss").format(time_expire.getTime());
        } else {
            this.time_expire = new SimpleDateFormat("yyyyMMddHHmmss").format(new SimpleDateFormat("yyyyMMddHHmmss").parse(this.getTime_start()).getTime() + 180000L);
        }
        return this;
    }

    public WXApiUnifiedOrderReqBO setGoods_tag(String goods_tag) {
        this.goods_tag = goods_tag;
        return this;
    }

    public WXApiUnifiedOrderReqBO setNotify_url(String notify_url) {
        this.notify_url = notify_url;
        return this;
    }

    public WXApiUnifiedOrderReqBO setTrade_type(String trade_type) {
        this.trade_type = trade_type;
        return this;
    }

    public WXApiUnifiedOrderReqBO setProduct_id(String product_id) {
        this.product_id = product_id;
        return this;
    }

    public WXApiUnifiedOrderReqBO setLimit_pay(String limit_pay) {
        this.limit_pay = limit_pay;
        return this;
    }

    public WXApiUnifiedOrderReqBO setOpenid(String openid) {
        this.openid = openid;
        return this;
    }

    public WXApiUnifiedOrderReqBO setSub_openid(String sub_openid) {
        this.sub_openid = sub_openid;
        return this;
    }

    public WXApiUnifiedOrderReqBO setScene_info(String scene_info) {
        this.scene_info = scene_info;
        return this;
    }

    public WXApiUnifiedOrderReqBO setKey(String key) {
        this.sign = Signature.getSign(Util.beanToMapForWxSign(this), key);
        this.key = key;
        return this;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMch_id() {
        return this.mch_id;
    }

    public String getSub_appid() {
        return this.sub_appid;
    }

    public String getSub_mch_id() {
        return this.sub_mch_id;
    }

    public String getDevice_info() {
        return this.device_info;
    }

    public String getNonce_str() {
        return this.nonce_str;
    }

    public String getSign() {
        return this.sign;
    }

    public String getSign_type() {
        return this.sign_type;
    }

    public String getBody() {
        return this.body;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getOut_trade_no() {
        return this.out_trade_no;
    }

    public String getFee_type() {
        return this.fee_type;
    }

    public int getTotal_fee() {
        return this.total_fee;
    }

    public String getSpbill_create_ip() {
        return this.spbill_create_ip;
    }

    public String getTime_start() {
        return this.time_start;
    }

    public String getTime_expire() {
        return this.time_expire;
    }

    public String getGoods_tag() {
        return this.goods_tag;
    }

    public String getNotify_url() {
        return this.notify_url;
    }

    public String getTrade_type() {
        return this.trade_type;
    }

    public String getProduct_id() {
        return this.product_id;
    }

    public String getLimit_pay() {
        return this.limit_pay;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getSub_openid() {
        return this.sub_openid;
    }

    public String getScene_info() {
        return this.scene_info;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "WXApiUnifiedOrderReqBO [appid=" + this.appid + ", mch_id=" + this.mch_id + ", sub_appid=" + this.sub_appid + ", sub_mch_id=" + this.sub_mch_id + ", device_info=" + this.device_info + ", nonce_str=" + this.nonce_str + ", sign=" + this.sign + ", sign_type=" + this.sign_type + ", body=" + this.body + ", detail=" + this.detail + ", attach=" + this.attach + ", out_trade_no=" + this.out_trade_no + ", fee_type=" + this.fee_type + ", total_fee=" + this.total_fee + ", spbill_create_ip=" + this.spbill_create_ip + ", time_start=" + this.time_start + ", time_expire=" + this.time_expire + ", goods_tag=" + this.goods_tag + ", notify_url=" + this.notify_url + ", trade_type=" + this.trade_type + ", product_id=" + this.product_id + ", limit_pay=" + this.limit_pay + ", openid=" + this.openid + ", sub_openid=" + this.sub_openid + ", scene_info=" + this.scene_info + ", key=" + this.key + ", toString()=" + super.toString() + "]";
    }
}

