/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wx.util;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.common.util.MD5;
import com.tydic.payment.pay.wx.util.XMLParser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Signature {
    private static final Logger logger = LoggerFactory.getLogger(Signature.class);

    public static String getSign(Object o, String key) throws IllegalAccessException {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cls = o.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(o) == null || f.get(o) == "") continue;
            list.add(f.getName() + "=" + f.get(o) + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        result = MD5.MD5Encode(result).toUpperCase();
        return result;
    }

    public static String getSign(Map<String, Object> map, String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getValue().toString().trim().equals("")) continue;
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
            logger.info("Sign Befoe [{}==={}]", (Object)entry.getKey(), entry.getValue());
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        logger.info("Sign Before MD5:" + result);
        result = MD5.MD5Encode(result).toUpperCase();
        return result;
    }

    public static String getSignFromResponseString(String responseString, String key) throws IOException, SAXException, ParserConfigurationException {
        Map<String, Object> map = XMLParser.getMapFromXML(responseString);
        map.put("sign", "");
        return Signature.getSign(map, key);
    }

    public static boolean checkIsSignValidFromResponseString(String responseString, String key) throws ParserConfigurationException, IOException, SAXException {
        Map<String, Object> map = XMLParser.getMapFromXML(responseString);
        logger.info(map.toString());
        String signFromAPIResponse = map.get("sign").toString();
        if (signFromAPIResponse == "" || signFromAPIResponse == null) {
            logger.info("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539!!!");
            return false;
        }
        logger.info("\u670d\u52a1\u5668\u56de\u5305\u91cc\u9762\u7684\u7b7e\u540d\u662f:" + signFromAPIResponse);
        map.put("sign", "");
        String signForAPIResponse = Signature.getSign(map, key);
        if (!signForAPIResponse.equals(signFromAPIResponse)) {
            logger.info("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539!!!");
            return false;
        }
        logger.info("\u606d\u559c\uff0cAPI\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7!!!");
        return true;
    }

    public static boolean checkIsSignValidFromAbilityResponse(JSONObject bodyInfoJson, String key) throws ParserConfigurationException, IOException, SAXException {
        JSONObject map = bodyInfoJson;
        logger.info(map.toString());
        String signFromAPIResponse = map.get("SIGN").toString();
        if (signFromAPIResponse == "" || signFromAPIResponse == null) {
            logger.info("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539!!!");
            return false;
        }
        logger.info("\u670d\u52a1\u5668\u56de\u5305\u91cc\u9762\u7684\u7b7e\u540d\u662f:" + signFromAPIResponse);
        map.put("SIGN", "");
        String signForAPIResponse = Signature.getSignFormAbilityResponse((Map<String, Object>)map, key);
        if (!signForAPIResponse.equals(signFromAPIResponse)) {
            logger.info("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539!!!");
            return false;
        }
        logger.info("\u606d\u559c\uff0cAPI\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7!!!");
        return true;
    }

    public static String getSignFormAbilityResponse(Map<String, Object> map, String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getValue().toString().trim().equals("")) continue;
            list.add(entry.getKey().toLowerCase() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        logger.info("Sign Before MD5:" + result);
        result = MD5.MD5Encode(result).toUpperCase();
        return result;
    }
}

