/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.sdk.unionpay;

import com.tydic.payment.pay.sdk.unionpay.BaseHttpSslSocketFactory;
import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpClient {
    private URL url;
    private int connectionTimeout;
    private int readTimeOut;
    private String result;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public HttpClient(String url, int connectionTimeout, int readTimeOut) {
        try {
            this.url = new URL(url);
            this.connectionTimeout = connectionTimeout;
            this.readTimeOut = readTimeOut;
        }
        catch (MalformedURLException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
    }

    public int send(Map<String, String> data, String encoding) throws Exception {
        HttpURLConnection httpURLConnection = this.createConnection(encoding);
        if (null == httpURLConnection) {
            throw new Exception("Create httpURLConnection Failure");
        }
        String sendData = this.getRequestParamString(data, encoding);
        LogUtil.writeLog("\u8bf7\u6c42\u62a5\u6587(\u5bf9\u6bcf\u4e2a\u62a5\u6587\u57df\u7684\u503c\u5747\u5df2\u505aurl\u7f16\u7801):[" + sendData + "]");
        this.requestServer(httpURLConnection, sendData, encoding);
        this.result = this.response(httpURLConnection, encoding);
        LogUtil.writeLog("Response message:[" + this.result + "]");
        return httpURLConnection.getResponseCode();
    }

    public int sendGet(String encoding) throws Exception {
        HttpURLConnection httpURLConnection = this.createConnectionGet(encoding);
        if (null == httpURLConnection) {
            throw new Exception("\u521b\u5efa\u8054\u63a5\u5931\u8d25");
        }
        this.result = this.response(httpURLConnection, encoding);
        LogUtil.writeLog("\u540c\u6b65\u8fd4\u56de\u62a5\u6587:[" + this.result + "]");
        return httpURLConnection.getResponseCode();
    }

    private void requestServer(URLConnection connection, String message, String encoder) throws Exception {
        PrintStream out = null;
        try {
            connection.connect();
            out = new PrintStream(connection.getOutputStream(), false, encoder);
            out.print(message);
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    private String response(HttpURLConnection connection, String encoding) throws URISyntaxException, IOException, Exception {
        InputStream in = null;
        StringBuilder sb = new StringBuilder(1024);
        BufferedReader br = null;
        try {
            int success = 200;
            if (success == connection.getResponseCode()) {
                in = connection.getInputStream();
                sb.append(new String(HttpClient.read(in), encoding));
            } else {
                in = connection.getErrorStream();
                sb.append(new String(HttpClient.read(in), encoding));
            }
            LogUtil.writeLog("HTTP Return Status-Code:[" + connection.getResponseCode() + "]");
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != br) {
                br.close();
            }
            if (null != in) {
                in.close();
            }
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    public static byte[] read(InputStream in) throws IOException {
        byte[] buf = new byte[1024];
        int length = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((length = in.read(buf, 0, buf.length)) > 0) {
            bout.write(buf, 0, length);
        }
        bout.flush();
        return bout.toByteArray();
    }

    private HttpURLConnection createConnection(String encoding) throws ProtocolException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
            return null;
        }
        httpURLConnection.setConnectTimeout(this.connectionTimeout);
        httpURLConnection.setReadTimeout(this.readTimeOut);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=" + encoding);
        httpURLConnection.setRequestMethod("POST");
        String https = "https";
        if (https.equalsIgnoreCase(this.url.getProtocol())) {
            HttpsURLConnection husn = (HttpsURLConnection)httpURLConnection;
            if (!SdkConfig.getConfig().isIfValidateRemoteCert()) {
                husn.setSSLSocketFactory(new BaseHttpSslSocketFactory());
                husn.setHostnameVerifier(new BaseHttpSslSocketFactory.TrustAnyHostnameVerifier());
            }
            return husn;
        }
        return httpURLConnection;
    }

    private HttpURLConnection createConnectionGet(String encoding) throws ProtocolException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
            return null;
        }
        httpURLConnection.setConnectTimeout(this.connectionTimeout);
        httpURLConnection.setReadTimeout(this.readTimeOut);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=" + encoding);
        httpURLConnection.setRequestMethod("GET");
        String https = "https";
        if (https.equalsIgnoreCase(this.url.getProtocol())) {
            HttpsURLConnection husn = (HttpsURLConnection)httpURLConnection;
            if (!SdkConfig.getConfig().isIfValidateRemoteCert()) {
                husn.setHostnameVerifier(new BaseHttpSslSocketFactory.TrustAnyHostnameVerifier());
                husn.setSSLSocketFactory(new BaseHttpSslSocketFactory());
            }
            return husn;
        }
        return httpURLConnection;
    }

    private String getRequestParamString(Map<String, String> requestParam, String coder) {
        if (null == coder || "".equals(coder)) {
            coder = "UTF-8";
        }
        StringBuffer sf = new StringBuffer("");
        String reqstr = "";
        if (null != requestParam && 0 != requestParam.size()) {
            for (Map.Entry<String, String> en : requestParam.entrySet()) {
                try {
                    sf.append(en.getKey() + "=" + (null == en.getValue() || "".equals(en.getValue()) ? "" : URLEncoder.encode(en.getValue(), coder)) + "&");
                }
                catch (UnsupportedEncodingException e) {
                    LogUtil.writeErrorLog(e.getMessage(), e);
                    return "";
                }
            }
            reqstr = sf.substring(0, sf.length() - 1);
        }
        LogUtil.writeLog("Request Message:[" + reqstr + "]");
        return reqstr;
    }
}

