/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.hcx;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class HttpUtils {
    private static final int TIME_OUT = 120000;
    private static final String HTTPS = "https";

    public static Connection.Response get(String url) throws IOException {
        return HttpUtils.get(url, null);
    }

    public static Connection.Response get(String url, Map<String, String> headers) throws IOException {
        if (null == url || url.isEmpty()) {
            throw new RuntimeException("The request URL is blank.");
        }
        if (url.startsWith(HTTPS)) {
            HttpUtils.getTrust();
        }
        Connection connection = Jsoup.connect((String)url);
        connection.method(Connection.Method.GET);
        connection.timeout(120000);
        connection.ignoreHttpErrors(true);
        connection.ignoreContentType(true);
        if (null != headers) {
            connection.headers(headers);
        }
        Connection.Response response = connection.execute();
        return response;
    }

    public static Connection.Response post(String url, String params) throws IOException {
        return HttpUtils.doPostRequest(url, null, null, null, params);
    }

    public static Connection.Response post(String url, Map<String, String> headers, Map<String, String> params, String flag) throws IOException {
        return HttpUtils.doPostRequest(url, headers, params, null, null);
    }

    public static Connection.Response post(String url, Map<String, String> headers) throws IOException {
        return HttpUtils.doPostRequest(url, headers, null, null, null);
    }

    public static Connection.Response post(String url, Map<String, String> paramMap, Map<String, File> fileMap) throws IOException {
        return HttpUtils.doPostRequest(url, null, paramMap, fileMap, null);
    }

    private static Connection.Response doPostRequest(String url, Map<String, String> headers, Map<String, String> paramMap, Map<String, File> fileMap, String jsonParams) throws IOException {
        if (null == url || url.isEmpty()) {
            throw new RuntimeException("The request URL is blank.");
        }
        if (url.startsWith(HTTPS)) {
            HttpUtils.getTrust();
        }
        Connection connection = Jsoup.connect((String)url);
        connection.method(Connection.Method.POST);
        connection.timeout(120000);
        connection.ignoreHttpErrors(true);
        connection.ignoreContentType(true);
        if (null != headers) {
            connection.headers(headers);
        }
        ArrayList<FileInputStream> inputStreamList = null;
        try {
            Connection.Response response;
            if (null != fileMap && !fileMap.isEmpty()) {
                inputStreamList = new ArrayList<FileInputStream>();
                FileInputStream in = null;
                File file = null;
                Set<Map.Entry<String, File>> set = fileMap.entrySet();
                for (Map.Entry<String, File> e : set) {
                    file = e.getValue();
                    in = new FileInputStream(file);
                    inputStreamList.add(in);
                    connection.data(e.getKey(), file.getName(), (InputStream)in);
                }
            } else if (null != jsonParams && !jsonParams.isEmpty()) {
                connection.header("Content-Type", "application/json;charset=UTF-8");
                connection.requestBody(jsonParams);
            } else {
                connection.header("Content-Type", "application/x-www-form-urlencoded");
            }
            if (null != paramMap && !paramMap.isEmpty()) {
                connection.data(paramMap);
            }
            Connection.Response response2 = response = connection.execute();
            return response2;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (null != inputStreamList) {
                for (InputStream inputStream : inputStreamList) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void getTrust() {
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T analysisResponse(Connection.Response response, Class<T> tClass) {
        String body = response.body();
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return (T)JSONObject.parseObject((String)body, tClass);
    }
}

