/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.busi;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.payment.pay.bo.PayPageRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.BillCmpRsListQryWebReqBO;
import com.tydic.payment.pay.web.bo.req.GetBillFileWebServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.BillCmpRsListQryWebRspBO;
import com.tydic.payment.pay.web.bo.rsp.GetBillFileWebServiceRspBo;
import com.tydic.payment.pay.web.service.BillCmpRsListQryWebService;
import com.tydic.payment.pay.web.service.GetBillFileWebService;
import com.tydic.payment.pay.web.service.QueryPaySettleBillFileWebService;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay/rest/accountBalanceM"})
public class AccountBalanceMController {
    private static final Logger log = LoggerFactory.getLogger(AccountBalanceMController.class);
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL")
    private QueryPaySettleBillFileWebService queryPaySettleBillFileWebService;
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL")
    private GetBillFileWebService getBillFileWebService;
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL")
    private BillCmpRsListQryWebService billCmpRsListQryWebService;

    @RequestMapping(value={"/query/billFile/download/fromOss"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void testUploadBillFile(GetBillFileWebServiceReqBo reqBo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("\u4e0b\u8f7d\u6587\u4ef6\u540d\uff1a" + reqBo.getFileName());
        String fileName = reqBo.getFileName();
        if (StringUtils.isEmpty((Object)fileName)) {
            return;
        }
        response.setContentType("multipart/form-data");
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
        GetBillFileWebServiceRspBo pmcGetFileServiceRspBo = this.getBillFileWebService.downloadSingleBillFile(reqBo);
        if (!"0000".equals(pmcGetFileServiceRspBo.getRspCode())) {
            throw new IllegalArgumentException("\u4e0b\u8f7d\u8d26\u5355\u6587\u4ef6\u9519\u8bef\uff1a" + pmcGetFileServiceRspBo.getRspName());
        }
        byte[] dateByte = pmcGetFileServiceRspBo.getDateByte();
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(dateByte);
        outputStream.close();
        outputStream.flush();
    }

    @RequestMapping(value={"/query/billCompare/result"}, method={RequestMethod.POST})
    @ResponseBody
    public PayPageRspBo<RspPage<BillCmpRsListQryWebRspBO>> queryBillCompareResult(BillCmpRsListQryWebReqBO reqBo) {
        log.info("\u8fdb\u5165\u5bf9\u8d26\u7ba1\u7406controller  ->  \u5f53\u524d\u65b9\u6cd5\uff1a\u5206\u9875\u67e5\u8be2\u5bf9\u8d26\u6587\u4ef6\u5bf9\u8d26\u7ed3\u679c");
        try {
            PayPageRspBo payPageRspBo = new PayPageRspBo();
            payPageRspBo.setRespCode("0000");
            payPageRspBo.setRespDesc("\u6210\u529f");
            payPageRspBo.setData(null);
            if (reqBo == null) {
                payPageRspBo.setRespDesc("\u67e5\u8be2\u5bf9\u8d26\u6587\u4ef6\u5bf9\u8d26\u7ed3\u679c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
                return payPageRspBo;
            }
            if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
                payPageRspBo.setRespDesc("\u67e5\u8be2\u5bf9\u8d26\u6587\u4ef6\u5bf9\u8d26\u7ed3\u679c\u5165\u53c2\u7684\u4e1a\u52a1\u7cfb\u7edfID\u4e3a\u7a7a");
                return payPageRspBo;
            }
            RspPage queryList = this.billCmpRsListQryWebService.qryBillCmpRsList(reqBo);
            payPageRspBo.setData(queryList);
            payPageRspBo.setRespCode("0000");
            payPageRspBo.setRespDesc("\u6210\u529f");
            return payPageRspBo;
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }
}

