/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.notify;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.comb.PayProProcessNoticeCombService;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombRspBo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay/rest"})
public class PayProNotifyController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL")
    private PayProProcessNoticeCombService payProProcessNoticeCombService;

    @RequestMapping(value={"/receiveWopayMobile"})
    @ResponseBody
    public String aliQrPayNotify(HttpServletRequest request, HttpServletResponse resp) {
        this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u4e86pro");
        Enumeration parameterNames = request.getParameterNames();
        this.LOGGER.info("----------\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u5f00\u59cb\u6253\u5370\u5165\u53c2-------------------");
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            System.out.println("\u63a5\u53d7\u5230\u503c\uff0c" + key + "=" + request.getParameter(key));
        }
        this.LOGGER.info("----------\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u7ed3\u675f\u6253\u5370\u5165\u53c2-------------------");
        String callbackData = request.getParameter("param");
        if (StringUtils.isEmpty((Object)callbackData)) {
            this.LOGGER.error("\u5904\u7406\u6c83\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff1a\u5165\u53c2param\u4e3a\u7a7a\u4e86");
            return "FAILED";
        }
        callbackData = callbackData.replaceAll("\\s", "+");
        PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
        noticeCombBo.setPayMethod(Long.valueOf(50L));
        noticeCombBo.setReqData(callbackData);
        PayProProcessNoticeCombRspBo payProProcessNoticeCombRspBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
        if (!"0000".equals(payProProcessNoticeCombRspBo.getRespCode())) {
            this.LOGGER.error("\u5904\u7406\u6c83\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff1a" + payProProcessNoticeCombRspBo.getRespDesc());
            return "FAILED";
        }
        this.LOGGER.debug("\u6c83\u652f\u4ed8\u56de\u8c03\u5904\u7406\u6210\u529f\uff0c\u8ba2\u5355id\uff1a" + payProProcessNoticeCombRspBo.getPayOrderId());
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dealBestPayNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void dealBestPayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------------\u7ffc\u652f\u4ed8\u56de\u8c03-------------------------------");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            ServletInputStream inputStream = request.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            inputStream.close();
            String notifyInfo = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            notifyInfo = URLDecoder.decode(notifyInfo, "UTF-8");
            this.LOGGER.info("\u7ffc\u652f\u4ed8\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(150L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            JSONObject resultJson = new JSONObject();
            resultJson.put("statusCode", (Object)"200");
            String isSuccess = "success";
            String errorCode = null;
            String errorMsg = null;
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25\uff1a" + noticeRetBo.getRespDesc());
                isSuccess = "false";
                errorCode = noticeRetBo.getRespCode();
                errorMsg = noticeRetBo.getRespDesc();
                resultJson.put("statusCode", (Object)"500");
            }
            JSONObject retJson = new JSONObject();
            retJson.put("success", isSuccess);
            retJson.put("errorCode", errorCode);
            retJson.put("errorMsg", errorMsg);
            retJson.put("result", resultJson);
            String backStr = JSONObject.toJSONString((Object)retJson);
            this.LOGGER.info("\u8fd4\u56de\u7ed9\u7ffc\u652f\u4ed8\u7684\u62a5\u6587\u4e3a\uff1a" + backStr);
            out.write(backStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/receiveAliPayNotify"})
    @ResponseBody
    public void aliPayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------\u652f\u4ed8\u5b9d\u7684\u56de\u8c03\u6765\u4e86(>_<)-----------------------------------");
        OutputStream out = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = request.getParameter(key);
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(29L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            out = response.getOutputStream();
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                out.write("fail".getBytes());
            } else {
                out.write("success".getBytes());
            }
            out.flush();
        }
        catch (Exception e) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

